package li.vin.my.apikit.services

import android.net.Uri
import li.vin.my.apikit.api.DeviceAPI
import li.vin.my.apikit.models.Device
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints
import li.vin.my.apikit.network.ProfileImageEncoderHelper

/**
 * 1/10/19.
 */
class UpdateDeviceService(val deviceID: String, val name: String?, val icon: Uri?, val caseId: String) :
    BaseService<Device>() {

    override fun createCall() {
        val request = createService(DeviceAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.updateDevice(
            deviceID, name
                ?: caseId, ProfileImageEncoderHelper.encodeImageData(icon), caseId, getCookies()
        )
    }
}