package li.vin.my.apikit.services

import android.net.Uri
import li.vin.my.apikit.api.DeviceAPI
import li.vin.my.apikit.models.Device
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints
import li.vin.my.apikit.network.ProfileImageEncoderHelper

/**
 * 1/9/19.
 */
class CreateDeviceService(val name: String?, val icon: Uri?, val caseId: String) : BaseService<Device>() {

    override fun createCall() {
        val request = createService(DeviceAPI::class.java, Endpoints.getAuthBaseUrl())
        call = request.createDevice(
            name
                ?: caseId, ProfileImageEncoderHelper.encodeImageData(icon), caseId, getCookies()
        )
    }
}