package li.vin.my.apikit.network;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;

import java.io.*;

/**
 * 1/9/19.
 */

public class ProfileImageEncoderHelper {

    public static String encodeImageData(Uri imagePath) {
        if (imagePath == null) {
            return "";
        }
        InputStream inputStream = iconInStr(imagePath);
        ExifInterface exifInterface = null;
        try {
            exifInterface = new ExifInterface(imagePath.getPath());
        } catch (IOException e) {
            e.printStackTrace();
        }
        String imageData;
        try {
            byte[] bytes = bitmapToBytes(decodeSampledBitmapFromStream(exifInterface, inputStream, 140, 140),
                    Bitmap.CompressFormat.PNG, 100);
            imageData = "data:image/png;base64," + Base64.encodeToString(bytes, Base64.NO_WRAP);
        } catch (OutOfMemoryError | Exception err) {
            return "";
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            } catch (Exception ignored) {
            }
        }
        return imageData;
    }

    @Nullable
    private static InputStream iconInStr(Uri iconPath) {
        InputStream is = null;
        if (iconPath != null) {
            try {
                is = new FileInputStream(iconPath.getPath());
            } catch (Exception ignored) {
            }
        }
        return is;
    }

    private static byte[] bitmapToBytes(@NonNull Bitmap bmp, @NonNull Bitmap.CompressFormat format,
                                        int quality) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bmp.compress(format, quality, stream);
        return stream.toByteArray();
    }

    private static Bitmap decodeSampledBitmapFromStream(@Nullable ExifInterface exifInterface, @NonNull InputStream is, int reqWidth,
                                                        int reqHeight) throws IOException {
        if (!is.markSupported()) {
            int r;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((r = is.read(buf)) != -1) {
                baos.write(buf, 0, r);
            }
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        is.mark(Integer.MAX_VALUE);

        // First decode with inJustDecodeBounds=true to check dimensions
        final BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream(is, null, options);

        try {
            is.reset();
        } catch (IOException ignored) {
        }

        // Calculate inSampleSize
        options.inSampleSize = calculateInSampleSize(options, reqWidth, reqHeight);

        // Decode bitmap with inSampleSize set
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeStream(is, null, options);
        Bitmap adjustedBitmap = null;
        if (exifInterface != null) {
            int rotation = exifInterface.getAttributeInt(ExifInterface.TAG_ORIENTATION, ExifInterface.ORIENTATION_NORMAL);
            int rotationInDegrees = exifToDegrees(rotation);
            Matrix matrix = new Matrix();
            if (rotation != 0) {
                matrix.preRotate(rotationInDegrees);
            }
            adjustedBitmap = Bitmap.createBitmap(bitmap, 0, 0, reqWidth, reqHeight, matrix, true);
        }
        return adjustedBitmap != null ? adjustedBitmap : bitmap;
    }

    private static int exifToDegrees(int exifOrientation) {
        if (exifOrientation == ExifInterface.ORIENTATION_ROTATE_90) {
            return 90;
        } else if (exifOrientation == ExifInterface.ORIENTATION_ROTATE_180) {
            return 180;
        } else if (exifOrientation == ExifInterface.ORIENTATION_ROTATE_270) {
            return 270;
        }
        return 0;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth,
                                             int reqHeight) {
        // Raw height and width of image
        final int height = options.outHeight;
        final int width = options.outWidth;
        int inSampleSize = 1;

        if (height > reqHeight || width > reqWidth) {

            final int halfHeight = height / 2;
            final int halfWidth = width / 2;

            // Calculate the largest inSampleSize value that is a power of 2 and keeps both
            // height and width larger than the requested height and width.
            while ((halfHeight / inSampleSize) > reqHeight && (halfWidth / inSampleSize) > reqWidth) {
                inSampleSize *= 2;
            }
        }

        return inSampleSize;
    }
}
