package li.vin.my.apikit.services

import li.vin.my.apikit.api.EventsAPI
import li.vin.my.apikit.models.Events
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class EventsDeviceService(val since: Long, val limit: Long, val until: Long) : BaseService<Events>() {

    override fun createCall() {
        val request = createService(EventsAPI::class.java, Endpoints.getEventsUrl())
        call = request.getDeviceEvents(getDeviceId(), since, limit, until, getCookies())
    }
}