/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit.services;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.api.OdometerAPI;
import li.vin.my.apikit.models.Odometer;
import li.vin.my.apikit.models.OdometerPost;
import li.vin.my.apikit.models.OdometerPostData;
import li.vin.my.apikit.network.BaseService;
import li.vin.my.apikit.network.Endpoints;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lli/vin/my/apikit/services/OdometerService;", "Lli/vin/my/apikit/network/BaseService;", "Lli/vin/my/apikit/models/Odometer;", "value", "", "unit", "", "(ILjava/lang/String;)V", "getUnit", "()Ljava/lang/String;", "getValue", "()I", "createCall", "", "apikit_release"})
public final class OdometerService
extends BaseService<Odometer> {
    private final int value;
    @NotNull
    private final String unit;

    @Override
    protected void createCall() {
        OdometerAPI request = this.createService(OdometerAPI.class, Endpoints.Companion.getDistanceUrl());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        String formattedDate = sdf.format(new Date().getTime() - (long)10800000);
        OdometerPost odometerPost = new OdometerPost(new OdometerPostData(this.value, formattedDate, this.unit));
        this.setCall(request.setOdometer(this.getVehicleId(), odometerPost));
    }

    public final int getValue() {
        return this.value;
    }

    @NotNull
    public final String getUnit() {
        return this.unit;
    }

    public OdometerService(int value, @NotNull String unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
        this.value = value;
        this.unit = unit;
    }
}

