package li.vin.my.apikit.services

import li.vin.my.apikit.AuthSettings
import li.vin.my.apikit.api.EmergencyContactsAPI
import li.vin.my.apikit.models.Contact
import li.vin.my.apikit.models.ContactWrapper
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

class EmergencyContactsCreateContactService(
    val contactType: String,
    val name: String,
    val number: String,
    val message: String
) : BaseService<ContactWrapper>() {

    override fun createCall() {

        val request = createService(EmergencyContactsAPI::class.java, Endpoints.getAuthBaseUrl())
        val contact = Contact(
            null,
            AuthSettings.instance.getDeviceId(),
            name,
            number,
            contactType,
            null,
            null,
            message,
            null,
            null,
            null,
            null
        )
        val contactWrapper = ContactWrapper(contact)
        call = request.createContact(contactWrapper, getCookies())
    }
}