package li.vin.my.apikit.services

import li.vin.my.apikit.api.UserAPI
import li.vin.my.apikit.models.*
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/10/18.
 */
class UserCreateService(
    private val firstName: String, private val lastName: String, private val email: String, private val phone: String,
    private val password: String, private val unit: MeasureType
) : BaseService<User>() {

    override fun createCall() {
        val request = createService(UserAPI::class.java, Endpoints.getAuthBaseUrl())
        val userData = UserPostData(email, firstName, lastName, password, phone, UserPostSettings(unit.value))
        val session = UserPost(userData)
        call = request.createUser(session)
    }
}