package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * 11/2/18.
 */
data class EngineData(
    @SerializedName("codes") val codes: List<Codes>?,
    @SerializedName("meta") val meta: Meta?
)

data class Codes(
    @SerializedName("id") val id: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("vehicleId") val vehicleId: String?,
    @SerializedName("number") val number: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("start") val start: Date?,
    @SerializedName("stop") val stop: Date?,
    @SerializedName("links") val links: CodeLinks?
)

data class CodeLinks(
    @SerializedName("code") val code: String?,
    @SerializedName("device") val device: String?,
    @SerializedName("vehicle") val vehicle: String?
)
/**
{
"codes": [
{
"id": "6a67a96d-bd84-4909-9ab9-d520bdf35e9b",
"deviceId": "a544107b-d8ca-4df4-bfef-4c1ea32e5c88",
"vehicleId": "8581410e-142d-4330-aef0-83be0f503b0c",
"number": "P0101",
"description": "Mass or Volume Air Flow Sensor \"A\" Circuit Range/Performance",
"start": "2015-11-10T00:35:11.662Z",
"stop": null,
"links": {
"code": "http://10.100.132.66:39002/api/v1/codes/4472ea34-d7a9-43fa-a4d9-130112e4f6f2",
"device": "https://platform.vin.li/api/v1/devices/a544107b-d8ca-4df4-bfef-4c1ea32e5c88",
"vehicle": "https://platform.vin.li/api/v1/vehicles/8581410e-142d-4330-aef0-83be0f503b0c"
}
},
{
"id": "4e9d4410-d893-407b-8c12-47693d7654cc",
"deviceId": "378e6894-e79f-4efd-9fb8-5873b1c7a337",
"vehicleId": "8581410e-142d-4330-aef0-83be0f503b0c",
"number": "U0118",
"description": "Lost Communication With Fuel Additive Control Module",
"start": "2015-11-06T20:32:07.024Z",
"stop": "2015-11-06T23:32:05.844Z",
"links": {
"code": "http://10.100.132.66:39002/api/v1/codes/f8d62a87-35bf-4f0a-80b6-dfcedc11703e",
"device": "https://platform.vin.li/api/v1/devices/378e6894-e79f-4efd-9fb8-5873b1c7a337",
"vehicle": "https://platform.vin.li/api/v1/vehicles/8581410e-142d-4330-aef0-83be0f503b0c"
}
}
],
"meta": {
"pagination": {
"remaining": 8957,
"until": "2015-11-11T01:25:21.777Z",
"since": "1970-01-01T00:00:00.000Z",
"limit": 20,
"sortDir": "desc",
"links": {
"prior": "http://10.100.132.66:39002/api/v1/vehicles/8581410e-142d-4330-aef0-83be0f503b0c/codes?until=1446841927023&since=1970-01-01T00%3A00%3A00.000Z&limit=20&sortDir=desc"
}
}
}
}
 */