package li.vin.my.apikit.api

import li.vin.my.apikit.models.SecurityStatus
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path
import retrofit2.http.Query

/**
 * 1/6/19.
 */
interface SecurityAPI {

    @GET("/api/v1/devices/{deviceId}/securityStatus")
    fun getSecurityStatus(
        @Path("deviceId") deviceId: String,
        @Query("lat") lat: Double,
        @Query("lon") lon: Double,
        @Query("timestamp") timestamp: Long,
        @Header("Authorization") auth: String
    ): Call<SecurityStatus>

}