package li.vin.my.apikit.api

import li.vin.my.apikit.models.VinliApps
import retrofit2.Call
import retrofit2.http.DELETE
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path

/**
 * 1/22/19.
 */
interface VinliAppsAPI {

    @GET("/api/v1/apps")
    fun getApps(@Header("Cookie") sessionCookie: String): Call<VinliApps>

    @DELETE("/api/v1/apps/{appId}")
    fun revokeApp(
        @Path("appId") appId: String,
        @Header("Cookie") sessionCookie: String
    ): Call<Void>
}