/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit.services;

import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.AuthSettings;
import li.vin.my.apikit.api.TheftAPI;
import li.vin.my.apikit.models.Session;
import li.vin.my.apikit.models.SessionData;
import li.vin.my.apikit.models.TheftData;
import li.vin.my.apikit.models.TheftEvent;
import li.vin.my.apikit.models.TheftNotification;
import li.vin.my.apikit.models.TheftPushData;
import li.vin.my.apikit.models.TheftPushSubscription;
import li.vin.my.apikit.network.BaseService;
import li.vin.my.apikit.network.Endpoints;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u000e"}, d2={"Lli/vin/my/apikit/services/TheftService;", "Lli/vin/my/apikit/network/BaseService;", "Ljava/lang/Void;", "timeStamp", "", "title", "body", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getTimeStamp", "getTitle", "createCall", "", "apikit_release"})
public final class TheftService
extends BaseService<Void> {
    @NotNull
    private final String timeStamp;
    @NotNull
    private final String title;
    @NotNull
    private final String body;

    @Override
    protected void createCall() {
        TheftAPI request = this.createService(TheftAPI.class, Endpoints.Companion.getVinliBaseUrl());
        Session session = (Session)new Gson().fromJson(AuthSettings.Companion.getInstance().getCurrentSessionString(), Session.class);
        SessionData sessionData = session.getSession();
        TheftData userData = new TheftData(this.title, this.body, this.getDeviceId(), true, sessionData != null ? sessionData.getId() : null);
        TheftPushData subscriptionData = new TheftPushData(new TheftPushSubscription(userData), new TheftEvent(this.timeStamp));
        TheftNotification notification = new TheftNotification(subscriptionData);
        this.setCall(request.theftNotification(notification));
    }

    @NotNull
    public final String getTimeStamp() {
        return this.timeStamp;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    public TheftService(@NotNull String timeStamp, @NotNull String title, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)timeStamp, (String)"timeStamp");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        this.timeStamp = timeStamp;
        this.title = title;
        this.body = body;
    }
}

