package li.vin.my.apikit.services

import li.vin.my.apikit.api.CommentsAPI
import li.vin.my.apikit.models.CommentPostBody
import li.vin.my.apikit.models.Comments
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * 12/18/18.
 */
class CommentUpdateService(
    private val tripId: String,
    private val commentId: String,
    private val body: String,
    private val deviceID: String
) : BaseService<Comments>() {

    override fun createCall() {
        val request = createService(CommentsAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.updateComment(tripId, commentId, CommentPostBody(deviceID, body), getAuthToken())
    }
}