package li.vin.my.apikit.models

import java.util.HashMap


enum class ReportPeriod constructor(private val value: String) {
    DAILY("daily"),
    WEEKLY("weekly"),
    MONTHLY("monthly");

    companion object {

        private val map = HashMap<String, ReportPeriod>()

        init {
            for (unitType in ReportPeriod.values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): ReportPeriod {
            return map[value]!!
        }
    }

    fun getValue(): String {
        return value
    }
}