package li.vin.my.apikit.network

import java.util.*

/**
 * 10/31/18.
 */
class ServiceQueue {

    private val serviceList = ArrayList<Queueable>()
    private val responseDataList: LinkedHashMap<Int, Any> = LinkedHashMap()
    private var responseHandler: QueueResponseHandler? = null
    private var errorEncountered = false

    /**
     * Add the list of ApiServices as separate parameters.
     */
    fun addServices(vararg services: Queueable): ServiceQueue {
        for (service in services) {
            serviceList.add(service)
        }
        return this
    }

    /**
     * Method to start the Api calls of the added Services
     */
    fun startServices(responseHandler: QueueResponseHandler) {
        this.responseHandler = responseHandler
        for ((count, queueable) in serviceList.withIndex()) {
            queueable.setBaseResponseHandler(responseHandler)
            queueable.startServiceInQueue(this, count)
        }
    }

    /**
     * This method is called after a service gets a response
     */
    fun serviceCompleted(responseData: Any, queuePosition: Int) {
        responseDataList[queuePosition] = responseData
        if (allServicesCompleted()) {
            if (errorEncountered) {
                errorEncountered = false
            } else {
                val sortedMap = responseDataList.toList().sortedBy { (key, _) -> key }.toMap()
                responseHandler?.onSuccess(sortedMap.values.toList())
            }
        }
    }

    fun serviceError(throwable: Throwable) {
        errorEncountered = true
        responseHandler?.onError(throwable)
    }

    /**
     * Checks if all the services has been executed
     */
    private fun allServicesCompleted(): Boolean = serviceList.size == responseDataList.size

    /**
     * Call this method, To reuse the [ServiceQueue] object.
     */
    fun clear() {
        serviceList.clear()
        responseDataList.clear()
        errorEncountered = false
    }

}