package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName

/**
 * 12/8/18.
 */
data class Config(
    @SerializedName("APP") val APP: ConfigApp?,
    @SerializedName("mapbox") val mapbox: ConfigMapBox?,
    @SerializedName("stripe") val stripe: ConfigStripe?,
    @SerializedName("tos") val tos: ConfigTos?
)

data class ConfigApp(
    @SerializedName("servicesDisabled") val servicesDisabled: Boolean?,
    @SerializedName("stackName") val stackName: String?,
    @SerializedName("root") val root: String?
)

data class ConfigMapBox(@SerializedName("accessToken") val accessToken: String?)

data class ConfigStripe(@SerializedName("publishableKey") val publishableKey: String?)

data class ConfigTos(@SerializedName("tosVinliMainId") val tosVinliMainId: String?)

/**
{
"APP": {
"servicesDisabled": true,
"stackName": "prod",
"root": "catalog-apps"
},
"mapbox": {
"accessToken": "pk.eyJ1IjoidmlubGkiLCJhIjoiYmYwNTAxZGQzY2ZmMGMzYTVjMGE4MTFiNWYyMTZhNjIifQ.a6YRWBIGFQPwAW12j8RPVg"
},
"stripe": {
"publishableKey": "pk_live_4YP7Nbb02cQ2DRJgFhaQ3YXZ"
},
"tos": {
"tosVinliMainId": "882a2271-69af-4a27-ad03-fb87bd452141"
}
}

 */