package li.vin.my.apikit.api

import li.vin.my.apikit.models.Badges
import li.vin.my.apikit.models.TripBadges
import retrofit2.Call
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.Path

/**
 * 12/29/18.
 */
interface BadgesAPI {

    @GET("/api/v1/trips/{tripId}/badges")
    fun getTripBadges(@Path("tripId") tripId: String, @Header("Authorization") auth: String): Call<TripBadges>

    @GET("/api/v1/devices/{deviceId}/badges/overall")
    fun getOverallDeviceBadges(@Path("deviceId") deviceId: String, @Header("Authorization") auth: String): Call<Badges>
}