/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit.network;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProfileImageEncoderHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeImageData(Uri imagePath) {
        String imageData;
        if (imagePath == null) {
            return "";
        }
        InputStream inputStream = ProfileImageEncoderHelper.iconInStr(imagePath);
        ExifInterface exifInterface = null;
        try {
            exifInterface = new ExifInterface(imagePath.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            byte[] bytes = ProfileImageEncoderHelper.bitmapToBytes(ProfileImageEncoderHelper.decodeSampledBitmapFromStream(exifInterface, inputStream, 140, 140), Bitmap.CompressFormat.PNG, 100);
            imageData = "data:image/png;base64," + Base64.encodeToString((byte[])bytes, (int)2);
        }
        catch (Exception | OutOfMemoryError err) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return imageData;
    }

    @Nullable
    private static InputStream iconInStr(Uri iconPath) {
        FileInputStream is = null;
        if (iconPath != null) {
            try {
                is = new FileInputStream(iconPath.getPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is;
    }

    private static byte[] bitmapToBytes(@NonNull Bitmap bmp, @NonNull Bitmap.CompressFormat format, int quality) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bmp.compress(format, quality, (OutputStream)stream);
        return stream.toByteArray();
    }

    private static Bitmap decodeSampledBitmapFromStream(@Nullable ExifInterface exifInterface, @NonNull InputStream is, int reqWidth, int reqHeight) throws IOException {
        if (!is.markSupported()) {
            int r;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((r = is.read(buf)) != -1) {
                baos.write(buf, 0, r);
            }
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        is.mark(Integer.MAX_VALUE);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        try {
            is.reset();
        }
        catch (IOException buf) {
            // empty catch block
        }
        options.inSampleSize = ProfileImageEncoderHelper.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
        Bitmap adjustedBitmap = null;
        if (exifInterface != null) {
            int rotation = exifInterface.getAttributeInt("Orientation", 1);
            int rotationInDegrees = ProfileImageEncoderHelper.exifToDegrees(rotation);
            Matrix matrix = new Matrix();
            if (rotation != 0) {
                matrix.preRotate((float)rotationInDegrees);
            }
            adjustedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)reqWidth, (int)reqHeight, (Matrix)matrix, (boolean)true);
        }
        return adjustedBitmap != null ? adjustedBitmap : bitmap;
    }

    private static int exifToDegrees(int exifOrientation) {
        if (exifOrientation == 6) {
            return 90;
        }
        if (exifOrientation == 3) {
            return 180;
        }
        if (exifOrientation == 8) {
            return 270;
        }
        return 0;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

