/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.apikit.network;

import com.google.gson.Gson;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import li.vin.my.apikit.ApiKit;
import li.vin.my.apikit.AuthSettings;
import li.vin.my.apikit.errors.ConflictException;
import li.vin.my.apikit.errors.DataNotFoundException;
import li.vin.my.apikit.errors.GenericError;
import li.vin.my.apikit.errors.GenericErrorException;
import li.vin.my.apikit.network.BaseResponseHandler;
import li.vin.my.apikit.network.GsonConverter;
import li.vin.my.apikit.network.Poolable;
import li.vin.my.apikit.network.Queueable;
import li.vin.my.apikit.network.ReceivedCookiesInterceptor;
import li.vin.my.apikit.network.ResponseHandler;
import li.vin.my.apikit.network.ServicePool;
import li.vin.my.apikit.network.ServiceQueue;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003H\u0016J\b\u0010(\u001a\u00020&H$J'\u0010)\u001a\u0002H*\"\u0004\b\u0001\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010-\u001a\u00020\u0011\u00a2\u0006\u0002\u0010.J\u0006\u0010/\u001a\u00020&J\b\u00100\u001a\u00020&H\u0016J\u0006\u00101\u001a\u00020\u0011J\u0006\u00102\u001a\u00020\u0011J\u0006\u00103\u001a\u00020\u0011J\u0014\u00104\u001a\u00020\u00112\f\u00105\u001a\b\u0012\u0004\u0012\u00028\u000006J\u0006\u00107\u001a\u00020\u0011J\u0014\u00108\u001a\u00020&2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u000009J\u0010\u0010:\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010;\u001a\u00020&H\u0002J\u0018\u0010<\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lli/vin/my/apikit/network/BaseService;", "Pojo", "Lli/vin/my/apikit/network/Queueable;", "Lli/vin/my/apikit/network/Poolable;", "()V", "call", "Lretrofit2/Call;", "getCall", "()Lretrofit2/Call;", "setCall", "(Lretrofit2/Call;)V", "isCanceled", "", "()Z", "setCanceled", "(Z)V", "poolId", "", "getPoolId", "()Ljava/lang/String;", "queuePosition", "", "responseHandler", "Lli/vin/my/apikit/network/BaseResponseHandler;", "getResponseHandler", "()Lli/vin/my/apikit/network/BaseResponseHandler;", "setResponseHandler", "(Lli/vin/my/apikit/network/BaseResponseHandler;)V", "result", "Ljava/lang/Object;", "serviceQueue", "Lli/vin/my/apikit/network/ServiceQueue;", "successful", "getSuccessful", "setSuccessful", "throwable", "", "completed", "", "poolable", "createCall", "createService", "T", "serviceClass", "Ljava/lang/Class;", "baseUrl", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "endService", "execute", "getAuthToken", "getCookies", "getDeviceId", "getErrorMessage", "response", "Lretrofit2/Response;", "getVehicleId", "requestData", "Lli/vin/my/apikit/network/ResponseHandler;", "setBaseResponseHandler", "startService", "startServiceInQueue", "apikit_release"})
public abstract class BaseService<Pojo>
implements Queueable,
Poolable {
    @NotNull
    public Call<Pojo> call;
    @NotNull
    public BaseResponseHandler responseHandler;
    private ServiceQueue serviceQueue;
    private int queuePosition;
    private Pojo result;
    private Throwable throwable;
    private boolean isCanceled;
    private boolean successful;

    @NotNull
    public final Call<Pojo> getCall() {
        Call<Pojo> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        }
        return call;
    }

    public final void setCall(@NotNull Call<Pojo> call) {
        Intrinsics.checkParameterIsNotNull(call, (String)"<set-?>");
        this.call = call;
    }

    protected abstract void createCall();

    @NotNull
    public final BaseResponseHandler getResponseHandler() {
        BaseResponseHandler baseResponseHandler = this.responseHandler;
        if (baseResponseHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"responseHandler");
        }
        return baseResponseHandler;
    }

    public final void setResponseHandler(@NotNull BaseResponseHandler baseResponseHandler) {
        Intrinsics.checkParameterIsNotNull((Object)baseResponseHandler, (String)"<set-?>");
        this.responseHandler = baseResponseHandler;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean bl) {
        this.isCanceled = bl;
    }

    public final boolean getSuccessful() {
        return this.successful;
    }

    public final void setSuccessful(boolean bl) {
        this.successful = bl;
    }

    public final void requestData(@NotNull ResponseHandler<? super Pojo> responseHandler) {
        Intrinsics.checkParameterIsNotNull(responseHandler, (String)"responseHandler");
        this.responseHandler = responseHandler;
        this.createCall();
        if (!this.isCanceled()) {
            ServicePool.INSTANCE.enter(this);
        }
    }

    @NotNull
    public final String getDeviceId() {
        if (ApiKit.Companion.getInstance().isDebug()) {
            return "f3e779ea-56ba-41d7-90f9-c074e8a0ec6b";
        }
        return AuthSettings.Companion.getInstance().getDeviceId();
    }

    @NotNull
    public final String getVehicleId() {
        if (ApiKit.Companion.getInstance().isDebug()) {
            return "e977cf48-f30d-4d9c-b3a6-338be1ef7691";
        }
        return AuthSettings.Companion.getInstance().getVehicleId();
    }

    @NotNull
    public final String getCookies() {
        if (ApiKit.Companion.getInstance().isDebug()) {
            return "session=Fe26.2**4f8c7b90e3196ae979c1a089201e3e52cea7bdd12c19aebb45abb09b1392180c*lde_vt18XS8oMEptfCy2OQ*0J_IKMWmHmkw5_9h3Cl5oSN9Xm3WwC9A7IRUEXn_wSkO3bQhLCnHAXJVVTosi_85**a006d6a1498f339dc5b1ddc839376247006780bbc75229f2b9b1dfa5bddca15b*Bi3yiZ_qOjdK82KvASOVAmYPS8gD23ii2lXfsYahuss";
        }
        return AuthSettings.Companion.getInstance().getSessionId();
    }

    @NotNull
    public final String getAuthToken() {
        if (ApiKit.Companion.getInstance().isDebug()) {
            return "Bearer SBJRXcYsxe7jzHnRqgaK1vMyDaHKBesgDh9iigyoOGbMREzf_3NPdIAHRkWcy5hK";
        }
        return AuthSettings.Companion.getInstance().getAuthToken();
    }

    private final void startService() {
        Call<Pojo> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        }
        call.clone().enqueue(new Callback<Pojo>(this){
            final /* synthetic */ BaseService this$0;

            /*
             * Unable to fully structure code
             */
            public void onResponse(@NotNull Call<Pojo> call, @NotNull retrofit2.Response<Pojo> response) {
                block6: {
                    block7: {
                        block5: {
                            Intrinsics.checkParameterIsNotNull(call, (String)"call");
                            Intrinsics.checkParameterIsNotNull(response, (String)"response");
                            if (!response.isSuccessful()) break block5;
                            this.this$0.setSuccessful(true);
                            BaseService.access$setResult$p(this.this$0, response.body());
                            break block6;
                        }
                        if (response.code() != 409) break block7;
                        this.this$0.setSuccessful(false);
                        BaseService.access$setThrowable$p(this.this$0, new ConflictException());
                        break block6;
                    }
                    if (response.body() == null) ** GOTO lbl-1000
                    if (response.body() instanceof List) {
                        v0 = response.body();
                        if (v0 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                        }
                        ** if (((List)v0).size() != 0) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        this.this$0.setSuccessful(false);
                        BaseService.access$setThrowable$p(this.this$0, new DataNotFoundException());
                        ** GOTO lbl26
                    }
lbl-1000:
                    // 2 sources

                    {
                        if (response.code() != 200) {
                            BaseService.access$setThrowable$p(this.this$0, new GenericErrorException(this.this$0.getErrorMessage(response)));
                            this.this$0.setSuccessful(false);
                        }
                    }
                }
                ServicePool.INSTANCE.leave(this.this$0);
                this.this$0.endService();
            }

            public void onFailure(@NotNull Call<Pojo> call, @NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                this.this$0.setSuccessful(false);
                BaseService.access$setThrowable$p(this.this$0, new Exception(t));
                ServicePool.INSTANCE.leave(this.this$0);
                this.this$0.endService();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void endService() {
        if (this.serviceQueue != null) {
            if (this.successful) {
                ServiceQueue serviceQueue = this.serviceQueue;
                if (serviceQueue != null) {
                    Pojo Pojo = this.result;
                    if (Pojo == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
                    }
                    serviceQueue.serviceCompleted(Pojo, this.queuePosition);
                }
            } else {
                ServiceQueue serviceQueue = this.serviceQueue;
                if (serviceQueue != null) {
                    Throwable throwable = this.throwable;
                    if (throwable == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"throwable");
                    }
                    serviceQueue.serviceError(throwable);
                }
            }
            return;
        }
        if (this.successful) {
            BaseResponseHandler baseResponseHandler = this.responseHandler;
            if (baseResponseHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"responseHandler");
            }
            if (baseResponseHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type li.vin.my.apikit.network.ResponseHandler<Pojo>");
            }
            ((ResponseHandler)baseResponseHandler).onSuccess(this.result);
        } else {
            BaseResponseHandler baseResponseHandler = this.responseHandler;
            if (baseResponseHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"responseHandler");
            }
            if (baseResponseHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type li.vin.my.apikit.network.ResponseHandler<Pojo>");
            }
            ResponseHandler responseHandler = (ResponseHandler)baseResponseHandler;
            Throwable throwable = this.throwable;
            if (throwable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"throwable");
            }
            responseHandler.onError(throwable);
        }
    }

    @NotNull
    public final String getErrorMessage(@NotNull retrofit2.Response<Pojo> response) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        String errorMessage = "";
        if (response.errorBody() != null) {
            Gson gson = new Gson();
            ResponseBody responseBody = response.errorBody();
            GenericError genericError = (GenericError)gson.fromJson(responseBody != null ? responseBody.string() : null, GenericError.class);
            errorMessage = genericError.getMessage();
        }
        return (charSequence = (CharSequence)errorMessage).length() == 0 ? GenericError.Companion.getErrorMessage(response.code()) : errorMessage;
    }

    public final <T> T createService(@NotNull Class<T> serviceClass, @NotNull String baseUrl) {
        Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        if (Intrinsics.areEqual((Object)AuthSettings.Companion.getInstance().getAuthToken(), (Object)"Bearer") ^ true || ApiKit.Companion.getInstance().isDebug()) {
            okHttpClientBuilder.addInterceptor(new Interceptor(this){
                final /* synthetic */ BaseService this$0;

                public final Response intercept(Interceptor.Chain chain) {
                    Request original = chain.request();
                    Request.Builder requestBuilder = original.newBuilder().header("Authorization", this.this$0.getAuthToken()).method(original.method(), original.body());
                    Request request = requestBuilder.build();
                    return chain.proceed(request);
                }
                {
                    this.this$0 = baseService;
                }
            });
        }
        long cacheSize = 0xA00000L;
        Cache cacheDir = new Cache(ApiKit.Companion.getInstance().getCacheDir(), cacheSize);
        okHttpClientBuilder.cache(cacheDir);
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        okHttpClientBuilder.addInterceptor((Interceptor)logging);
        okHttpClientBuilder.addInterceptor((Interceptor)new ReceivedCookiesInterceptor());
        return (T)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GsonConverter.INSTANCE.getGsonConverter())).client(okHttpClientBuilder.build()).build().create(serviceClass);
    }

    @Override
    public void startServiceInQueue(@NotNull ServiceQueue serviceQueue, int queuePosition) {
        Intrinsics.checkParameterIsNotNull((Object)serviceQueue, (String)"serviceQueue");
        this.serviceQueue = serviceQueue;
        this.queuePosition = queuePosition;
        this.createCall();
        if (!this.isCanceled()) {
            ServicePool.INSTANCE.enter(this);
        }
    }

    @Override
    public void setBaseResponseHandler(@NotNull BaseResponseHandler responseHandler) {
        Intrinsics.checkParameterIsNotNull((Object)responseHandler, (String)"responseHandler");
        this.responseHandler = responseHandler;
    }

    @Override
    public void execute() {
        this.startService();
    }

    @Override
    public void completed(@NotNull Poolable poolable) {
        Intrinsics.checkParameterIsNotNull((Object)poolable, (String)"poolable");
        if (poolable instanceof BaseService) {
            Throwable throwable;
            Pojo duplicate;
            Pojo Pojo = duplicate = ((BaseService)poolable).result;
            if (Pojo != null) {
                Pojo Pojo2;
                Pojo it = Pojo2 = Pojo;
                boolean bl = false;
                this.successful = true;
                this.result = duplicate;
                this.endService();
                return;
            }
            Throwable throwable2 = ((BaseService)poolable).throwable;
            if (throwable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"throwable");
            }
            Throwable it = throwable = throwable2;
            boolean bl = false;
            this.successful = false;
            this.throwable = it;
            this.endService();
        }
    }

    @Override
    @NotNull
    public String getPoolId() {
        Call<Pojo> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        }
        String string = call.request().url().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"call.request().url().toString()");
        return string;
    }

    public static final /* synthetic */ Object access$getResult$p(BaseService $this) {
        return $this.result;
    }

    public static final /* synthetic */ void access$setResult$p(BaseService $this, Object object) {
        $this.result = object;
    }

    public static final /* synthetic */ Throwable access$getThrowable$p(BaseService $this) {
        Throwable throwable = $this.throwable;
        if (throwable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"throwable");
        }
        return throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(BaseService $this, Throwable throwable) {
        $this.throwable = throwable;
    }
}

