package li.vin.my.apikit.services

import li.vin.my.apikit.api.AlertsAPI
import li.vin.my.apikit.models.AlertPost
import li.vin.my.apikit.models.AlertWrapper
import li.vin.my.apikit.network.BaseService
import li.vin.my.apikit.network.Endpoints

/**
 * Created by stephensheaffer on 1/28/19.
 */
class CreateAlertService(val postData: AlertPost) : BaseService<AlertWrapper>() {

    override fun createCall() {
        val request = createService(AlertsAPI::class.java, Endpoints.getVinliBaseUrl())
        call = request.createAlert(getDeviceId(), postData, getAuthToken())
    }
}