package li.vin.my.apikit.network

import li.vin.my.apikit.ApiKit
import okhttp3.HttpUrl


/**
 * 11/1/18.
 */

class Endpoints {

    companion object {

        const val GOOGLE_MAPS = "https://maps.googleapis.com"
        const val STRIPE_URL = "https://api.stripe.com"
        const val MAPBOX_URL = "https://api.mapbox.com"
        const val AUTH = "auth."
        const val MYVINLI = "my-vinli."
        const val DIAGNOSTICS = "diagnostic."
        const val TOS = "tos."
        const val EVENTS = "events."
        const val PLATFORM = "platform."
        const val RULES = "rules."
        const val TELEMETRY = "telemetry."
        const val TRIPS = "trips."
        const val SAFETY = "safety."
        const val BEHAVIORAL = "behavioral."
        const val DISTANCE = "distance."
        const val DUMMY = "dummies."

        fun getAuthBaseUrl(): String {
            return HttpUrl.Builder().scheme("https").host(AUTH + ApiKit.instance.baseUrl).build().toString()
        }

        fun getDiagnosticsUrl(): String {
            return HttpUrl.Builder().scheme("https").host(DIAGNOSTICS + ApiKit.instance.baseUrl).build().toString()
        }

        fun getTelemetryUrl(): String {
            return HttpUrl.Builder().scheme("https").host(TELEMETRY + ApiKit.instance.baseUrl).build().toString()
        }

        fun getVinliBaseUrl(): String {
            return HttpUrl.Builder().scheme("https").host(MYVINLI + ApiKit.instance.baseUrl).build().toString()
        }

        fun getDistanceUrl(): String {
            return HttpUrl.Builder().scheme("https").host(DISTANCE + ApiKit.instance.baseUrl).build().toString()
        }

        fun getTosUrl(): String {
            return HttpUrl.Builder().scheme("https").host(TOS + ApiKit.instance.baseUrl).build().toString()
        }

        fun getCompatabilityUrl(envActive: String, hostName: String): String {
            return String.format("https://compatibility%s.%s", envActive, hostName)
        }

        fun getInputUrl(hostName: String): String {
            return String.format("https://input-us-1.%s", hostName)
        }
    }
}
