package li.vin.my.apikit.models

import java.util.*

/**
 * 1/14/19.
 */
enum class EventType constructor(val value: String) {

    STARTUP("startup"),
    SHUTDOWN("shutdown"),
    RULE_ENTER("rule_enter"),
    RULE_LEAVE("rule_leave"),
    DTC_ON("dtc-on"),
    DTC_OFF("dtc-off"),
    COLLISION("collision"),
    TRIP_STARTED("trip-started"),
    TRIP_ORPHANED("trip-orphaned"),
    TRIP_STOPPED("trip-stopped"),
    TRIP_COMPLETED("trip-completed"),
    DISTANCE_TRIGGER("distance-trigger");

    companion object {

        private val map = HashMap<String, EventType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): EventType {
            return map[value]!!
        }
    }
}