package li.vin.my.apikit.models

import com.google.gson.annotations.SerializedName
import java.util.*

/**
 * Created by stephensheaffer on 1/28/19.
 */
data class AlertHistory(
    @SerializedName("history") val history: List<AlertHistoryData>?,
    @SerializedName("meta") val meta: Meta?
)

data class AlertList(
    @SerializedName("alerts") val alerts: List<Alert>?,
    @SerializedName("meta") val meta: Meta?
)

data class AlertHistoryData(
    @SerializedName("id") val id: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("eventType") val eventType: String?,
    @SerializedName("timestamp") val timestamp: Date?,
    @SerializedName("alert") val alert: Alert?
)

data class Alert(
    @SerializedName("id") var id: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("ruleId") val ruleId: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("ruleType") val ruleType: AlertRuleType?,
    @SerializedName("eventType") val eventType: AlertEventType?,
    @SerializedName("enabled") val enabled: Boolean?,
    @SerializedName("alertType") val alertType: String?,
    @SerializedName("config") val config: AlertConfig?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("updatedAt") val updatedAt: Date?
)

data class AlertConfig(
    @SerializedName("label") val label: String?,
    @SerializedName("phone") val phone: String?
)

data class AlertWrapper(@SerializedName("alert") val alert: Alert?)

// Post
data class AlertPost(
    @SerializedName("alert") val alert: AlertPostData?,
    @SerializedName("rule") val rule: AlertRuleData?
)

data class AlertPostData(
    @SerializedName("alertType") val alertType: String?,
    @SerializedName("eventType") val eventType: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("config") val config: AlertConfig?
)

data class AlertRuleData(
    @SerializedName("name") val name: String?,
    @SerializedName("boundaries") val boundaries: List<AlertRulesBoundaries>?
)

data class AlertRulesBoundaries(
    @SerializedName("lat") val lat: Double?,
    @SerializedName("lon") val lon: Double?,
    @SerializedName("radius") val radius: Double?,
    @SerializedName("type") val type: String?,
    @SerializedName("max") val max: Int?,
    @SerializedName("min") val min: Int?,
    @SerializedName("parameter") val parameter: String?
)

data class Rule(@SerializedName("rule") val rule: RuleData?)

data class RuleData(
    @SerializedName("id") val id: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("appId") val appId: String?,
    @SerializedName("deviceId") val deviceId: String?,
    @SerializedName("object") val ruleObject: RuleObject?,
    @SerializedName("boundaries") val boundaries: List<AlertRulesBoundaries>?,
    @SerializedName("evaluated") val evaluated: Boolean?,
    @SerializedName("covered") val covered: Boolean?,
    @SerializedName("duration") val duration: Int?,
    @SerializedName("createdAt") val createdAt: Date?,
    @SerializedName("links") val links: RuleLinks?
)

data class RuleObject(
    @SerializedName("type") val type: String?,
    @SerializedName("id") val id: String?
)

data class RuleLinks(
    @SerializedName("self") val self: String?,
    @SerializedName("events") val events: String?,
    @SerializedName("subscriptions") val subscriptions: String?
)

data class BusAlertPost(
    @SerializedName("alertType") val alertType: String?,
    @SerializedName("ruleType") val ruleType: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("config") val config: AlertConfig?
)

enum class AlertEventType constructor(val value: String) {
    ENTER("rule-enter"),
    LEAVE("rule-leave"),
    GEO("rule-*"),
    EMPTY("");

    companion object {

        private val map = HashMap<String, AlertEventType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): AlertEventType {
            return map[value]!!
        }
    }
}

enum class AlertRuleType constructor(val value: String) {
    FUEL("fuel alert"),
    SPEED("parametric"),
    RADIUS("radius"),
    ENGINE_CODE("dtc-on");

    companion object {

        private val map = HashMap<String, AlertRuleType>()

        init {
            for (unitType in values()) {
                map[unitType.value] = unitType
            }
        }

        fun unitTypeByValue(value: String): AlertRuleType {
            return map[value]!!
        }
    }
}