package li.vin.my.apikit.api

import li.vin.my.apikit.models.*
import retrofit2.Call
import retrofit2.http.*

/**
 * Created by stephensheaffer on 1/28/19.
 */
interface AlertsAPI {

    @GET("/api/v1/devices/{deviceId}/alerts_history")
    fun getHistory(@Path("deviceId") deviceId: String, @Header("Authorization") auth: String): Call<AlertHistory>

    @POST("/api/v1/devices/{deviceId}/rule-alerts")
    fun createAlert(@Path("deviceId") deviceId: String, @Body body: AlertPost, @Header("Authorization") auth: String): Call<AlertWrapper>

    @GET("/api/v1/devices/{deviceId}/rule-alerts")
    fun getAlerts(@Path("deviceId") deviceId: String, @Header("Authorization") auth: String): Call<AlertList>

    @GET("/api/v1/rules/{ruleId}")
    fun getRule(@Path("ruleId") ruleId: String, @Header("Authorization") auth: String): Call<Rule>

    @PUT("/api/v1/devices/{deviceId}/rule-alerts/{alertId}")
    fun updateAlert(
        @Path("deviceId") deviceId: String, @Path("alertId") alertId: String, @Body body: AlertPost, @Header(
            "Authorization"
        ) auth: String
    ): Call<Void>

    @DELETE("/api/v1/devices/{deviceId}/rule-alerts/{alertId}")
    fun deleteAlert(@Path("deviceId") deviceId: String, @Path("alertId") alertId: String, @Header("Authorization") auth: String): Call<Void>

    @POST("/api/v1/devices/{deviceId}/bus-alerts")
    fun createBusAlert(@Path("deviceId") deviceId: String, @Body body: BusAlertPost, @Header("Authorization") auth: String): Call<Alert>

    @DELETE("/api/v1/devices/{deviceId}/bus-alerts/alert/{alertId}")
    fun deleteBusAlert(@Path("deviceId") deviceId: String, @Path("alertId") alertId: String, @Header("Authorization") auth: String): Call<Void>
}
