/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import li.vin.net.BatteryStatus;
import li.vin.net.Collision;
import li.vin.net.Collisions;
import li.vin.net.Coordinate;
import li.vin.net.Device;
import li.vin.net.Devices;
import li.vin.net.Diagnostics;
import li.vin.net.DistanceList;
import li.vin.net.Distances;
import li.vin.net.Dtc;
import li.vin.net.Endpoint;
import li.vin.net.Event;
import li.vin.net.Events;
import li.vin.net.Location;
import li.vin.net.Locations;
import li.vin.net.Message;
import li.vin.net.Messages;
import li.vin.net.Notification;
import li.vin.net.Notifications;
import li.vin.net.ObjectRef;
import li.vin.net.Odometer;
import li.vin.net.OdometerTrigger;
import li.vin.net.Page;
import li.vin.net.ReportCard;
import li.vin.net.ReportCards;
import li.vin.net.Rule;
import li.vin.net.Rules;
import li.vin.net.Snapshot;
import li.vin.net.Snapshots;
import li.vin.net.StreamMessage;
import li.vin.net.Subscription;
import li.vin.net.Subscriptions;
import li.vin.net.TimeSeries;
import li.vin.net.Trip;
import li.vin.net.Trips;
import li.vin.net.User;
import li.vin.net.Users;
import li.vin.net.Vehicle;
import li.vin.net.Vehicles;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public final class VinliApp {
    private final Devices mDevices;
    private final Diagnostics mDiagnostics;
    private final Rules mRules;
    private final Events mEvents;
    private final Locations mLocations;
    private final Snapshots mSnapshots;
    private final Vehicles mVehicles;
    private final Subscriptions mSubscriptions;
    private final Users mUsers;
    private final Trips mTrips;
    private final Distances mDistances;
    private final Messages mMessages;
    private final Collisions mCollisions;
    private final ReportCards mReportCards;
    private final Notifications mNotifications;
    private final Gson mGson;
    private final String mAccessToken;
    private OkHttpClient client;
    static OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();

    public GsonBuilder gsonBuilder() {
        GsonBuilder gsonB = new GsonBuilder();
        Device.registerGson(gsonB);
        Rule.registerGson(gsonB);
        Event.registerGson(gsonB);
        Subscription.registerGson(gsonB);
        Vehicle.registerGson(gsonB);
        Message.registerGson(gsonB);
        Page.registerGson(gsonB);
        TimeSeries.registerGson(gsonB);
        ObjectRef.registerGson(gsonB);
        Location.registerGson(gsonB);
        Coordinate.registerGson(gsonB);
        Snapshot.registerGson(gsonB);
        Notification.registerGson(gsonB);
        User.registerGson(gsonB);
        Trip.registerGson(gsonB);
        DistanceList.registerGson(gsonB);
        Odometer.registerGson(gsonB);
        OdometerTrigger.registerGson(gsonB);
        Dtc.registerGson(gsonB);
        StreamMessage.ParametricFilter.registerGson(gsonB);
        StreamMessage.GeometryFilter.registerGson(gsonB);
        Message.registerGson(gsonB);
        Collision.registerGson(gsonB);
        ReportCard.registerGson(gsonB);
        BatteryStatus.registerGson(gsonB);
        return gsonB;
    }

    Observable<? extends Page<? extends VinliItem>> pagingPageObservable(Class itemClz, String link) {
        if (Device.class.equals((Object)itemClz)) {
            return this.mDevices.devicesForUrl(link.replaceFirst(Endpoint.PLATFORM.getUrl(), ""));
        }
        if (Dtc.Code.class.equals((Object)itemClz)) {
            return this.mDiagnostics.rawCodesForUrl(link.replaceFirst(Endpoint.DIAGNOSTICS.getUrl(), ""));
        }
        if (Rule.class.equals((Object)itemClz)) {
            return this.mRules.rulesForUrl(link.replaceFirst(Endpoint.RULES.getUrl(), ""));
        }
        if (Subscription.class.equals((Object)itemClz)) {
            return this.mSubscriptions.subscriptionsForUrl(link.replaceFirst(Endpoint.EVENTS.getUrl(), ""));
        }
        if (Vehicle.class.equals((Object)itemClz)) {
            return this.mVehicles.vehiclesForUrl(link.replaceFirst(Endpoint.PLATFORM.getUrl(), ""));
        }
        throw new RuntimeException(String.format("no paging observable for %s : %s", link, itemClz.getSimpleName()));
    }

    Observable<? extends TimeSeries<? extends VinliItem>> pagingTsObservable(Class itemClz, String link) {
        if (Message.class.equals((Object)itemClz)) {
            return this.mMessages.messagesForUrl(link.replaceFirst(Endpoint.TELEMETRY.getUrl(), ""));
        }
        if (Snapshot.class.equals((Object)itemClz)) {
            return this.mSnapshots.snapshotsForUrl(link.replaceFirst(Endpoint.TELEMETRY.getUrl(), ""));
        }
        if (Location.LocationTimeSeriesAdapter.class.equals((Object)itemClz)) {
            return this.mLocations.locationsForUrl(link.replaceFirst(Endpoint.TELEMETRY.getUrl(), ""));
        }
        if (Collision.class.equals((Object)itemClz)) {
            return this.mCollisions.collisionsForUrl(link.replaceFirst(Endpoint.SAFETY.getUrl(), ""));
        }
        if (Dtc.class.equals((Object)itemClz)) {
            return this.mDiagnostics.codesForUrl(link.replaceFirst(Endpoint.DIAGNOSTICS.getUrl(), ""));
        }
        if (Odometer.class.equals((Object)itemClz)) {
            return this.mDistances.odometerReportsForUrl(link.replaceFirst(Endpoint.DISTANCE.getUrl(), ""));
        }
        if (OdometerTrigger.class.equals((Object)itemClz)) {
            return this.mDistances.odometerTriggersForUrl(link.replaceFirst(Endpoint.DISTANCE.getUrl(), ""));
        }
        if (Event.class.equals((Object)itemClz)) {
            return this.mEvents.eventsForUrl(link.replaceFirst(Endpoint.EVENTS.getUrl(), ""));
        }
        if (Notification.class.equals((Object)itemClz)) {
            return this.mNotifications.notificationsForUrl(link.replaceFirst(Endpoint.EVENTS.getUrl(), ""));
        }
        if (ReportCard.class.equals((Object)itemClz)) {
            return this.mReportCards.reportCardsForUrl(link.replaceFirst(Endpoint.BEHAVIORAL.getUrl(), ""));
        }
        if (Trip.class.equals((Object)itemClz)) {
            return this.mTrips.tripsForUrl(link.replaceFirst(Endpoint.TRIPS.getUrl(), ""));
        }
        throw new RuntimeException(String.format("no paging observable for %s : %s", link, itemClz.getSimpleName()));
    }

    VinliApp(@NonNull String accessToken) {
        this.mAccessToken = accessToken;
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                Log.d((String)"VinliNet", (String)message);
            }
        });
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        this.client = clientBuilder.build().newBuilder().addInterceptor((Interceptor)new OauthInterceptor(accessToken)).addInterceptor((Interceptor)loggingInterceptor).readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
        this.mGson = this.gsonBuilder().create();
        GsonConverterFactory gsonConverterFactory = GsonConverterFactory.create((Gson)this.mGson);
        RxJavaCallAdapterFactory rxJavaCallAdapterFactory = RxJavaCallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io());
        Retrofit platformAdapter = new Retrofit.Builder().baseUrl(Endpoint.PLATFORM.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build();
        this.mDevices = (Devices)platformAdapter.create(Devices.class);
        this.mVehicles = (Vehicles)platformAdapter.create(Vehicles.class);
        this.mDiagnostics = (Diagnostics)new Retrofit.Builder().baseUrl(Endpoint.DIAGNOSTICS.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(Diagnostics.class);
        this.mRules = (Rules)new Retrofit.Builder().baseUrl(Endpoint.RULES.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(Rules.class);
        Retrofit eventsAdapter = new Retrofit.Builder().baseUrl(Endpoint.EVENTS.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build();
        this.mEvents = (Events)eventsAdapter.create(Events.class);
        this.mSubscriptions = (Subscriptions)eventsAdapter.create(Subscriptions.class);
        this.mNotifications = (Notifications)eventsAdapter.create(Notifications.class);
        Retrofit telemAdapter = new Retrofit.Builder().baseUrl(Endpoint.TELEMETRY.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build();
        this.mLocations = (Locations)telemAdapter.create(Locations.class);
        this.mSnapshots = (Snapshots)telemAdapter.create(Snapshots.class);
        this.mMessages = (Messages)telemAdapter.create(Messages.class);
        this.mUsers = (Users)new Retrofit.Builder().baseUrl(Endpoint.AUTH.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(Users.class);
        this.mTrips = (Trips)new Retrofit.Builder().baseUrl(Endpoint.TRIPS.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(Trips.class);
        this.mDistances = (Distances)new Retrofit.Builder().baseUrl(Endpoint.DISTANCE.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(Distances.class);
        this.mCollisions = (Collisions)new Retrofit.Builder().baseUrl(Endpoint.SAFETY.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(Collisions.class);
        this.mReportCards = (ReportCards)new Retrofit.Builder().baseUrl(Endpoint.BEHAVIORAL.getUrl()).client(this.client).addConverterFactory((Converter.Factory)gsonConverterFactory).addCallAdapterFactory((CallAdapter.Factory)rxJavaCallAdapterFactory).build().create(ReportCards.class);
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public Observable<Page<Device>> devices() {
        return this.mDevices.devices(null, null);
    }

    public Observable<Page<Device>> devices(@Nullable Integer limit, @Nullable Integer offset) {
        return this.mDevices.devices(limit, offset);
    }

    public Observable<Device> device(@NonNull String deviceId) {
        return this.mDevices.device(deviceId).map(Wrapped.pluckItem());
    }

    public Observable<Vehicle> vehicle(@NonNull String vehicleId) {
        return this.mVehicles.vehicle(vehicleId).map(Wrapped.pluckItem());
    }

    public Observable<Dtc.Code> diagnoseDtcCode(String number) {
        return this.mDiagnostics.diagnose(number).flatMap(Page.allItems());
    }

    public Observable<User> currentUser() {
        return this.mUsers.currentUser().map(Wrapped.pluckItem());
    }

    public Observable<Trip> trip(@NonNull String tripId) {
        return this.mTrips.trip(tripId).map(Wrapped.pluckItem());
    }

    public Observable<Rule> rule(@NonNull String ruleId) {
        return this.mRules.rule(ruleId).map(Wrapped.pluckItem());
    }

    public Observable<Collision> collision(@NonNull String collisionId) {
        return this.mCollisions.collision(collisionId).map(Wrapped.pluckItem());
    }

    public Observable<Subscription> subscription(@NonNull String subscriptionId) {
        return this.mSubscriptions.subscription(subscriptionId).map(Wrapped.pluckItem());
    }

    public Observable<Odometer> odometerReport(@NonNull String odometerId) {
        return this.mDistances.odometerReport(odometerId).map(Wrapped.pluckItem());
    }

    public Observable<OdometerTrigger> odometerTrigger(@NonNull String odometerTriggerId) {
        return this.mDistances.odometerTrigger(odometerTriggerId).map(Wrapped.pluckItem());
    }

    public Observable<ReportCard> reportCard(@NonNull String reportCardId) {
        return this.mReportCards.reportCard(reportCardId).map(Wrapped.pluckItem());
    }

    public Observable<Message> message(@NonNull String messageId) {
        return this.mMessages.message(messageId).map(Wrapped.pluckItem());
    }

    public Observable<Notification> notification(@NonNull String notificationId) {
        return this.mNotifications.notification(notificationId).map(Wrapped.pluckItem());
    }

    public Observable<Event> event(@NonNull String eventId) {
        return this.mEvents.event(eventId).map(Wrapped.pluckItem());
    }

    Devices devicesSvc() {
        return this.mDevices;
    }

    Vehicles vehicles() {
        return this.mVehicles;
    }

    Rules rules() {
        return this.mRules;
    }

    Events events() {
        return this.mEvents;
    }

    Locations locations() {
        return this.mLocations;
    }

    Snapshots snapshots() {
        return this.mSnapshots;
    }

    Subscriptions subscriptions() {
        return this.mSubscriptions;
    }

    Trips trips() {
        return this.mTrips;
    }

    Distances distances() {
        return this.mDistances;
    }

    Messages messages() {
        return this.mMessages;
    }

    Diagnostics diagnostics() {
        return this.mDiagnostics;
    }

    Collisions collisions() {
        return this.mCollisions;
    }

    ReportCards reportCards() {
        return this.mReportCards;
    }

    Notifications notifications() {
        return this.mNotifications;
    }

    Gson gson() {
        return this.mGson;
    }

    private static final class OauthInterceptor
    implements Interceptor {
        private static final String AUTH = "Authorization";
        private final String mBearer;

        public OauthInterceptor(String accessToken) {
            this.mBearer = "Bearer " + accessToken;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request original = chain.request();
            Request request = original.newBuilder().header(AUTH, this.mBearer).build();
            return chain.proceed(request);
        }
    }
}

