/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import li.vin.net.Endpoint;
import li.vin.net.ObserverManager;
import li.vin.net.SignInActivity;
import li.vin.net.VinliApp;
import rx.Observable;
import rx.Observer;

public final class Vinli {
    static final String VINLI_PREFS = "li.vin.net.Vinli";
    static final String SIGN_IN_ERROR = "li.vin.net.Vinli#SIGN_IN_ERROR";
    static final String ACCESS_TOKEN = "li.vin.net.Vinli#ACCESS_TOKEN";
    private static VinliApp sApp = null;

    public static void signIn(@NonNull Activity context, @NonNull String clientId, @NonNull String redirectUri, @NonNull PendingIntent pendingIntent) {
        CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
        }
        cookieSyncManager.sync();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.flush();
        }
        context.startActivity(SignInActivity.newIntent((Context)context, clientId, redirectUri, pendingIntent));
    }

    @Nullable
    public static String getSignInError(@NonNull Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null) {
            return null;
        }
        return extras.getString(SIGN_IN_ERROR);
    }

    static void setCurrentApp(@NonNull VinliApp vinliApp) {
        sApp = vinliApp;
    }

    public static void clearApp(@NonNull Context context) {
        context.getSharedPreferences(VINLI_PREFS, 0).edit().putString(ACCESS_TOKEN, null).apply();
        sApp = null;
    }

    @Nullable
    public static VinliApp initApp(Context context, @NonNull Intent intent) {
        Bundle extras;
        if (sApp == null && (extras = intent.getExtras()) != null) {
            String accessToken = extras.getString("li.vin.my.access_token");
            if (accessToken == null) {
                accessToken = extras.getString(ACCESS_TOKEN);
            }
            if (accessToken != null) {
                context.getSharedPreferences(VINLI_PREFS, 0).edit().putString(ACCESS_TOKEN, accessToken).apply();
                sApp = new VinliApp(accessToken);
            }
        }
        return Vinli.loadApp(context);
    }

    @Nullable
    public static VinliApp initApp(Context context, @NonNull String accessToken) {
        if (sApp == null) {
            context.getSharedPreferences(VINLI_PREFS, 0).edit().putString(ACCESS_TOKEN, accessToken).apply();
            sApp = new VinliApp(accessToken);
        }
        return Vinli.loadApp(context);
    }

    @Nullable
    public static VinliApp loadApp(@NonNull Context context) {
        String accessToken;
        if (sApp == null && (accessToken = context.getSharedPreferences(VINLI_PREFS, 0).getString(ACCESS_TOKEN, null)) != null) {
            sApp = new VinliApp(accessToken);
        }
        return sApp;
    }

    static VinliApp curApp() {
        if (sApp == null) {
            throw new IllegalStateException("no current app exists");
        }
        return sApp;
    }

    public static <T> void registerObserver(@NonNull Observer<T> observer, @NonNull Observable<T> observable) {
        ObserverManager.registerObserver(observer, observable);
    }

    public static void unregisterObserver(@NonNull Observer<?> observer) {
        ObserverManager.unregisterObserver(observer);
    }

    private static void setEnvironmentToDev() {
        Endpoint.setDomain("-dev.vin.li");
    }

    private static void setEnvironmentToDemo() {
        Endpoint.setDomain("-demo.vin.li");
    }

    private static void setEnvironmentToQA() {
        Endpoint.setDomain("-qa.vin.li");
    }

    private Vinli() {
    }
}

