/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Subscription;
import li.vin.net.AutoParcel_Subscription_Links;
import li.vin.net.AutoParcel_Subscription_SeedCreate;
import li.vin.net.AutoParcel_Subscription_SeedEdit;
import li.vin.net.Notification;
import li.vin.net.ObjectRef;
import li.vin.net.Page;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class Subscription
implements VinliItem {
    static final Type PAGE_TYPE = new TypeToken<Page<Subscription>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Subscription>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Subscription.class, AutoParcelAdapter.create(AutoParcel_Subscription.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Subscription.class));
        gb.registerTypeAdapter(PAGE_TYPE, Page.Adapter.create(PAGE_TYPE, Subscription.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Subscription_Links.class));
        gb.registerTypeAdapter(SeedCreate.class, (Object)new SeedCreate.Adapter());
        gb.registerTypeAdapter(SeedEdit.class, (Object)new SeedEdit.Adapter());
    }

    public static final SeedCreate.Saver create() {
        return new AutoParcel_Subscription_SeedCreate.Builder();
    }

    public static Observable<Subscription> subscriptionWithId(@NonNull String subscriptionId) {
        return Vinli.curApp().subscription(subscriptionId);
    }

    public static Observable<Page<Subscription>> subscriptionsWithDeviceId(@NonNull String deviceId) {
        return Subscription.subscriptionsWithDeviceId(deviceId, null, null, null, null);
    }

    public static Observable<Page<Subscription>> subscriptionsWithDeviceId(@NonNull String deviceId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String objectId, @Nullable String objectType) {
        return Vinli.curApp().subscriptions().subscriptions(deviceId, limit, offset, objectId, objectType);
    }

    public static Observable<Page<Subscription>> subscriptionsWithVehicleId(@NonNull String vehicleId) {
        return Subscription.subscriptionsWithVehicleId(vehicleId, null, null, null, null);
    }

    public static Observable<Page<Subscription>> subscriptionsWithVehicleId(@NonNull String vehicleId, @Nullable Integer limit, @Nullable Integer offset, @Nullable String objectId, @Nullable String objectType) {
        return Vinli.curApp().subscriptions().vehicleSubscriptions(vehicleId, limit, offset, objectId, objectType);
    }

    public abstract String deviceId();

    public abstract String vehicleId();

    public abstract String eventType();

    public abstract String url();

    @Nullable
    public abstract ObjectRef object();

    public abstract String appData();

    public abstract String createdAt();

    public abstract String updatedAt();

    abstract Links links();

    Subscription() {
    }

    public Observable<TimeSeries<Notification>> notifications() {
        return this.notifications(null, null, null, null);
    }

    public Observable<TimeSeries<Notification>> notifications(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().notifications().notificationsForSubscription(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public SeedEdit.Saver edit() {
        return new AutoParcel_Subscription_SeedEdit.Builder().appData(this.appData()).url(this.url()).deviceId(this.deviceId()).subscriptionId(this.id());
    }

    public Observable<Void> delete() {
        return Vinli.curApp().subscriptions().delete(this.id());
    }

    public static abstract class SeedEdit {
        public abstract String url();

        @Nullable
        public abstract String appData();

        abstract String deviceId();

        abstract String subscriptionId();

        SeedEdit() {
        }

        static final class Adapter
        extends TypeAdapter<SeedEdit> {
            Adapter() {
            }

            public void write(JsonWriter out, SeedEdit value) throws IOException {
                out.beginObject();
                out.name("subscription").beginObject();
                out.name("url").value(value.url());
                out.name("appData").value(value.appData());
                out.endObject();
                out.endObject();
            }

            public SeedEdit read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("reading a Subscription.SeedEdit is not supported");
            }
        }

        public static abstract class Saver {
            public abstract Saver url(String var1);

            public abstract Saver appData(@Nullable String var1);

            abstract Saver deviceId(String var1);

            abstract Saver subscriptionId(String var1);

            Saver() {
            }

            abstract SeedEdit autoBuild();

            public Observable<Subscription> save() {
                SeedEdit se = this.autoBuild();
                return Vinli.curApp().subscriptions().edit(se.deviceId(), se.subscriptionId(), se).map(Wrapped.pluckItem());
            }
        }
    }

    public static abstract class SeedCreate {
        public abstract String eventType();

        @Nullable
        public abstract ObjectRef object();

        public abstract String url();

        @Nullable
        public abstract String appData();

        @Nullable
        public abstract String deviceId();

        @Nullable
        public abstract String vehicleId();

        SeedCreate() {
        }

        static final class Adapter
        extends TypeAdapter<SeedCreate> {
            private Gson gson;

            Adapter() {
            }

            public void write(JsonWriter out, SeedCreate value) throws IOException {
                if (this.gson == null) {
                    this.gson = Vinli.curApp().gson();
                }
                out.beginObject();
                out.name("subscription").beginObject();
                out.name("eventType").value(value.eventType());
                out.name("object");
                this.gson.toJson((Object)value.object(), ObjectRef.class, out);
                out.name("url").value(value.url());
                out.name("appData").value(value.appData());
                out.endObject();
                out.endObject();
            }

            public SeedCreate read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("reading a Subscription.SeedCreate is not supported");
            }
        }

        public static abstract class Saver {
            public abstract Saver eventType(String var1);

            public abstract Saver object(@Nullable ObjectRef var1);

            public abstract Saver url(String var1);

            public abstract Saver appData(@Nullable String var1);

            public abstract Saver deviceId(String var1);

            public abstract Saver vehicleId(String var1);

            Saver() {
            }

            abstract SeedCreate autoBuild();

            public Observable<Subscription> save() {
                SeedCreate sc = this.autoBuild();
                return Vinli.curApp().subscriptions().create(sc.deviceId(), sc).map(Wrapped.pluckItem());
            }

            public Observable<Subscription> vehicleSave() {
                SeedCreate sc = this.autoBuild();
                return Vinli.curApp().subscriptions().vehicleCreate(sc.vehicleId(), sc).map(Wrapped.pluckItem());
            }
        }
    }

    static interface Builder {
        public Builder id(String var1);

        public Builder deviceId(String var1);

        public Builder vehicleId(String var1);

        public Builder eventType(String var1);

        public Builder url(String var1);

        public Builder object(ObjectRef var1);

        public Builder appData(String var1);

        public Builder createdAt(String var1);

        public Builder updatedAt(String var1);

        public Builder links(Links var1);

        public Subscription build();
    }

    static abstract class Links {
        public abstract String self();

        public abstract String notifications();

        Links() {
        }

        static interface Builder {
            public Builder self(String var1);

            public Builder notifications(String var1);

            public Links build();
        }
    }
}

