/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import li.vin.net.Coordinate;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;

public class Snapshot
implements VinliItem {
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Snapshot>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Snapshot>>(){}.getType();
    private String id;
    private String timestamp;
    private LinkedTreeMap<String, Object> data;
    Links links;
    private static final Parcelable.Creator<Snapshot> CREATOR = new Parcelable.Creator<Snapshot>(){

        public Snapshot createFromParcel(Parcel in) {
            return new Snapshot(in);
        }

        public Snapshot[] newArray(int size) {
            return new Snapshot[size];
        }
    };

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, Snapshot.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Snapshot.class));
    }

    public static Observable<TimeSeries<Snapshot>> snapshotsWithDeviceId(@NonNull String deviceId, @NonNull String fields) {
        return Snapshot.snapshotsWithDeviceId(deviceId, fields, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Snapshot>> snapshotsWithDeviceId(@NonNull String deviceId, @NonNull String fields, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().snapshots().snapshots(deviceId, fields, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Snapshot>> snapshotsWithDeviceId(@NonNull String deviceId, @NonNull String fields, @Nullable Date until, @Nullable Date since, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().snapshots().snapshots(deviceId, fields, untilMs, sinceMs, limit, sortDir);
    }

    public static Observable<TimeSeries<Snapshot>> snapshotsWithVehicleId(@NonNull String vehicleId, @NonNull String fields) {
        return Snapshot.snapshotsWithVehicleId(vehicleId, fields, null, null, null, null);
    }

    public static Observable<TimeSeries<Snapshot>> snapshotsWithVehicleId(@NonNull String vehicleId, @NonNull String fields, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().snapshots().vehicleSnapshots(vehicleId, fields, sinceMs, untilMs, limit, sortDir);
    }

    Snapshot() {
    }

    Snapshot(Parcel in) {
        Gson gson = new Gson();
        Snapshot snapshot = (Snapshot)gson.fromJson(in.readString(), Snapshot.class);
        this.id = snapshot.id();
        this.timestamp = snapshot.timestamp;
        this.data = snapshot.data;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public String rawVal(@NonNull String key) {
        try {
            if (this.data == null) {
                return null;
            }
            Object val = this.data.get((Object)key);
            if (val == null) {
                return null;
            }
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof Number) {
                return val.toString();
            }
            if (val instanceof LinkedTreeMap) {
                return Snapshot.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)val)).toString();
            }
            if (val instanceof Collection) {
                return Snapshot.convertCollectionToJSON((Collection)val).toString();
            }
            if (val instanceof Object[]) {
                return Snapshot.convertArrayToJSON((Object[])val).toString();
            }
            if (val instanceof JSONObject || val instanceof JSONArray) {
                return val.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public double doubleVal(@NonNull String key, double def) {
        String raw = this.rawVal(key);
        if (raw != null) {
            try {
                return Double.parseDouble(raw);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public long longVal(@NonNull String key, long def) {
        return Math.round(this.doubleVal(key, def));
    }

    public float floatVal(@NonNull String key, float def) {
        return Double.valueOf(this.doubleVal(key, def)).floatValue();
    }

    public int intVal(@NonNull String key, int def) {
        return Long.valueOf(this.longVal(key, def)).intValue();
    }

    @Nullable
    public Coordinate coord() {
        try {
            Object[] coords;
            if (this.data == null) {
                return null;
            }
            Object locObj = this.data.get((Object)"location");
            if (!(locObj instanceof LinkedTreeMap)) {
                return null;
            }
            Object coordObj = ((LinkedTreeMap)locObj).get((Object)"coordinates");
            if (coordObj instanceof Collection) {
                coords = ((Collection)coordObj).toArray();
            } else if (coordObj instanceof Object[]) {
                coords = (Object[])coordObj;
            } else {
                return null;
            }
            return Coordinate.builder().lat(((Number)coords[1]).floatValue()).lon(((Number)coords[0]).floatValue()).build();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public AccelData accel() {
        try {
            return (AccelData)new Gson().fromJson(this.rawVal("accel"), AccelData.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NonNull
    private static JSONObject convertLinkedTreeMapToJSON(LinkedTreeMap<String, Object> ltm) {
        Object[] objs;
        JSONObject jo = new JSONObject();
        for (Object obj : objs = ltm.entrySet().toArray()) {
            Map.Entry o = (Map.Entry)obj;
            try {
                if (o.getValue() instanceof LinkedTreeMap) {
                    jo.put(o.getKey().toString(), (Object)Snapshot.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o.getValue())));
                    continue;
                }
                jo.put(o.getKey().toString(), o.getValue());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jo;
    }

    @NonNull
    private static JSONArray convertCollectionToJSON(@NonNull Collection<Object> col) {
        JSONArray ja = new JSONArray();
        for (Object o : col) {
            if (o instanceof LinkedTreeMap) {
                ja.put((Object)Snapshot.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o)));
                continue;
            }
            ja.put(o);
        }
        return ja;
    }

    @NonNull
    private static JSONArray convertArrayToJSON(@NonNull Object[] arr) {
        JSONArray ja = new JSONArray();
        for (Object o : arr) {
            if (o instanceof LinkedTreeMap) {
                ja.put((Object)Snapshot.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o)));
                continue;
            }
            ja.put(o);
        }
        return ja;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Gson gson = new Gson();
        dest.writeString(gson.toJson((Object)this, Snapshot.class));
    }

    static class Links {
        public String self;

        Links() {
        }
    }

    public static final class AccelData {
        private Double maxX;
        private Double maxY;
        private Double maxZ;
        private Double minX;
        private Double minY;
        private Double minZ;

        AccelData(double maxX, double maxY, double maxZ, double minX, double minY, double minZ) {
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
        }

        AccelData() {
        }

        public double maxX() {
            if (this.maxX == null) {
                return 0.0;
            }
            return this.maxX;
        }

        public double maxY() {
            if (this.maxY == null) {
                return 0.0;
            }
            return this.maxY;
        }

        public double maxZ() {
            if (this.maxZ == null) {
                return 0.0;
            }
            return this.maxZ;
        }

        public double minX() {
            if (this.minX == null) {
                return 0.0;
            }
            return this.minX;
        }

        public double minY() {
            if (this.minY == null) {
                return 0.0;
            }
            return this.minY;
        }

        public double minZ() {
            if (this.minZ == null) {
                return 0.0;
            }
            return this.minZ;
        }

        public String toString() {
            return "AccelData{maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + ", minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccelData accelData = (AccelData)o;
            return !((this.maxX == null ? accelData.maxX != null : !this.maxX.equals(accelData.maxX)) || (this.maxY == null ? accelData.maxY != null : !this.maxY.equals(accelData.maxY)) || (this.maxZ == null ? accelData.maxZ != null : !this.maxZ.equals(accelData.maxZ)) || (this.minX == null ? accelData.minX != null : !this.minX.equals(accelData.minX)) || (this.minY == null ? accelData.minY != null : !this.minY.equals(accelData.minY)) || (this.minZ == null ? accelData.minZ != null : !this.minZ.equals(accelData.minZ)));
        }

        public int hashCode() {
            int result = this.maxX != null ? this.maxX.hashCode() : 0;
            result = 31 * result + (this.maxY != null ? this.maxY.hashCode() : 0);
            result = 31 * result + (this.maxZ != null ? this.maxZ.hashCode() : 0);
            result = 31 * result + (this.minX != null ? this.minX.hashCode() : 0);
            result = 31 * result + (this.minY != null ? this.minY.hashCode() : 0);
            result = 31 * result + (this.minZ != null ? this.minZ.hashCode() : 0);
            return result;
        }
    }
}

