/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Page;
import li.vin.net.AutoParcel_Page_Meta;
import li.vin.net.AutoParcel_Page_Meta_Pagination;
import li.vin.net.AutoParcel_Page_Meta_Pagination_Links;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import rx.Observable;
import rx.functions.Func1;
import rx.internal.operators.OnSubscribeFromIterable;

public abstract class Page<T extends VinliItem>
implements Parcelable {
    static final Func1 EXTRACT_ITEMS = new Func1<Page<?>, Observable<?>>(){

        public Observable<?> call(Page<?> tPage) {
            return tPage.observeItems();
        }
    };
    static final Func1 ALL_ITEMS = new Func1<Page<? extends VinliItem>, Observable<? extends VinliItem>>(){

        public Observable<? extends VinliItem> call(Page<? extends VinliItem> tPage) {
            if (tPage.hasNextPage()) {
                return tPage.observeItems().concatWith(tPage.loadNextPage().flatMap(ALL_ITEMS));
            }
            return tPage.observeItems();
        }
    };

    public static final <T extends VinliItem> Func1<Page<T>, Observable<T>> extractItems() {
        return EXTRACT_ITEMS;
    }

    public static final <T extends VinliItem> Func1<Page<T>, Observable<T>> allItems() {
        return ALL_ITEMS;
    }

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Meta.class, AutoParcelAdapter.create(AutoParcel_Page_Meta.class));
        gb.registerTypeAdapter(Meta.Pagination.class, AutoParcelAdapter.create(AutoParcel_Page_Meta_Pagination.class));
        gb.registerTypeAdapter(Meta.Pagination.Links.class, AutoParcelAdapter.create(AutoParcel_Page_Meta_Pagination_Links.class));
    }

    abstract List<T> items();

    abstract Meta meta();

    abstract Type type();

    abstract String className();

    public int size() {
        return this.items().size();
    }

    public int total() {
        return this.meta().pagination().total();
    }

    private Observable<Page<T>> loadLink(@NonNull String link) {
        Class<?> clz;
        try {
            clz = Class.forName(this.className());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Vinli.curApp().pagingPageObservable(clz, link);
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items());
    }

    public Observable<T> observeItems() {
        return Observable.create((Observable.OnSubscribe)new OnSubscribeFromIterable(this.items()));
    }

    public boolean hasNextPage() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        return links != null && links.next() != null;
    }

    public Observable<Page<T>> loadPrevPage() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        if (links == null) {
            return Observable.error((Throwable)new IOException("no links"));
        }
        String link = links.prev();
        if (link == null) {
            return Observable.error((Throwable)new IOException("no prev link"));
        }
        return this.loadLink(link);
    }

    public Observable<Page<T>> loadNextPage() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        if (links == null) {
            return Observable.error((Throwable)new IOException("no links"));
        }
        String link = links.next();
        if (link == null) {
            return Observable.error((Throwable)new IOException("no next link"));
        }
        return this.loadLink(link);
    }

    public Observable<Page<T>> loadFirstPage() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        if (links == null) {
            return Observable.error((Throwable)new IOException("no links"));
        }
        String link = links.first();
        if (link == null) {
            return Observable.error((Throwable)new IOException("no first link"));
        }
        return this.loadLink(link);
    }

    public Observable<Page<T>> loadLastPage() {
        Meta.Pagination.Links links = this.meta().pagination().links();
        if (links == null) {
            return Observable.error((Throwable)new IOException("no links"));
        }
        String link = links.last();
        if (link == null) {
            return Observable.error((Throwable)new IOException("no last link"));
        }
        return this.loadLink(link);
    }

    Page() {
    }

    static final class Adapter<T extends VinliItem>
    extends TypeAdapter<Page<T>> {
        private final Type pageType;
        private final Class<T> itemCls;
        private final String collectionName;
        private Gson gson;

        public static final <T extends VinliItem> Adapter<T> create(Type pageType, Class<T> itemCls) {
            return Adapter.create(pageType, itemCls, itemCls.getSimpleName().toLowerCase(Locale.US) + 's');
        }

        public static final <T extends VinliItem> Adapter<T> create(Type pageType, Class<T> itemCls, String collectionName) {
            return new Adapter<T>(pageType, itemCls, collectionName);
        }

        private Adapter(Type pageType, Class<T> itemCls, String collectionName) {
            this.pageType = pageType;
            this.itemCls = itemCls;
            this.collectionName = collectionName;
        }

        public void write(JsonWriter out, Page<T> value) throws IOException {
            throw new UnsupportedOperationException("writing a page is not supported");
        }

        public Page<T> read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            Builder b = new AutoParcel_Page.Builder().type(this.pageType).className(this.itemCls.getName());
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if ("meta".equals(name)) {
                    b.meta((Meta)this.gson.fromJson(in, Meta.class));
                    continue;
                }
                if (this.collectionName.equals(name)) {
                    ArrayList<Object> items = new ArrayList<Object>();
                    in.beginArray();
                    while (in.hasNext()) {
                        items.add(this.gson.fromJson(in, this.itemCls));
                    }
                    in.endArray();
                    b.items(items);
                    continue;
                }
                throw new IOException("unrecognized key '" + name + "' while parsing " + this.collectionName);
            }
            in.endObject();
            return b.build();
        }
    }

    static interface Builder<T extends VinliItem> {
        public Builder<T> items(List<T> var1);

        public Builder<T> meta(Meta var1);

        public Builder<T> type(Type var1);

        public Builder<T> className(String var1);

        public Page<T> build();
    }

    static abstract class Meta
    implements Parcelable {
        Meta() {
        }

        public abstract Pagination pagination();

        public static abstract class Pagination
        implements Parcelable {
            public abstract int total();

            public abstract int limit();

            public abstract int offset();

            @Nullable
            public abstract Links links();

            public static abstract class Links
            implements Parcelable {
                public abstract String first();

                public abstract String last();

                @Nullable
                public abstract String next();

                @Nullable
                public abstract String prev();
            }
        }
    }
}

