/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_OdometerTrigger;
import li.vin.net.AutoParcel_OdometerTrigger_Links;
import li.vin.net.AutoParcel_OdometerTrigger_Seed;
import li.vin.net.DistanceUnit;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class OdometerTrigger
implements VinliItem {
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<OdometerTrigger>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<OdometerTrigger>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(OdometerTrigger.class, (Object)new OdometerTriggerAdapter());
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_OdometerTrigger_Links.class));
        gb.registerTypeAdapter(Seed.class, (Object)new Seed.Adapter());
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(OdometerTrigger.class, "odometerTrigger"));
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, OdometerTrigger.class, "odometerTriggers"));
    }

    public static Observable<OdometerTrigger> odometerTriggerWithId(@NonNull String odometerTriggerId) {
        return Vinli.curApp().odometerTrigger(odometerTriggerId);
    }

    public static Observable<TimeSeries<OdometerTrigger>> odometerTriggersWithVehicleId(@NonNull String vehicleId) {
        return OdometerTrigger.odometerTriggersWithVehicleId(vehicleId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<OdometerTrigger>> odometerTriggersWithVehicleId(@NonNull String vehicleId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().distances().odometerTriggers(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<OdometerTrigger>> odometerTriggersWithVehicleId(@NonNull String vehicleId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().distances().odometerTriggers(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    public abstract String vehicleId();

    public abstract TriggerType type();

    public abstract Double threshold();

    public abstract Double events();

    @Nullable
    public abstract DistanceUnit unit();

    abstract Links links();

    public static final Seed.Saver create() {
        return new AutoParcel_OdometerTrigger_Seed.Builder();
    }

    public Observable<Void> delete() {
        return Vinli.curApp().distances().deleteOdometerTrigger(this.id());
    }

    private static final class OdometerTriggerAdapter
    extends TypeAdapter<OdometerTrigger> {
        private Gson gson;

        private OdometerTriggerAdapter() {
        }

        public void write(JsonWriter out, OdometerTrigger value) throws IOException {
            throw new UnsupportedOperationException("writing an OdometerTrigger is not supported");
        }

        public OdometerTrigger read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            AutoParcel_OdometerTrigger.Builder b = new AutoParcel_OdometerTrigger.Builder();
            in.beginObject();
            block18: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "id": {
                        ((Builder)b).id(in.nextString());
                        continue block18;
                    }
                    case "vehicleId": {
                        ((Builder)b).vehicleId(in.nextString());
                        continue block18;
                    }
                    case "type": {
                        ((Builder)b).type(TriggerType.getEnumFromString(in.nextString()));
                        continue block18;
                    }
                    case "threshold": {
                        ((Builder)b).threshold(in.nextDouble());
                        continue block18;
                    }
                    case "events": {
                        ((Builder)b).events(in.nextDouble());
                        continue block18;
                    }
                    case "unit": {
                        ((Builder)b).unit(DistanceUnit.parse(in.nextString()));
                        continue block18;
                    }
                    case "links": {
                        ((Builder)b).links((Links)this.gson.fromJson(in, Links.class));
                        continue block18;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return ((Builder)b).build();
        }
    }

    public static abstract class Seed {
        @NonNull
        public abstract String vehicleId();

        @NonNull
        public abstract TriggerType type();

        @NonNull
        public abstract Double threshold();

        @NonNull
        public abstract DistanceUnit unit();

        Seed() {
        }

        static final class Adapter
        extends TypeAdapter<Seed> {
            private Gson gson;

            Adapter() {
            }

            public void write(JsonWriter out, Seed value) throws IOException {
                if (this.gson == null) {
                    this.gson = Vinli.curApp().gson();
                }
                out.beginObject();
                out.name("odometerTrigger").beginObject();
                out.name("type").value(value.type().getTriggerTypeStr());
                out.name("threshold").value((Number)value.threshold());
                out.name("unit").value(value.unit().getDistanceUnitStr());
                out.endObject();
                out.endObject();
            }

            public Seed read(JsonReader in) throws IOException {
                throw new UnsupportedOperationException("reading a OdometerTriggerSeed is not supported");
            }
        }

        public static abstract class Saver {
            public abstract Saver vehicleId(@NonNull String var1);

            public abstract Saver type(@NonNull TriggerType var1);

            public abstract Saver threshold(@NonNull Double var1);

            public abstract Saver unit(@NonNull DistanceUnit var1);

            Saver() {
            }

            abstract Seed autoBuild();

            public Observable<OdometerTrigger> save() {
                Seed s = this.autoBuild();
                return Vinli.curApp().distances().createOdometerTrigger(s.vehicleId(), s).map(Wrapped.pluckItem());
            }
        }
    }

    static abstract class Builder {
        Builder() {
        }

        public abstract Builder id(String var1);

        public abstract Builder vehicleId(String var1);

        public abstract Builder type(TriggerType var1);

        public abstract Builder threshold(Double var1);

        public abstract Builder events(Double var1);

        public abstract Builder unit(@Nullable DistanceUnit var1);

        public abstract Builder links(Links var1);

        public abstract OdometerTrigger build();
    }

    static abstract class Links
    implements Parcelable {
        public abstract String vehicle();

        Links() {
        }
    }

    public static enum TriggerType {
        SPECIFIC("specific"),
        FROM_NOW("from_now"),
        MILESTONE("milestone");

        private String typeStr;

        private TriggerType(String unit) {
            this.typeStr = unit;
        }

        String getTriggerTypeStr() {
            return this.typeStr;
        }

        static TriggerType getEnumFromString(String str) {
            switch (str) {
                case "specific": {
                    return SPECIFIC;
                }
                case "from_now": {
                    return FROM_NOW;
                }
                case "milestone": {
                    return MILESTONE;
                }
            }
            throw new IllegalArgumentException("str is not a valid string to be used for TriggerType");
        }
    }
}

