/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import li.vin.net.Coordinate;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;

public class Message
implements VinliItem {
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Message>>(){}.getType();
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Message>>(){}.getType();
    public String id;
    public String timestamp;
    private LinkedTreeMap<String, Object> data;
    Links links;
    private static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

        public Message createFromParcel(Parcel in) {
            return new Message(in);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    };

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, Message.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Message.class));
    }

    public static Observable<Message> messageWithId(@NonNull String messageId) {
        return Vinli.curApp().message(messageId);
    }

    public static Observable<TimeSeries<Message>> messagesWithDeviceId(@NonNull String deviceId) {
        return Message.messagesWithDeviceId(deviceId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Message>> messagesWithDeviceId(@NonNull String deviceId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().messages().messages(deviceId, sinceMs, untilMs, limit, sortDir);
    }

    public static Observable<TimeSeries<Message>> messagesWithVehicleId(@NonNull String vehicleId) {
        return Message.messagesWithVehicleId(vehicleId, null, null, null, null);
    }

    public static Observable<TimeSeries<Message>> messagesWithVehicleId(@NonNull String vehicleId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().messages().vehicleMessages(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Message>> messagesWithDeviceId(@NonNull String deviceId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().messages().messages(deviceId, sinceMs, untilMs, limit, sortDir);
    }

    Message() {
    }

    Message(Parcel in) {
        Gson gson = new Gson();
        Message message = (Message)gson.fromJson(in.readString(), Message.class);
        this.id = message.id();
        this.timestamp = message.timestamp;
        this.data = message.data;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Nullable
    public String rawVal(@NonNull String key) {
        try {
            if (this.data == null) {
                return null;
            }
            Object val = this.data.get((Object)key);
            if (val == null) {
                return null;
            }
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof Number) {
                return val.toString();
            }
            if (val instanceof LinkedTreeMap) {
                return Message.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)val)).toString();
            }
            if (val instanceof Collection) {
                return Message.convertCollectionToJSON((Collection)val).toString();
            }
            if (val instanceof Object[]) {
                return Message.convertArrayToJSON((Object[])val).toString();
            }
            if (val instanceof JSONObject || val instanceof JSONArray) {
                return val.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public double doubleVal(@NonNull String key, double def) {
        String raw = this.rawVal(key);
        if (raw != null) {
            try {
                return Double.parseDouble(raw);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public long longVal(@NonNull String key, long def) {
        return Math.round(this.doubleVal(key, def));
    }

    public float floatVal(@NonNull String key, float def) {
        return Double.valueOf(this.doubleVal(key, def)).floatValue();
    }

    public int intVal(@NonNull String key, int def) {
        return Long.valueOf(this.longVal(key, def)).intValue();
    }

    @Nullable
    public Coordinate coord() {
        try {
            Object[] coords;
            if (this.data == null) {
                return null;
            }
            Object locObj = this.data.get((Object)"location");
            if (!(locObj instanceof LinkedTreeMap)) {
                return null;
            }
            Object coordObj = ((LinkedTreeMap)locObj).get((Object)"coordinates");
            if (coordObj instanceof Collection) {
                coords = ((Collection)coordObj).toArray();
            } else if (coordObj instanceof Object[]) {
                coords = (Object[])coordObj;
            } else {
                return null;
            }
            return Coordinate.builder().lat(((Number)coords[1]).floatValue()).lon(((Number)coords[0]).floatValue()).build();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public AccelData accel() {
        try {
            return (AccelData)new Gson().fromJson(this.rawVal("accel"), AccelData.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NonNull
    private static JSONObject convertLinkedTreeMapToJSON(LinkedTreeMap<String, Object> ltm) {
        Object[] objs;
        JSONObject jo = new JSONObject();
        for (Object obj : objs = ltm.entrySet().toArray()) {
            Map.Entry o = (Map.Entry)obj;
            try {
                if (o.getValue() instanceof LinkedTreeMap) {
                    jo.put(o.getKey().toString(), (Object)Message.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o.getValue())));
                    continue;
                }
                jo.put(o.getKey().toString(), o.getValue());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jo;
    }

    @NonNull
    private static JSONArray convertCollectionToJSON(@NonNull Collection<Object> col) {
        JSONArray ja = new JSONArray();
        for (Object o : col) {
            if (o instanceof LinkedTreeMap) {
                ja.put((Object)Message.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o)));
                continue;
            }
            ja.put(o);
        }
        return ja;
    }

    @NonNull
    private static JSONArray convertArrayToJSON(@NonNull Object[] arr) {
        JSONArray ja = new JSONArray();
        for (Object o : arr) {
            if (o instanceof LinkedTreeMap) {
                ja.put((Object)Message.convertLinkedTreeMapToJSON((LinkedTreeMap<String, Object>)((LinkedTreeMap)o)));
                continue;
            }
            ja.put(o);
        }
        return ja;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Gson gson = new Gson();
        dest.writeString(gson.toJson((Object)this, Message.class));
    }

    static class Links {
        public String self;

        Links() {
        }
    }

    public static final class AccelData {
        private Double maxX;
        private Double maxY;
        private Double maxZ;
        private Double minX;
        private Double minY;
        private Double minZ;

        AccelData(double maxX, double maxY, double maxZ, double minX, double minY, double minZ) {
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
        }

        AccelData() {
        }

        public double maxX() {
            if (this.maxX == null) {
                return 0.0;
            }
            return this.maxX;
        }

        public double maxY() {
            if (this.maxY == null) {
                return 0.0;
            }
            return this.maxY;
        }

        public double maxZ() {
            if (this.maxZ == null) {
                return 0.0;
            }
            return this.maxZ;
        }

        public double minX() {
            if (this.minX == null) {
                return 0.0;
            }
            return this.minX;
        }

        public double minY() {
            if (this.minY == null) {
                return 0.0;
            }
            return this.minY;
        }

        public double minZ() {
            if (this.minZ == null) {
                return 0.0;
            }
            return this.minZ;
        }

        public String toString() {
            return "AccelData{maxX=" + this.maxX + ", maxY=" + this.maxY + ", maxZ=" + this.maxZ + ", minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccelData accelData = (AccelData)o;
            return !((this.maxX == null ? accelData.maxX != null : !this.maxX.equals(accelData.maxX)) || (this.maxY == null ? accelData.maxY != null : !this.maxY.equals(accelData.maxY)) || (this.maxZ == null ? accelData.maxZ != null : !this.maxZ.equals(accelData.maxZ)) || (this.minX == null ? accelData.minX != null : !this.minX.equals(accelData.minX)) || (this.minY == null ? accelData.minY != null : !this.minY.equals(accelData.minY)) || (this.minZ == null ? accelData.minZ != null : !this.minZ.equals(accelData.minZ)));
        }

        public int hashCode() {
            int result = this.maxX != null ? this.maxX.hashCode() : 0;
            result = 31 * result + (this.maxY != null ? this.maxY.hashCode() : 0);
            result = 31 * result + (this.maxZ != null ? this.maxZ.hashCode() : 0);
            result = 31 * result + (this.minX != null ? this.minX.hashCode() : 0);
            result = 31 * result + (this.minY != null ? this.minY.hashCode() : 0);
            result = 31 * result + (this.minZ != null ? this.minZ.hashCode() : 0);
            return result;
        }
    }
}

