/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import li.vin.net.AutoParcel_Location;
import li.vin.net.AutoParcel_TimeSeries;
import li.vin.net.Coordinate;
import li.vin.net.TimeSeries;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import rx.Observable;

public abstract class Location
implements VinliItem {
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Location>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Location.class, (Object)new LocationAdapter());
        gb.registerTypeAdapter(TIME_SERIES_TYPE, (Object)new LocationTimeSeriesAdapter());
    }

    public static Observable<TimeSeries<Location>> locationsWithDeviceId(@NonNull String deviceId) {
        return Location.locationsWithDeviceId(deviceId, (Long)null, null, null, null);
    }

    public static Observable<TimeSeries<Location>> locationsWithDeviceId(@NonNull String deviceId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().locations().locations(deviceId, sinceMs, untilMs, limit, sortDir);
    }

    public static Observable<TimeSeries<Location>> locationsWithVehicleId(@NonNull String vehicleId) {
        return Location.locationsWithVehicleId(vehicleId, null, null, null, null);
    }

    public static Observable<TimeSeries<Location>> locationsWithVehicleId(@NonNull String vehicleId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().locations().vehicleLocations(vehicleId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public static Observable<TimeSeries<Location>> locationsWithDeviceId(@NonNull String deviceId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().locations().locations(deviceId, sinceMs, untilMs, limit, sortDir);
    }

    public abstract Coordinate coordinate();

    public abstract String timestamp();

    Location() {
    }

    static final class LocationTimeSeriesAdapter
    extends TypeAdapter<TimeSeries<Location>> {
        private Gson gson;

        LocationTimeSeriesAdapter() {
        }

        public void write(JsonWriter out, TimeSeries<Location> value) throws IOException {
            throw new UnsupportedOperationException("writing a location time series is not supported");
        }

        public TimeSeries<Location> read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            TimeSeries.Builder b = new AutoParcel_TimeSeries.Builder().type(TIME_SERIES_TYPE).className(((Object)((Object)this)).getClass().getName());
            in.beginObject();
            block16: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "meta": {
                        b.meta((TimeSeries.Meta)this.gson.fromJson(in, TimeSeries.Meta.class));
                        continue block16;
                    }
                    case "locations": {
                        in.beginObject();
                        block17: while (in.hasNext()) {
                            String locName;
                            switch (locName = in.nextName()) {
                                case "type": {
                                    in.skipValue();
                                    continue block17;
                                }
                                case "features": {
                                    ArrayList<Object> locations = new ArrayList<Object>();
                                    in.beginArray();
                                    while (in.hasNext()) {
                                        locations.add(this.gson.fromJson(in, Location.class));
                                    }
                                    in.endArray();
                                    b.items(locations);
                                    continue block17;
                                }
                            }
                            in.skipValue();
                        }
                        in.endObject();
                        continue block16;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return b.build();
        }
    }

    private static final class LocationAdapter
    extends TypeAdapter<Location> {
        private Gson gson;

        private LocationAdapter() {
        }

        public void write(JsonWriter out, Location value) throws IOException {
            throw new UnsupportedOperationException("writing a location is not supported");
        }

        public Location read(JsonReader in) throws IOException {
            if (this.gson == null) {
                this.gson = Vinli.curApp().gson();
            }
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            AutoParcel_Location.Builder b = new AutoParcel_Location.Builder();
            in.beginObject();
            block30: while (in.hasNext()) {
                String locationName;
                switch (locationName = in.nextName()) {
                    case "type": {
                        in.skipValue();
                        continue block30;
                    }
                    case "geometry": {
                        in.beginObject();
                        block31: while (in.hasNext()) {
                            String geoName;
                            switch (geoName = in.nextName()) {
                                case "type": {
                                    in.skipValue();
                                    continue block31;
                                }
                                case "coordinates": {
                                    b.coordinate((Coordinate)this.gson.fromJson(in, Coordinate.class));
                                    continue block31;
                                }
                            }
                            in.skipValue();
                        }
                        in.endObject();
                        continue block30;
                    }
                    case "properties": {
                        in.beginObject();
                        block32: while (in.hasNext()) {
                            String propName;
                            switch (propName = in.nextName()) {
                                case "id": {
                                    b.id(in.nextString());
                                    continue block32;
                                }
                                case "timestamp": {
                                    b.timestamp(in.nextString());
                                    continue block32;
                                }
                                case "links": {
                                    in.skipValue();
                                    continue block32;
                                }
                                case "data": {
                                    in.beginObject();
                                    in.endObject();
                                    continue block32;
                                }
                            }
                            in.skipValue();
                        }
                        in.endObject();
                        continue block30;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return b.build();
        }
    }

    static interface Builder {
        public Builder id(String var1);

        public Builder coordinate(Coordinate var1);

        public Builder timestamp(String var1);

        public Location build();
    }
}

