/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.support.annotation.NonNull;
import com.squareup.okhttp.HttpUrl;

enum Endpoint {
    AUTH("auth"),
    DIAGNOSTICS("diagnostic"),
    EVENTS("events"),
    PLATFORM("platform"),
    RULES("rules"),
    TELEMETRY("telemetry"),
    TRIPS("trips"),
    SAFETY("safety"),
    BEHAVIORAL("behavioral"),
    DISTANCE("distance");

    static final String DOMAIN_DEMO = "-demo.vin.li";
    static final String DOMAIN_DEV = "-dev.vin.li";
    static final String DOMAIN_PROD = ".vin.li";
    static final String DOMAIN_QA = "-qa.vin.li";
    private static String domain;
    private final HttpUrl mUrl;
    private final String subDomain;

    static synchronized String domain() {
        return domain;
    }

    static synchronized void setDomain(@NonNull String domain) {
        Endpoint.domain = domain;
    }

    private Endpoint(String subDomain) {
        this.subDomain = subDomain;
        this.mUrl = new HttpUrl.Builder().scheme("https").host(subDomain + Endpoint.domain()).addPathSegment("api").addPathSegment("v1").addPathSegment("").build();
    }

    public String getName() {
        return this.name();
    }

    public String getUrl() {
        return this.mUrl.newBuilder().host(this.subDomain + Endpoint.domain()).toString();
    }

    static {
        domain = DOMAIN_PROD;
    }
}

