/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Dtc;
import li.vin.net.AutoParcel_Dtc_Code;
import li.vin.net.AutoParcel_Dtc_Code_ThreeByte;
import li.vin.net.AutoParcel_Dtc_Code_TwoByte;
import li.vin.net.AutoParcel_Dtc_Links;
import li.vin.net.Device;
import li.vin.net.Page;
import li.vin.net.TimeSeries;
import li.vin.net.Vehicle;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class Dtc
implements VinliItem {
    static final Type TIME_SERIES_TYPE = new TypeToken<TimeSeries<Dtc>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Dtc.class, AutoParcelAdapter.create(AutoParcel_Dtc.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Dtc_Links.class));
        gb.registerTypeAdapter(Code.class, AutoParcelAdapter.create(AutoParcel_Dtc_Code.class));
        gb.registerTypeAdapter(Code.TwoByte.class, AutoParcelAdapter.create(AutoParcel_Dtc_Code_TwoByte.class));
        gb.registerTypeAdapter(Code.ThreeByte.class, AutoParcelAdapter.create(AutoParcel_Dtc_Code_ThreeByte.class));
        gb.registerTypeAdapter(Code.WRAPPED_TYPE, Wrapped.Adapter.create(Code.class, "code"));
        gb.registerTypeAdapter(Code.PAGE_TYPE, Page.Adapter.create(Code.PAGE_TYPE, Code.class, "codes"));
        gb.registerTypeAdapter(TIME_SERIES_TYPE, TimeSeries.Adapter.create(TIME_SERIES_TYPE, Dtc.class, "codes"));
    }

    public abstract String start();

    public abstract String stop();

    public abstract String number();

    public abstract String vehicleId();

    public abstract String deviceId();

    public Observable<Device> device() {
        return Vinli.curApp().device(this.deviceId());
    }

    public Observable<Vehicle> vehicle() {
        return Vinli.curApp().vehicle(this.vehicleId());
    }

    public Observable<Code> diagnose() {
        return Vinli.curApp().diagnoseDtcCode(this.number());
    }

    abstract Links links();

    Dtc() {
    }

    public static abstract class Code
    implements VinliItem {
        static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Code>>(){}.getType();
        static final Type PAGE_TYPE = new TypeToken<Page<Code>>(){}.getType();

        public abstract String make();

        Code() {
        }

        static abstract class ThreeByte
        implements Parcelable {
            public abstract String number();

            public abstract String ftb();

            public abstract String fault();

            public abstract String description();

            ThreeByte() {
            }
        }

        static abstract class TwoByte
        implements Parcelable {
            public abstract String number();

            public abstract String description();

            TwoByte() {
            }
        }
    }

    static abstract class Links
    implements Parcelable {
        public abstract String self();

        public abstract String device();

        public abstract String vehicle();

        Links() {
        }
    }
}

