/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_Device;
import li.vin.net.AutoParcel_Device_Links;
import li.vin.net.BearingCalculator;
import li.vin.net.Collision;
import li.vin.net.Duktaper;
import li.vin.net.Endpoint;
import li.vin.net.Event;
import li.vin.net.Location;
import li.vin.net.Message;
import li.vin.net.ObdJsLib;
import li.vin.net.Page;
import li.vin.net.ReportCard;
import li.vin.net.Rule;
import li.vin.net.Snapshot;
import li.vin.net.StreamMessage;
import li.vin.net.Subscription;
import li.vin.net.TimeSeries;
import li.vin.net.Trip;
import li.vin.net.Vehicle;
import li.vin.net.Vinli;
import li.vin.net.VinliItem;
import li.vin.net.Wrapped;
import okio.Buffer;
import okio.BufferedSource;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

public abstract class Device
implements VinliItem {
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<Device>>(){}.getType();
    static final Type PAGE_TYPE = new TypeToken<Page<Device>>(){}.getType();
    private static final Object duktapeRefLock = new Object();
    private static int duktapeRefCtr = 0;
    private static Duktaper duktape;

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(Device.class, AutoParcelAdapter.create(AutoParcel_Device.class));
        gb.registerTypeAdapter(Links.class, AutoParcelAdapter.create(AutoParcel_Device_Links.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(Device.class));
        gb.registerTypeAdapter(PAGE_TYPE, Page.Adapter.create(PAGE_TYPE, Device.class));
    }

    private static String toListJson(@NonNull List<Device> devices) {
        return Vinli.curApp().gson().toJson(devices, new TypeToken<List<Device>>(){}.getType());
    }

    private static List<Device> fromListJson(@NonNull String devices) {
        return (List)Vinli.curApp().gson().fromJson(devices, new TypeToken<List<Device>>(){}.getType());
    }

    private static String toJson(@NonNull Device device) {
        return Vinli.curApp().gson().toJson((Object)device);
    }

    private static Device fromJson(@NonNull String device) {
        return (Device)Vinli.curApp().gson().fromJson(device, Device.class);
    }

    static Device createDevice(String id, String name, String chipId, String icon) {
        return new AutoParcel_Device(id, new AutoParcel_Device_Links("", "", "", ""), name, chipId, icon);
    }

    public static Observable<Device> deviceWithId(@NonNull String deviceId) {
        return Vinli.curApp().device(deviceId);
    }

    abstract Links links();

    @Nullable
    public abstract String name();

    public abstract String chipId();

    @Nullable
    public abstract String icon();

    Device() {
    }

    public Observable<StreamMessage> stream() {
        return this.stream(null, null);
    }

    public Observable<StreamMessage> stream(final @Nullable List<StreamMessage.ParametricFilter.Seed> parametricFilters, final @Nullable StreamMessage.GeometryFilter.Seed geometryFilter) {
        final BearingCalculator bearingCalculator = new BearingCalculator();
        final AtomicLong lastStreamData = new AtomicLong(System.currentTimeMillis());
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<StreamMessage>(){

            public void call(final Subscriber<? super StreamMessage> subscriber) {
                String token;
                if (subscriber.isUnsubscribed()) {
                    return;
                }
                try {
                    token = Vinli.curApp().getAccessToken();
                    if (token == null || TextUtils.getTrimmedLength((CharSequence)token) == 0) {
                        throw new RuntimeException("no access token!");
                    }
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)e);
                    return;
                }
                String deviceId = Device.this.id();
                if (deviceId == null || TextUtils.getTrimmedLength((CharSequence)deviceId) == 0) {
                    subscriber.onError((Throwable)new RuntimeException("no device id!"));
                    return;
                }
                String message = String.format("{\"type\":\"sub\",\"subject\":{\"type\":\"device\",\"id\":\"%s\"}}", deviceId);
                Gson gson = Vinli.curApp().gson();
                Charset UTF8 = Charset.forName("UTF-8");
                final AtomicReference webSocketRef = new AtomicReference();
                final Runnable cleanup = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((WebSocket)webSocketRef.get()).close(1000, "CLOSE_NORMAL");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                final AtomicBoolean suspend = new AtomicBoolean(false);
                Func1<WebSocket, Boolean> handleSuspend = new Func1<WebSocket, Boolean>(){

                    public Boolean call(WebSocket webSocket) {
                        if (suspend.get()) {
                            try {
                                webSocket.close(1000, "CLOSE_NORMAL");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return true;
                        }
                        return false;
                    }
                };
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        suspend.set(false);
                        cleanup.run();
                    }
                }));
                final Runnable recordActivity = new Runnable(){

                    @Override
                    public void run() {
                        lastStreamData.set(System.currentTimeMillis());
                    }
                };
                final Runnable startup = new Runnable((Func1)handleSuspend, webSocketRef, message, UTF8, gson){
                    final /* synthetic */ Func1 val$handleSuspend;
                    final /* synthetic */ AtomicReference val$webSocketRef;
                    final /* synthetic */ String val$message;
                    final /* synthetic */ Charset val$UTF8;
                    final /* synthetic */ Gson val$gson;
                    {
                        this.val$handleSuspend = func1;
                        this.val$webSocketRef = atomicReference;
                        this.val$message = string2;
                        this.val$UTF8 = charset;
                        this.val$gson = gson;
                    }

                    @Override
                    public void run() {
                        if (subscriber.isUnsubscribed()) {
                            return;
                        }
                        cleanup.run();
                        WebSocketCall call = WebSocketCall.create((OkHttpClient)new OkHttpClient(), (Request)new Request.Builder().url(String.format("wss://stream%s/api/v1/messages?token=%s", Endpoint.domain(), token)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build());
                        call.enqueue(new WebSocketListener(){

                            public void onOpen(WebSocket webSocket, Response response) {
                                block7: {
                                    recordActivity.run();
                                    if (((Boolean)val$handleSuspend.call((Object)webSocket)).booleanValue()) {
                                        return;
                                    }
                                    val$webSocketRef.set(webSocket);
                                    if (subscriber.isUnsubscribed()) {
                                        cleanup.run();
                                        return;
                                    }
                                    Buffer buffer = new Buffer();
                                    buffer.writeString(val$message, val$UTF8);
                                    try {
                                        webSocket.sendMessage(WebSocket.PayloadType.TEXT, buffer);
                                        if (geometryFilter != null) {
                                            buffer.clear();
                                            buffer.writeString(val$gson.toJson((Object)geometryFilter, StreamMessage.GeometryFilter.Seed.class), val$UTF8);
                                            webSocket.sendMessage(WebSocket.PayloadType.TEXT, buffer);
                                        }
                                        if (parametricFilters != null && parametricFilters.size() > 0) {
                                            for (StreamMessage.ParametricFilter.Seed filter : parametricFilters) {
                                                buffer.clear();
                                                buffer.writeString(val$gson.toJson((Object)filter, StreamMessage.ParametricFilter.Seed.class), val$UTF8);
                                                webSocket.sendMessage(WebSocket.PayloadType.TEXT, buffer);
                                            }
                                        }
                                    }
                                    catch (IOException ioe) {
                                        cleanup.run();
                                        if (subscriber.isUnsubscribed()) break block7;
                                        subscriber.onError((Throwable)ioe);
                                    }
                                }
                            }

                            public void onFailure(IOException ioe, Response response) {
                                if (((Boolean)val$handleSuspend.call(val$webSocketRef.get())).booleanValue()) {
                                    return;
                                }
                                cleanup.run();
                                if (!subscriber.isUnsubscribed()) {
                                    subscriber.onError((Throwable)ioe);
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onMessage(BufferedSource payload, WebSocket.PayloadType type) throws IOException {
                                block14: {
                                    try {
                                        recordActivity.run();
                                        if (((Boolean)val$handleSuspend.call(val$webSocketRef.get())).booleanValue()) {
                                            return;
                                        }
                                        if (subscriber.isUnsubscribed()) {
                                            cleanup.run();
                                            return;
                                        }
                                        if (type != WebSocket.PayloadType.TEXT) break block14;
                                        try {
                                            String payloadStr = payload.readString(val$UTF8);
                                            if (payloadStr == null || payloadStr.isEmpty()) break block14;
                                            StreamMessage streamMessage = (StreamMessage)val$gson.fromJson(payloadStr, StreamMessage.class);
                                            if (streamMessage.coord() != null) {
                                                BearingCalculator bearingCalculator = bearingCalculator;
                                                synchronized (bearingCalculator) {
                                                    bearingCalculator.addCoordinate(streamMessage.coord(), streamMessage.timestamp());
                                                    streamMessage.setBearing(bearingCalculator.currentBearing());
                                                }
                                            }
                                            subscriber.onNext((Object)streamMessage);
                                        }
                                        catch (IOException ioe) {
                                            throw ioe;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    finally {
                                        payload.close();
                                    }
                                }
                            }

                            public void onPong(Buffer payload) {
                                recordActivity.run();
                                if (((Boolean)val$handleSuspend.call(val$webSocketRef.get())).booleanValue()) {
                                    return;
                                }
                                if (subscriber.isUnsubscribed()) {
                                    cleanup.run();
                                }
                            }

                            public void onClose(int code, String reason) {
                                if (((Boolean)val$handleSuspend.call(val$webSocketRef.get())).booleanValue()) {
                                    return;
                                }
                                cleanup.run();
                                if (!subscriber.isUnsubscribed()) {
                                    subscriber.onCompleted();
                                }
                            }
                        });
                    }
                };
                String chipId = Device.this.chipId();
                if (chipId == null || (chipId = chipId.trim()).length() == 0) {
                    startup.run();
                    return;
                }
                try {
                    Device.acquireDuktape();
                    subscriber.add(Subscriptions.create((Action0)new Action0(){

                        public void call() {
                            Device.releaseDuktape();
                        }
                    }));
                }
                catch (Exception any) {
                    startup.run();
                    return;
                }
                try {
                    final Scheduler.Worker worker = Schedulers.io().createWorker();
                    subscriber.add((rx.Subscription)worker);
                    worker.schedule(new Action0(){

                        public void call() {
                            if (!worker.isUnsubscribed()) {
                                worker.unsubscribe();
                            }
                            if (!subscriber.isUnsubscribed() && !suspend.get()) {
                                startup.run();
                            }
                        }
                    }, 2L, TimeUnit.SECONDS);
                }
                catch (Exception any) {
                    startup.run();
                }
                final AtomicInteger consectiveUdpTimeouts = new AtomicInteger();
                subscriber.add(Device.makeUdpStream(chipId).timeout(8L, TimeUnit.SECONDS).doOnNext((Action1)new Action1<StreamMessage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void call(StreamMessage message) {
                        suspend.set(true);
                        consectiveUdpTimeouts.set(0);
                        recordActivity.run();
                        if (!subscriber.isUnsubscribed()) {
                            if (message.coord() != null) {
                                BearingCalculator bearingCalculator = bearingCalculator;
                                synchronized (bearingCalculator) {
                                    bearingCalculator.addCoordinate(message.coord(), message.timestamp());
                                    message.setBearing(bearingCalculator.currentBearing());
                                }
                            }
                            subscriber.onNext((Object)message);
                        }
                    }
                }).doOnError((Action1)new Action1<Throwable>(){

                    public void call(Throwable throwable) {
                        if (suspend.compareAndSet(true, false)) {
                            startup.run();
                        }
                    }
                }).retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

                    public Observable<?> call(Observable<? extends Throwable> errs) {
                        return errs.flatMap(new Func1<Throwable, Observable<?>>(){

                            public Observable<?> call(Throwable throwable) {
                                if (throwable instanceof TimeoutException) {
                                    consectiveUdpTimeouts.incrementAndGet();
                                    return Observable.just(null);
                                }
                                return Observable.error((Throwable)throwable);
                            }
                        }).flatMap(new Func1<Object, Observable<?>>(){

                            public Observable<?> call(Object o) {
                                long wait = (long)Math.pow(Math.min(consectiveUdpTimeouts.get(), 4), 3.0);
                                return Observable.timer((long)wait, (TimeUnit)TimeUnit.SECONDS);
                            }
                        });
                    }
                }).onErrorReturn((Func1)new Func1<Throwable, StreamMessage>(){

                    public StreamMessage call(Throwable throwable) {
                        return null;
                    }
                }).subscribe());
            }
        }).retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Throwable> errs) {
                return errs.flatMap(new Func1<Object, Observable<?>>(){

                    public Observable<?> call(Object o) {
                        long msSinceLastStreamData = System.currentTimeMillis() - lastStreamData.get();
                        long wait = Math.min(30L, msSinceLastStreamData / 1000L);
                        return Observable.timer((long)wait, (TimeUnit)TimeUnit.SECONDS);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseDuktape() {
        Object object = duktapeRefLock;
        synchronized (object) {
            if (--duktapeRefCtr < 0) {
                duktapeRefCtr = 0;
            }
            if (duktapeRefCtr == 0) {
                if (duktape == null) {
                    throw new IllegalStateException("try to release null duktape");
                }
                try {
                    duktape.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                duktape = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static Duktaper acquireDuktape() {
        Object object = duktapeRefLock;
        synchronized (object) {
            if (++duktapeRefCtr == 1) {
                try {
                    if (duktape != null) {
                        throw new IllegalStateException("try to create w/ nonnull duktape");
                    }
                    duktape = Duktaper.create();
                    duktape.evaluate(ObdJsLib.lib());
                    return duktape;
                }
                catch (Exception e) {
                    duktapeRefCtr = 0;
                    throw e;
                }
            }
            if (duktape == null) {
                duktapeRefCtr = 0;
                throw new IllegalStateException("try to acquire null duktape");
            }
            return duktape;
        }
    }

    private static Observable<StreamMessage> makeUdpStream(final @NonNull String chipId) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<StreamMessage>(){

            /*
             * Exception decompiling
             */
            public void call(Subscriber<? super StreamMessage> subscriber) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 51[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }).subscribeOn(Schedulers.io());
    }

    public Observable<Page<Vehicle>> vehicles() {
        return this.vehicles(null, null);
    }

    public Observable<Page<Vehicle>> vehicles(@Nullable Integer limit, @Nullable Integer offset) {
        return Vinli.curApp().vehicles().vehicles(this.id(), limit, offset);
    }

    public Observable<Vehicle> vehicle(@NonNull String vehicleId) {
        return Vinli.curApp().vehicle(vehicleId);
    }

    public Observable<Vehicle> latestVehicle() {
        return Vinli.curApp().vehicles().latestVehicle(this.id()).map(Wrapped.pluckItem());
    }

    public Observable<Page<Rule>> rules() {
        return this.rules(null, null);
    }

    public Observable<Page<Rule>> rules(@Nullable Integer limit, @Nullable Integer offset) {
        return Vinli.curApp().rules().rules(this.id(), limit, offset);
    }

    public Observable<Rule> rule(@NonNull String ruleId) {
        return Vinli.curApp().rule(ruleId);
    }

    public Observable<TimeSeries<Event>> events() {
        return this.events(null, null, (Long)null, null, null, null);
    }

    public Observable<TimeSeries<Event>> events(@Nullable String type, @Nullable String objectId, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().events().events(this.id(), type, objectId, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Event>> events(@Nullable String type, @Nullable String objectId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit) {
        return this.events(type, objectId, since, until, limit, null);
    }

    @Deprecated
    public Observable<TimeSeries<Event>> events(@Nullable String type, @Nullable String objectId, @Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return this.events(type, objectId, sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Location>> locations() {
        return this.locations((Long)null, null, null, null);
    }

    public Observable<TimeSeries<Location>> locations(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().locations().locations(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<Location> latestlocation() {
        return this.locations((Long)null, null, (Integer)1, null).flatMap(TimeSeries.extractItems()).firstOrDefault(null);
    }

    @Deprecated
    public Observable<TimeSeries<Location>> locations(@Nullable Date until, @Nullable Date since, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().locations().locations(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Snapshot>> snapshots(@NonNull String fields) {
        return this.snapshots(fields, (Long)null, null, null, null);
    }

    public Observable<TimeSeries<Snapshot>> snapshots(@NonNull String fields, @Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().snapshots().snapshots(this.id(), fields, sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Snapshot>> snapshots(@NonNull String fields, @Nullable Date until, @Nullable Date since, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().snapshots().snapshots(this.id(), fields, untilMs, sinceMs, limit, sortDir);
    }

    public Observable<Page<Subscription>> subscriptions() {
        return this.subscriptions(null, null, null, null);
    }

    public Observable<Page<Subscription>> subscriptions(@Nullable Integer limit, @Nullable Integer offset, @Nullable String objectId, @Nullable String objectType) {
        return Vinli.curApp().subscriptions().subscriptions(this.id(), limit, offset, objectId, objectType);
    }

    @Deprecated
    public Observable<Subscription> subscription(@NonNull String subscriptionId) {
        return Vinli.curApp().subscriptions().subscription(subscriptionId).map(Wrapped.pluckItem());
    }

    public Observable<TimeSeries<Trip>> trips() {
        return Vinli.curApp().trips().trips(this.id(), null, null, null, null);
    }

    public Observable<TimeSeries<Trip>> trips(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().trips().trips(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Trip>> trips(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().trips().trips(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Message>> messages() {
        return this.messages((Long)null, null, null, null);
    }

    public Observable<TimeSeries<Message>> messages(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().messages().messages(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Message>> messages(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().messages().messages(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<Collision>> collisions() {
        return this.collisions((Long)null, null, null, null);
    }

    public Observable<TimeSeries<Collision>> collisions(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().collisions().collisionsForDevice(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<Collision>> collisions(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().collisions().collisionsForDevice(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<TimeSeries<ReportCard>> reportCards() {
        return this.reportCards((Long)null, null, null, null);
    }

    public Observable<TimeSeries<ReportCard>> reportCards(@Nullable Long sinceMs, @Nullable Long untilMs, @Nullable Integer limit, @Nullable String sortDir) {
        return Vinli.curApp().reportCards().reportCardsForDevice(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    @Deprecated
    public Observable<TimeSeries<ReportCard>> reportCards(@Nullable Date since, @Nullable Date until, @Nullable Integer limit, @Nullable String sortDir) {
        Long sinceMs = since == null ? null : Long.valueOf(since.getTime());
        Long untilMs = until == null ? null : Long.valueOf(until.getTime());
        return Vinli.curApp().reportCards().reportCardsForDevice(this.id(), sinceMs, untilMs, limit, sortDir);
    }

    public Observable<ReportCard.OverallReportCard> overallReportCard() {
        return Vinli.curApp().reportCards().overallReportCardForDevice(this.id());
    }

    static abstract class Links
    implements Parcelable {
        public abstract String self();

        public abstract String rules();

        public abstract String vehicles();

        public abstract String latestVehicle();

        Links() {
        }
    }
}

