/*
 * Decompiled with CFR 0.152.
 */
package li.vin.net;

import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import li.vin.net.AutoParcelAdapter;
import li.vin.net.AutoParcel_BatteryStatus;
import li.vin.net.Vinli;
import li.vin.net.Wrapped;
import rx.Observable;

public abstract class BatteryStatus
implements Parcelable {
    static final Type WRAPPED_TYPE = new TypeToken<Wrapped<BatteryStatus>>(){}.getType();

    static final void registerGson(GsonBuilder gb) {
        gb.registerTypeAdapter(BatteryStatus.class, AutoParcelAdapter.create(AutoParcel_BatteryStatus.class));
        gb.registerTypeAdapter(WRAPPED_TYPE, Wrapped.Adapter.create(BatteryStatus.class, "batteryStatus"));
    }

    @Nullable
    public abstract BatteryStatusColor status();

    @NonNull
    public abstract String timestamp();

    BatteryStatus() {
    }

    public static Observable<BatteryStatus> currentBatteryStatusForVehicle(@NonNull String vehicleId) {
        return Vinli.curApp().diagnostics().currentBatteryStatus(vehicleId).map(Wrapped.pluckItem());
    }

    public static enum BatteryStatusColor {
        GREEN,
        YELLOW,
        RED;

    }
}

