package li.vin.net;

public final class ObdJsLib {

  private static final class ObdJsLibHolder {
    private static final String LIB = "var hasOwn=Object.prototype.hasOwnProperty,toStr=Object.prototype.toString,isArray=function(a){return\"function\"===typeof Array.isArray?Array.isArray(a):\"[object Array]\"===toStr.call(a)},isPlainObject=function(a){if(!a||\"[object Object]\"!==toStr.call(a))return!1;var b=hasOwn.call(a,\"constructor\"),c=a.constructor&&a.constructor.prototype&&hasOwn.call(a.constructor.prototype,\"isPrototypeOf\");if(a.constructor&&!b&&!c)return!1;for(var d in a);return\"undefined\"===typeof d||hasOwn.call(a,d)},extend=function(){var a,\r\nb,c,d,e,f=arguments[0],h=1,k=arguments.length,g=!1;if(\"boolean\"===typeof f)g=f,f=arguments[1]||{},h=2;else if(\"object\"!==typeof f&&\"function\"!==typeof f||null==f)f={};for(;h<k;++h)if(a=arguments[h],null!=a)for(b in a)c=f[b],d=a[b],f!==d&&(g&&d&&(isPlainObject(d)||(e=isArray(d)))?(e?(e=!1,c=c&&isArray(c)?c:[]):c=c&&isPlainObject(c)?c:{},f[b]=extend(g,c,d)):\"undefined\"!==typeof d&&(f[b]=d));return f},pids={\"01-00\":{numBytes:\"4\",key:\"supportedPIDs1\",name:\"PIDs Supported 1\",description:\"Determine PIDs supported (range 01h to 20h )\",\r\ndataType:\"string\"},\"01-01\":{numBytes:\"4\",key:\"troubleCodesAndTestInfo\",name:\"Trouble Codes\",description:\"Trouble codes and on board test information\",dataType:\"string\"},\"01-03\":{numBytes:\"2\",key:\"fuelSystemStatus\",name:\"Fuel System Status\",description:\"Fuel system status\",dataType:\"string\"},\"01-04\":{numBytes:\"1\",key:\"calculatedLoadValue\",name:\"Load Value\",description:\"Calculated load value\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-05\":{numBytes:\"1\",key:\"coolantTemp\",name:\"Coolant Temp\",\r\ndescription:\"Coolant temperature\",convert:\"A-40\",dataType:\"decimal\",units:\"degC\"},\"01-06\":{numBytes:\"1\",key:\"shortTermFuelTrimBank1\",name:\"Short Term Fuel Trim 1\",description:\"Short term fuel trim Bank 1\",convert:\"(A-128) * 100/128\",dataType:\"decimal\",units:\"%\"},\"01-07\":{numBytes:\"1\",key:\"longTermFuelTrimBank1\",name:\"Long Term Fuel Trim 1\",description:\"Long term fuel trim Bank 1\",convert:\"(A-128) * 100/128\",dataType:\"decimal\",units:\"%\"},\"01-08\":{numBytes:\"1\",key:\"shortTermFuelTrimBank2\",name:\"Short Term Fuel Trim 2\",\r\ndescription:\"Short term fuel trim Bank 2\",convert:\"(A-128) * 100/128\",dataType:\"decimal\",units:\"%\"},\"01-09\":{numBytes:\"1\",key:\"longTermFuelTrimBank2\",name:\"Long Term Fuel Trim 2\",description:\"Long term fuel trim Bank 2\",convert:\"(A-128) * 100/128\",dataType:\"decimal\",units:\"%\"},\"01-0A\":{numBytes:\"1\",key:\"fuelPressure\",name:\"Fuel Pressure\",description:\"Fuel pressure\",convert:\"A*3\",dataType:\"decimal\",units:\"kPa (guage)\"},\"01-0B\":{numBytes:\"1\",key:\"intakeManifoldPressure\",description:\"Intake Manifold Pressure\",\r\nname:\"Manifold Pressure\",convert:\"A\",dataType:\"decimal\",units:\"kPa (absolute)\"},\"01-0C\":{numBytes:\"2\",key:\"rpm\",name:\"RPM\",description:\"Engine RPM\",convert:\"(A*256.0+B)/4.0\",dataType:\"decimal\",units:\"rpm\"},\"01-0D\":{numBytes:\"1\",key:\"vehicleSpeed\",name:\"Speed\",description:\"Vehicle speed\",convert:\"A\",dataType:\"decimal\",units:\"km/h\"},\"01-0E\":{numBytes:\"1\",key:\"timingAdvance\",name:\"Timing Advance\",description:\"Timing advance\",convert:\"A/2 - 64\",dataType:\"decimal\",units:\"deg\"},\"01-0F\":{numBytes:\"1\",key:\"intakeAirTemperature\",\r\nname:\"Intake Air Temp\",description:\"Intake air temperature\",convert:\"A-40\",dataType:\"decimal\",units:\"degC\"},\"01-10\":{numBytes:\"2\",key:\"massAirFlow\",name:\"Mass Airflow\",description:\"Mass airflow\",convert:\"(A*256+B)/100\",dataType:\"decimal\",units:\"g/s\"},\"01-11\":{numBytes:\"1\",key:\"absoluteThrottleSensorPosition\",name:\"Throttle Position\",description:\"Absolute Throttle sensor position\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-12\":{numBytes:\"1\",key:\"secondaryAirStatus\",name:\"2nd Air Status\",\r\ndescription:\"Secondary air status\",dataType:\"string\"},\"01-13\":{numBytes:\"1\",key:\"oxygenSensorLocations\",name:\"O2 Sensor Locations\",description:\"Oxygen sensor locations bank/sensor\",dataType:\"string\"},\"01-14\":[{numBytes:\"2\",key:\"oxygenSensorVoltage1a\",name:\"O2 Sensor Voltage 1a\",description:\"Bank 1 - sensor 1 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",dataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim1a\",name:\"Short Term Fuel Trim 1a\",description:\"Bank 1 - sensor 1 (wide range 02S): Short term fuel trim\",\r\nconvert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-15\":[{numBytes:\"2\",key:\"oxygenSensorVoltage1b\",name:\"O2 Sensor Voltage 1b\",description:\"Bank 1 - sensor 2 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",dataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim1b\",name:\"Short Term Fuel Trim 1b\",description:\"Bank 1 - sensor 2 (wide range 02S): Short term fuel trim\",convert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-16\":[{numBytes:\"2\",key:\"oxygenSensorVoltage1c\",\r\nname:\"O2 Sensor Voltage 1c\",description:\"Bank 1 - sensor 3 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",dataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim1c\",name:\"Short Term Fuel Trim 1c\",description:\"Bank 1 - sensor 3 (wide range 02S): Short term fuel trim\",convert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-17\":[{numBytes:\"2\",key:\"oxygenSensorVoltage1d\",name:\"O2 Sensor Voltage 1d\",description:\"Bank 1 - sensor 4 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",\r\ndataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim1d\",name:\"Short Term Fuel Trim 1d\",description:\"Bank 1 - sensor 4 (wide range 02S): Short term fuel trim\",convert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-18\":[{numBytes:\"2\",key:\"oxygenSensorVoltage2a\",name:\"O2 Sensor Voltage 2a\",description:\"Bank 2 - sensor 1 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",dataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim2a\",name:\"Short Term Fuel Trim 2a\",description:\"Bank 2 - sensor 1 (wide range 02S): Short term fuel trim\",\r\nconvert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-19\":[{numBytes:\"2\",key:\"oxygenSensorVoltage2b\",name:\"O2 Sensor Voltage 2b\",description:\"Bank 2 - sensor 2 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",dataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim2b\",name:\"Short Term Fuel Trim 2b\",description:\"Bank 2 - sensor 2 (wide range 02S): Short term fuel trim\",convert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-1A\":[{numBytes:\"2\",key:\"oxygenSensorVoltage2c\",\r\nname:\"O2 Sensor Voltage 2c\",description:\"Bank 2 - sensor 3 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",dataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim2c\",name:\"Short Term Fuel Trim 2c\",description:\"Bank 2 - sensor 3 (wide range 02S): Short term fuel trim\",convert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-1B\":[{numBytes:\"2\",key:\"oxygenSensorVoltage2d\",name:\"O2 Sensor Voltage 2d\",description:\"Bank 2 - sensor 4 (wide range O2S): Oxygen sensor voltage\",convert:\"A/200\",\r\ndataType:\"decimal\",units:\"V\"},{numBytes:\"2\",key:\"shortTermFuelTrim2d\",name:\"Short Term Fuel Trim 2d\",description:\"Bank 2 - sensor 4 (wide range 02S): Short term fuel trim\",convert:\"(B-128) * 100/128\",dataType:\"decimal\",units:\"%\"}],\"01-1C\":{numBytes:\"1\",key:\"designOBDRequirements\",name:\"Design OBD Reqs\",description:\"Design OBD requirements\",dataType:\"string\"},\"01-1D\":{numBytes:\"1\",key:\"alternateOxygenSensorLocations\",name:\"Alternate O2 Sensors\",description:\"Alternate Oxy sensor locations\",dataType:\"string\"},\r\n\"01-1E\":{numBytes:\"1\",key:\"auxilliaryInputStatus\",name:\"Aux Input Status\",description:\"Auxilliary input status\",dataType:\"string\"},\"01-1F\":{numBytes:\"2\",key:\"runTimeSinceEngineStart\",name:\"Run Time\",description:\"Run time since engine start\",convert:\"(A*256+B)\",dataType:\"decimal\",units:\"s\"},\"01-20\":{numBytes:\"4\",key:\"supportedPIDs2\",name:\"Supported PIDs 2\",description:\"Determine PIDs supported (range 21h to 40h )\",dataType:\"string\"},\"01-21\":{numBytes:\"2\",key:\"distanceTraveledMILActivated\",name:\"MIL Distance\",\r\ndescription:\"Distance traveled while malfunction indicator lamp is on\",convert:\"(A*256+B)\",dataType:\"decimal\",units:\"km\"},\"01-22\":{numBytes:\"2\",key:\"fuelRailPressureRelManifold\",name:\"Rel. Fuel Rail Pressure\",description:\"Fuel rail pressure relative manifold\",convert:\"(A*256+B)*.079\",dataType:\"decimal\",units:\"kPa\"},\"01-23\":{numBytes:\"2\",key:\"fuelRailPressure\",name:\"Fuel Rail Pressure\",description:\"Fuel rail pressure\",convert:\"(A*256+B)*10\",dataType:\"decimal\",units:\"kPa (gauge)\"},\"01-24\":[{numBytes:\"4\",\r\nkey:\"equivalenceRatio1a\",name:\"Equivalence Ratio 1a\",description:\"Bank 1 - sensor 1 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage1a\",name:\"Voltage 1a\",description:\"Bank 1 - sensor 1 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-25\":[{numBytes:\"4\",key:\"equivalenceRatio1b\",name:\"Equivalence Ratio 1b\",description:\"Bank 1 - sensor 2 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",\r\ndataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage1b\",name:\"Voltage 1b\",description:\"Bank 1 - sensor 2 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-26\":[{numBytes:\"4\",key:\"equivalenceRatio1c\",name:\"Equivalence Ratio 1c\",description:\"Bank 1 - sensor 3 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage1c\",name:\"Voltage 1c\",description:\"Bank 1 - sensor 3 (wide range 02S): Voltage\",\r\nconvert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-27\":[{numBytes:\"4\",key:\"equivalenceRatio1d\",name:\"Equivalence Ratio 1d\",description:\"Bank 1 - sensor 4 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage1d\",name:\"Voltage 1d\",description:\"Bank 1 - sensor 4 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-28\":[{numBytes:\"4\",key:\"equivalenceRatio2a\",name:\"Equivalence Ratio 2a\",\r\ndescription:\"Bank 2 - sensor 1 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage2a\",name:\"Voltage 2a\",description:\"Bank 2 - sensor 1 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-29\":[{numBytes:\"4\",key:\"equivalenceRatio2b\",name:\"Equivalence Ratio 2b\",description:\"Bank 2 - sensor 2 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",\r\nkey:\"voltage2b\",name:\"Voltage 2b\",description:\"Bank 2 - sensor 2 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-2A\":[{numBytes:\"4\",key:\"equivalenceRatio2c\",name:\"Equivalence Ratio 2c\",description:\"Bank 2 - sensor 3 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage2c\",name:\"Voltage 2c\",description:\"Bank 2 - sensor 3 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",\r\nunits:\"V\"}],\"01-2B\":[{numBytes:\"4\",key:\"equivalenceRatio2d\",name:\"Equivalence Ratio 2d\",description:\"Bank 2 - sensor 4 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)*2/65535\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"voltage2d\",name:\"Voltage 2d\",description:\"Bank 2 - sensor 4 (wide range 02S): Voltage\",convert:\"((C*256)+D)*8/65535\",dataType:\"decimal\",units:\"V\"}],\"01-2C\":{numBytes:\"1\",key:\"commandedExhaustGasRecirculation\",name:\"Commanded EGR\",description:\"Commanded exhaust gas recirculation\",\r\nconvert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-2D\":{numBytes:\"1\",key:\"exhaustGasRecirculationError\",name:\"EGR error\",description:\"Exhaust gas recirculation error\",convert:\"(A-128)*100/128\",dataType:\"decimal\",units:\"%\"},\"01-2E\":{numBytes:\"1\",key:\"commandedEvaporativePurge\",name:\"Evaporative Purge\",description:\"Commanded evaporative purge\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-2F\":{numBytes:\"1\",key:\"fuelLevelInput\",name:\"Fuel Level Input\",description:\"Fuel level input\",convert:\"A*100/255\",\r\ndataType:\"decimal\",units:\"%\"},\"01-30\":{numBytes:\"1\",key:\"numberOfWarmupsSinceDTCsCleared\",name:\"Warmups Since DTCs Cleared\",description:\"Number of warm-ups since DTCs cleared\",convert:\"A\",dataType:\"decimal\",units:\"\"},\"01-31\":{numBytes:\"2\",key:\"distanceSinceDTCsCleared\",name:\"Distance Since DTCs Cleared\",description:\"Distance traveled since DTCs cleared\",convert:\"A*256+B\",dataType:\"decimal\",units:\"km\"},\"01-32\":{numBytes:\"2\",key:\"evapSystemVaporPressure1\",name:\"Evap. Vapor Pressure 1\",description:\"Evap system vapor pressure 1 FIXME CHECKME\",\r\nconvert:\"(A*256+B)/4\",dataType:\"decimal\",units:\"Pa\"},\"01-33\":{numBytes:\"1\",key:\"barometricPressure\",name:\"Barometric Pressure\",description:\"Barometric pressure\",convert:\"A\",dataType:\"decimal\",units:\"kPa (abs)\"},\"01-34\":[{numBytes:\"4\",key:\"equivalenceRatio1aa\",name:\"Equivalence Ratio 1aa\",description:\"Bank 1 - sensor 1 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current1a\",name:\"Current 1a\",description:\"Bank 1 - sensor 1 (wide range 02S): Current\",\r\nconvert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-35\":[{numBytes:\"4\",key:\"equivalenceRatio1bb\",name:\"Equivalence Ratio 1bb\",description:\"Bank 1 - sensor 2 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current1b\",name:\"Current 1b\",description:\"Bank 1 - sensor 2 (wide range 02S): Current\",convert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-36\":[{numBytes:\"4\",key:\"equivalenceRatio1cc\",name:\"Equivalence Ratio 1cc\",\r\ndescription:\"Bank 1 - sensor 3 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current1c\",name:\"Current 1c\",description:\"Bank 1 - sensor 3 (wide range 02S): Current\",convert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-37\":[{numBytes:\"4\",key:\"equivalenceRatio1dd\",name:\"Equivalence Ratio 1dd\",description:\"Bank 1 - sensor 4 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",\r\nkey:\"current1d\",name:\"Current 1d\",description:\"Bank 1 - sensor 4 (wide range 02S): Current\",convert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-38\":[{numBytes:\"4\",key:\"equivalenceRatio2aa\",name:\"Equivalence Ratio 2aa\",description:\"Bank 2 - sensor 1 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current2a\",name:\"Current 2a\",description:\"Bank 2 - sensor 1 (wide range 02S): Current\",convert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",\r\nunits:\"mA\"}],\"01-39\":[{numBytes:\"4\",key:\"equivalenceRatio2bb\",name:\"Equivalence Ratio 2bb\",description:\"Bank 2 - sensor 2 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current2b\",name:\"Current 2b\",description:\"Bank 2 - sensor 2 (wide range 02S): Current\",convert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-3A\":[{numBytes:\"4\",key:\"equivalenceRatio2cc\",name:\"Equivalence Ratio 2cc\",description:\"Bank 2 - sensor 3 (wide range O2S): Equivalence Ratio\",\r\nconvert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current2c\",name:\"Current 2c\",description:\"Bank 2 - sensor 3 (wide range 02S): Current\",convert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-3B\":[{numBytes:\"4\",key:\"equivalenceRatio2dd\",name:\"Equivalence Ratio 2dd\",description:\"Bank 2 - sensor 4 (wide range O2S): Equivalence Ratio\",convert:\"((A*256)+B)/32768\",dataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"current2d\",name:\"Current 2d\",description:\"Bank 2 - sensor 4 (wide range 02S): Current\",\r\nconvert:\"((C*256)+D)/256 - 128\",dataType:\"decimal\",units:\"mA\"}],\"01-3C\":{numBytes:\"2\",key:\"catalystTemp1a\",name:\"Catalyst Temp 1a\",description:\"Catalyst Temperature bank 1, sensor 1\",convert:\"((A*256)+B)/10 - 40\",dataType:\"decimal\",units:\"degC\"},\"01-3D\":{numBytes:\"2\",key:\"catalystTemp2a\",name:\"Catalyst Temp 2a\",description:\"Catalyst Temperature bank 2, sensor 1\",convert:\"((A*256)+B)/10 - 40\",dataType:\"decimal\",units:\"degC\"},\"01-3E\":{numBytes:\"2\",key:\"catalystTemp1b\",name:\"Catalyst Temp 1b\",description:\"Catalyst Temperature bank 1, sensor 2\",\r\nconvert:\"((A*256)+B)/10 - 40\",dataType:\"decimal\",units:\"degC\"},\"01-3F\":{numBytes:\"2\",key:\"catalystTemp2b\",name:\"Catalyst Temp 2b\",description:\"Catalyst Temperature bank 2, sensor 2\",convert:\"((A*256)+B)/10 - 40\",dataType:\"decimal\",units:\"degC\"},\"01-40\":{numBytes:\"4\",key:\"supportedPIDs3\",name:\"Supported PIDs 3\",description:\"Determine PIDs supported (range 41h to 60h )\",dataType:\"string\"},\"01-41\":{numBytes:\"4\",key:\"monitorStatusThisDrivingCycle\",name:\"Monitor Status\",description:\"Monitor status this driving cycle\",\r\ndataType:\"string\"},\"01-42\":{numBytes:\"2\",key:\"controlModuleVoltage\",name:\"Control Mod. Voltage\",description:\"Control module voltage\",convert:\"((A*256)+B)/1000\",dataType:\"decimal\",units:\"V\"},\"01-43\":{numBytes:\"2\",key:\"absoluteLoadValue\",name:\"Abs. Load Value\",description:\"Absolute load value\",convert:\"((A*256)+B)*100/255\",dataType:\"decimal\",units:\"%\"},\"01-44\":{numBytes:\"2\",key:\"fuelAirCommandedEquivalenceRatio\",name:\"Air/Fuel Ratio\",description:\"Fuel/air commanded equivalence ratio\",convert:\"((A*256)+B)/32768\",\r\ndataType:\"decimal\",units:\"\"},\"01-45\":{numBytes:\"1\",key:\"relativeThrottlePosition\",name:\"Rel. Throttle Position\",description:\"Relative throttle position\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-46\":{numBytes:\"1\",key:\"ambientAirTemperature\",name:\"Ambient Air Temp\",description:\"Ambient air temperature\",convert:\"A-40\",dataType:\"decimal\",units:\"degC\"},\"01-47\":{numBytes:\"1\",key:\"absoluteThrottlePositionb\",name:\"Abs. Throttle Position B\",description:\"Absolute throttle position B\",convert:\"A*100/255\",\r\ndataType:\"decimal\",units:\"%\"},\"01-48\":{numBytes:\"1\",key:\"absoluteThrottlePositionc\",name:\"Abs. Throttle Position C\",description:\"Absolute throttle position C\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-49\":{numBytes:\"1\",key:\"acceleratorPedalPositiond\",name:\"Accelerator Position D\",description:\"Accelerator pedal position D\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-4A\":{numBytes:\"1\",key:\"acceleratorPedalPositione\",name:\"Accelerator Position E\",description:\"Accelerator pedal position E\",\r\nconvert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-4B\":{numBytes:\"1\",key:\"acceleratorPedalPositionf\",name:\"Accelerator Position F\",description:\"Accelerator pedal position F\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-4C\":{numBytes:\"1\",key:\"commandedThrottleActuatorControl\",name:\"Throttle Actuator Position\",description:\"Commanded throttle actuator control\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-4D\":{numBytes:\"2\",key:\"engineRuntimeWhileMILOn\",name:\"Runtime With MIL On\",\r\ndescription:\"Engine run time while malfunction indicator light is activated\",convert:\"A*256+B\",dataType:\"decimal\",units:\"min\"},\"01-4E\":{numBytes:\"2\",key:\"engineRuntimeSinceDTCsCleared\",name:\"Runtime Since DTCs Cleared\",description:\"Engine runtime since DTCs cleared\",convert:\"A*256+B\",dataType:\"decimal\",units:\"min\"},\"01-4F\":[{numBytes:\"4\",key:\"externalEquipmentEquivalenceRatio1\",name:\"External Equiv. Ratio 1\",description:\"External test equipment configuration information #1: equivalence ratio\",convert:\"A\",\r\ndataType:\"decimal\",units:\"\"},{numBytes:\"4\",key:\"externalO2Voltage1\",name:\"External O2 Voltage 1\",description:\"External test equipment configuration information #1: oxygen sensor voltage\",convert:\"B\",dataType:\"decimal\",units:\"V\"},{numBytes:\"4\",key:\"externalO2Current1\",name:\"External O2 Current\",description:\"External test equipment configuration information #1: oxygen sensor current\",convert:\"C\",dataType:\"decimal\",units:\"mA\"},{numBytes:\"4\",key:\"externalAbsIntakeManifoldPressure1\",name:\"External Manifold Pressure 1\",\r\ndescription:\"External test equipment configuration information #1: intake manifold abs pressure\",convert:\"D*10\",dataType:\"decimal\",units:\"kPa\"}],\"01-50\":{numBytes:\"2\",key:\"extTestEquipmentConfig2\",name:\"External Config 2\",description:\"External test equipment configuration information #2\",dataType:\"string\"},\"01-51\":{numBytes:\"1\",key:\"fuelType\",name:\"Fuel Type\",description:\"Type of fuel currently being utilized by the vehicle\",dataType:\"string\"},\"01-52\":{numBytes:\"1\",key:\"ethanolFuelPercentage\",name:\"Ethanol Fuel %\",\r\ndescription:\"Ethanol fuel percentage\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-53\":{numBytes:\"2\",key:\"absEvapSystemVaporPressure\",name:\"Abs. Evap. Vapor Pressure\",description:\"Absolute evap system vapor pressure\",convert:\"((A*256)+B)/200\",dataType:\"decimal\",units:\"kPa\"},\"01-54\":{numBytes:\"2\",key:\"evapSystemVaporPressure2\",name:\"Evap. Vapor Pressure 2\",description:\"Evap system vapor pressure 2\",convert:\"A*256+B-32767\",dataType:\"decimal\",units:\"Pa\"},\"01-55\":[{numBytes:\"2\",key:\"2ndShortTermFuelTrim1\",\r\nname:\"2nd Short Term Fuel Trim 1\",description:\"Short term secondary O2 sensor fuel trim - bank 1\",convert:\"(A-128)*100/128\",dataType:\"decimal\",units:\"%\"},{numBytes:\"2\",key:\"2ndShortTermFuelTrim3\",name:\"2nd Short Term Fuel Trim 3\",description:\"Short term secondary O2 sensor fuel trim - bank 3\",convert:\"(B-128)*100/128\",dataType:\"decimal\",units:\"%\"}],\"01-56\":[{numBytes:\"2\",key:\"2ndLongTermFuelTrim1\",name:\"2nd Long Term Fuel Trim 1\",description:\"Long term secondary O2 sensor fuel trim - bank 1\",convert:\"(A-128)*100/128\",\r\ndataType:\"decimal\",units:\"%\"},{numBytes:\"2\",key:\"2ndLongTermFuelTrim3\",name:\"2nd Long Term Fuel Trim 3\",description:\"Long term secondary O2 sensor fuel trim - bank 3\",convert:\"(B-128)*100/128\",dataType:\"decimal\",units:\"%\"}],\"01-57\":[{numBytes:\"2\",key:\"2ndShortTermFuelTrim2\",name:\"2nd Short Term Fuel Trim 2\",description:\"Short term secondary O2 sensor fuel trim - bank 2\",convert:\"(A-128)*100/128\",dataType:\"decimal\",units:\"%\"},{numBytes:\"2\",key:\"2ndShortTermFuelTrim4\",name:\"2nd Short Term Fuel Trim 4\",\r\ndescription:\"Short term secondary O2 sensor fuel trim - bank 4\",convert:\"(B-128)*100/128\",dataType:\"decimal\",units:\"%\"}],\"01-58\":[{numBytes:\"2\",key:\"2ndLongTermFuelTrim2\",name:\"2nd Long Term Fuel Trim 2\",description:\"Long term secondary O2 sensor fuel trim - bank 2\",convert:\"(A-128)*100/128\",dataType:\"decimal\",units:\"%\"},{numBytes:\"2\",key:\"2ndLongTermFuelTrim4\",name:\"2nd Long Term Fuel Trim 4\",description:\"Long term secondary O2 sensor fuel trim - bank 4\",convert:\"(B-128)*100/128\",dataType:\"decimal\",\r\nunits:\"%\"}],\"01-59\":{numBytes:\"2\",key:\"absFuelRailPressure\",name:\"Abs Fuel Rail Pressure\",description:\"Fuel rail pressure (absolute)\",convert:\"(A*256+B)*10\",dataType:\"decimal\",units:\"kPa\"},\"01-5A\":{numBytes:\"1\",key:\"relativeAcceleratorPosition\",name:\"Rel. Accelerator Position\",description:\"Relative accelerator pedal position\",convert:\"A*100/255\",dataType:\"decimal\",units:\"%\"},\"01-5B\":{numBytes:\"1\",key:\"hybridBatteryLife\",name:\"Hybrid Battery Life\",description:\"Hybrid battery pack remaining life\",convert:\"A*100/255\",\r\ndataType:\"decimal\",units:\"%\"},\"01-5C\":{numBytes:\"1\",key:\"engineOilTemperature\",name:\"Engine Oil Temp\",description:\"Engine oil temperature\",convert:\"A-40\",dataType:\"decimal\",units:\"degC\"},\"01-5D\":{numBytes:\"2\",key:\"fuelInjectionTiming\",name:\"Fuel Injection Timing\",description:\"Fuel injection timing\",convert:\"(((A*256)+B)-26880)/128\",dataType:\"decimal\",units:\"deg\"},\"01-5E\":{numBytes:\"2\",key:\"engineFuelRate\",name:\"Engine Fuel Rate\",description:\"Engine fuel rate\",convert:\"((A*256)+B)*0.05\",dataType:\"decimal\",\r\nunits:\"L/h\"},\"01-5F\":{numBytes:\"2\",key:\"emissionReqs\",name:\"Emission Reqs\",description:\"Emission requirements to which vehicle is designed\",dataType:\"string\"},\"01-60\":{numBytes:\"4\",key:\"supportedPIDs4\",name:\"Supported PIDs 4\",description:\"Determine PIDs supported (range 61h to 80h )\",dataType:\"string\"},\"01-61\":{numBytes:\"1\",key:\"driversDemandEnginePercentTorque\",name:\"Demand Engine % Torque\",description:\"Driver's demand engine - percent torque\",convert:\"A-125\",dataType:\"decimal\",units:\"%\"},\"01-62\":{numBytes:\"1\",\r\nkey:\"actualEnginePercentTorque\",name:\"Engine % Torque\",description:\"Actual engine - percent torque\",convert:\"A-125\",dataType:\"decimal\",units:\"%\"},\"01-63\":{numBytes:\"2\",key:\"engineReferenceTorque\",name:\"Engine Reference Torque\",description:\"Engine reference torque\",convert:\"A*256+B\",dataType:\"decimal\",units:\"Nm\"},\"01-64\":{numBytes:\"1\",key:\"enginePercentTorqueData\",name:\"Engine % Torque Data\",description:\"Engine percent torque data\",convert:\"A-125\",dataType:\"decimal\",units:\"%\"},\"01-65\":{numBytes:\"2\",\r\nkey:\"auxIO\",name:\"Auxilliary I/O\",description:\"Auxiliary inputs / outputs\"},\"01-66\":{numBytes:\"2\",key:\"mafSensor\",name:\"Mass Air Flow Sensor\",description:\"Mass air flow sensor\"},\"01-67\":{numBytes:\"2\",key:\"engineCoolantTemp\",name:\"Engine Coolant Temp\",description:\"Engine coolant temperature\"},\"01-68\":{numBytes:\"2\",key:\"intakeAirTempSensor\",name:\"Intake Air Temp Sensor\",description:\"Intake air temperature sensor\"},\"01-69\":{numBytes:\"2\",key:\"commandedEGRAndError\",name:\"Commanded EGR/Error\",description:\"Commanded EGR and EGR error\"},\r\n\"01-6A\":{numBytes:\"2\",key:\"intakeAirFlow\",name:\"Intake Air Flow\",description:\"Commanded diesel intake air flow control and relative intake air flow position\"},\"01-6B\":{numBytes:\"2\",key:\"egrTemp\",name:\"EGR Temp\",description:\"Exhaust gas recirculation temperature\"},\"01-6C\":{numBytes:\"2\",key:\"throttleActuatorControlPosition\",name:\"Throttle Control/Position\",description:\"Commanded throttle actuator control and relative throttle position\"},\"01-6D\":{numBytes:\"2\",key:\"fuelPressureControlSystem\",name:\"Fuel Pressure Control\",\r\ndescription:\"Fuel pressure control system\"},\"01-6E\":{numBytes:\"2\",key:\"injectionPressureControlSystem\",name:\"Injection Pressure Control\",description:\"Injection pressure control system\"},\"01-6F\":{numBytes:\"2\",key:\"turbochargerCompressorInletPressure\",name:\"Turbocharger Pressure\",description:\"Turbocharger compressor inlet pressure\"},\"01-70\":{numBytes:\"2\",key:\"boostPressureControl\",name:\"Boost Pressure Control\",description:\"Boost pressure control\"},\"01-71\":{numBytes:\"2\",key:\"vgtControl\",name:\"VGT Control\",\r\ndescription:\"Variable geometry turbo (VGT) control\"},\"01-72\":{numBytes:\"2\",key:\"wastegateControl\",name:\"Wastegate Control\",description:\"Wastegate control\"},\"01-73\":{numBytes:\"2\",key:\"exhaustPressure\",name:\"Exhaust Pressure\",description:\"Exhaust pressure\"},\"01-74\":{numBytes:\"2\",key:\"turbochargerRPM\",name:\"Turbocharger RPM\",description:\"Turbocharger RPM\"},\"01-75\":{numBytes:\"2\",key:\"tcTempA\",name:\"Turbocharger A Temp\",description:\"Turbocharger A temperature\"},\"01-76\":{numBytes:\"2\",key:\"tcTempC\",name:\"Turbocharger B Temp\",\r\ndescription:\"Turbocharger B temperature\"},\"01-77\":{numBytes:\"2\",key:\"cact\",name:\"Charge Air Cooler Temp\",description:\"Charge air cooler temperature (CACT)\"},\"01-78\":{numBytes:\"9\",key:\"egtBank1\",name:\"Exhaust Gas Temp 1\",description:\"Exhaust gas temperature (EGT) bank 1\",dataType:\"string\"},\"01-79\":{numBytes:\"9\",key:\"egtBank2\",name:\"Exhaust Gas Temp 2\",description:\"Exhaust gas temperature (EGT) bank 2\",dataType:\"string\"},\"01-7A\":{numBytes:\"2\",key:\"dpf1\",name:\"Diesel Filter 1\",description:\"Diesel particulate filter (DPF) bank 1\"},\r\n\"01-7B\":{numBytes:\"2\",key:\"dpf2\",name:\"Diesel Filter 2\",description:\"Diesel particulate filter (DPF) bank 2\"},\"01-7C\":{numBytes:\"2\",key:\"dpfTemp\",name:\"Diesel Filter Temp\",description:\"Diesel particulate filter (DPF) temperature\"},\"01-7D\":{numBytes:\"2\",key:\"noxNTEControlAreaStatus\",name:\"Nox NTE Status\",description:\"Nox NTE control area status\"},\"01-7E\":{numBytes:\"2\",key:\"pmNTEControlAreaStatus\",name:\"PM NTE Status\",description:\"PM NTE control area status\"},\"01-7F\":{numBytes:\"2\",key:\"engineRuntime\",\r\nname:\"Engine Runtime\",description:\"Engine run time\"},\"01-80\":{numBytes:\"4\",key:\"supportedPIDs5\",name:\"Supported PIDs 5\",description:\"Determine PIDs supported (range 81h to A0h )\",dataType:\"string\"},\"01-81\":{numBytes:\"2\",key:\"engineRuntime1\",name:\"Engine Runtime 1\",description:\"Engine run time for AECD #1 - #5\"},\"01-82\":{numBytes:\"2\",key:\"engineRuntime2\",name:\"Engine Runtime 2\",description:\"Engine run time for AECD #6 - #10\"},\"01-83\":{numBytes:\"2\",key:\"noxSensor\",name:\"Nox Sensor\",description:\"Nox sensor\"},\r\n\"01-84\":{numBytes:\"2\",key:\"manifoldTemp\",name:\"Manifold Temp\",description:\"Manifold surface temperature\"},\"01-85\":{numBytes:\"2\",key:\"noxControlSystem\",name:\"Nox Control System\",description:\"Nox control system\"},\"01-86\":{numBytes:\"2\",key:\"pmSensor\",name:\"Particulate Matter\",description:\"Particulate matter (PM) sensor\"},\"01-87\":{numBytes:\"2\",key:\"intakeManifoldAbsPressure\",name:\"Abs Intake Manifold Pressure\",description:\"Intake manifold absolute pressure\"},\"01-88\":{numBytes:\"2\",key:\"reservediISOSAE\",\r\nname:\"ISO/SAE Reserved\",description:\"ISO/SAE reserved\"},\"01-89\":{numBytes:\"4\",key:\"supportedPIDs6\",name:\"Supported PIDs 6\",description:\"Determine PIDs supported (range A1 to C0)\",dataType:\"string\"},\"01-8A\":{numBytes:\"4\",key:\"supportedPIDs7\",name:\"Supported PIDs 7\",description:\"Determine PIDs supported (range C1 to E0)\",dataType:\"string\"},\"01-8B\":{numBytes:\"4\",key:\"supportedPIDs8\",name:\"Supported PIDs 8\",description:\"Determine PIDs supported (range E1 to FF)\",dataType:\"string\"}},testInfo=function(a,\r\nb,c,d){var e={};e[d+\" test\"]=[];\"0\"===a[b]?e[d+\" test\"].push(\"not available\"):e[d+\" test\"].push(\"available\");\"0\"===a[c]?e[d+\" test\"].push(\"complete\"):e[d+\" test\"].push(\"incomplete\");return e},numToHex=function(a){return 16>a?\"0\"+a.toString(16).toUpperCase():a.toString(16).toUpperCase()},hexToBinary=function(a){for(var b=\"\",c=0;c<a.length;c+=2){for(var d=parseInt(a.slice(c,c+2),16).toString(2);8>d.length;)d=\"0\"+d;b+=d}return b},extraConverts={\"01-01\":function(a){var b={},c=hexToBinary(a);a=c.split(\"\");\r\nb[\"Check engine light\"]=\"1\"===a[0]?\"on\":\"off\";c=c.slice(1,8);b.DTCs=parseInt(c,2).toString(10);extend(b,testInfo(a,15,11,\"Misfire\"));extend(b,testInfo(a,14,10,\"Fuel System\"));extend(b,testInfo(a,13,9,\"Components\"));\"0\"===a[12]?(b.motor=\"spark ignition\",extend(b,testInfo(a,23,31,\"Catalyst\")),extend(b,testInfo(a,22,30,\"Heated Catalyst\")),extend(b,testInfo(a,21,29,\"Evaporative System\")),extend(b,testInfo(a,20,28,\"Secondary Air System\")),extend(b,testInfo(a,19,27,\"A/C Refrigerant\")),extend(b,testInfo(a,\r\n18,26,\"Oxygen Sensor\")),extend(b,testInfo(a,17,25,\"Oxygen Sensor Heater\")),extend(b,testInfo(a,16,24,\"EGR System\"))):(b.motor=\"compression ignition\",extend(b,testInfo(a,23,31,\"NMHC Catalyst\")),extend(b,testInfo(a,22,30,\"NOx/SCR Monitor\")),extend(b,testInfo(a,20,28,\"Boost Pressure\")),extend(b,testInfo(a,18,26,\"Exhaust Gas Sensor\")),extend(b,testInfo(a,17,25,\"PM filter monitoring\")),extend(b,testInfo(a,16,24,\"EGR and/or VVT System\")));return b},\"01-03\":function(a){var b={},c=a.slice(0,2);a=a.slice(2,\r\n4);var d={1:\"Open loop due to insufficient engine temperature\",2:\"Closed loop, using oxygen sensor feedback to determine fuel mix\",4:\"Open loop due to engine load or fuel cut due to deceleration\",8:\"Open loop due to system failure\",16:\"Closed loop, using at least one oxygen sensor but there is a fault in the feedback system\",0:\"Fuel system does not exist\"};b[\"Fuel System 1 Status\"]=d[parseInt(c,16).toString(10)];b[\"Fuel System 2 Status\"]=d[parseInt(a,16).toString(10)];return b},\"01-12\":function(a){return{1:\"Upstream of catalytic converter\",\r\n2:\"Downstream of catalytic converter\",4:\"From the outside atmosphere or off\",8:\"Pump commanded on for diagnostics\"}[parseInt(a,16).toString(10)]},\"01-13\":function(a){a=hexToBinary(a).split(\"\");for(var b=[],c=0;8>c;c++)\"1\"===a[7-c]&&b.push(\"Bank \"+(c/4+1|0)+\" Sensor \"+(c+5-4*(c/4+1|0)));return b},\"01-1C\":function(a){var b={1:\"OBD-II as defined by the CARB\",2:\"OBD-II as defined by the EPA\",3:\"OBD and OBD-II\",4:\"OBD-I\",5:\"Not OBD compliant\",6:\"EOBD (Europe)\",7:\"EOBD and OBD-II\",8:\"EOBD and OBD\",9:\"EOBD, OBD and OBD II\",\r\n10:\"JOBD (Japan)\",11:\"JOBD and OBD II\",12:\"JOBD and EOBD\",13:\"JOBD, EOBD, and OBD II\",14:\"Reserved\",15:\"Reserved\",16:\"Reserved\",17:\"Engine Manufacturer Diagnostics (EMD)\",18:\"Engine Manufacturer Diagnostics Enhanced (EMD+)\",19:\"Heavy Duty On-Board Diagnostics (Child/Partial) (HD OBD-C)\",20:\"Heavy Duty On-Board Diagnostics (HD OBD-C)\",21:\"World Wide Harmonized OBD (WWH OBD)\",22:\"Reserved\",23:\"Heavy Duty Euro OBD Stage I without NOx control (HD EOBD-I)\",24:\"Heavy Duty Euro OBD Stage I with NOx control (HD EOBD-I N)\",\r\n25:\"Heavy Duty Euro OBD Stage I without NOx control (HD EOBD-II)\",26:\"Heavy Duty Euro OBD Stage I with NOx control (HD EOBD-II N)\",27:\"Reserved\",28:\"Brazil OBD Phase 1 (OBDBr-1)\",29:\"Brazil OBD Phase 2 (OBDBr-2)\",30:\"Korean OBD (KOBD)\",31:\"India OBD I (IOBD I)\",32:\"India OBD II (IOBD II)\",33:\"Heavy Duty Euro OBD Stage VI (HD EOBD-IV)\"};a=parseInt(a,16).toString(10);return 1<=a&&33>=a?b[a]:33<a&&250>=a?\"Reserved\":\"Not avaiable for assignment (SAE J1939 special meaning)\"},\"01-1D\":function(a){a=hexToBinary(a).split(\"\");\r\nfor(var b=[],c=0;8>c;c++)\"1\"===a[7-c]&&b.push(\"Bank \"+(c/2+1|0)+\" Sensor \"+(c+3-2*(c/2+1|0)));return b},\"01-1E\":function(a){return\"1\"===hexToBinary(a).slice(-1)?\"active\":\"inactive\"},\"01-41\":function(a){var b={};a=hexToBinary(a).split(\"\");extend(b,testInfo(a,15,11,\"Misfire\"));extend(b,testInfo(a,14,10,\"Fuel System\"));extend(b,testInfo(a,13,9,\"Components\"));extend(b,testInfo(a,23,31,\"Catalyst\"));extend(b,testInfo(a,22,30,\"Heated Catalyst\"));extend(b,testInfo(a,21,29,\"Evaporative System\"));extend(b,\r\ntestInfo(a,20,28,\"Secondary Air System\"));extend(b,testInfo(a,19,27,\"A/C Refrigerant\"));extend(b,testInfo(a,18,26,\"Oxygen Sensor\"));extend(b,testInfo(a,17,25,\"Oxygen Sensor Heater\"));extend(b,testInfo(a,16,24,\"EGR System\"));return b},\"01-50\":function(){return\"no data available\"},\"01-5F\":function(){return\"no data available\"},\"01-51\":function(a){return{0:\"not available\",1:\"Gasoline\",2:\"Methanol\",3:\"Ethanol\",4:\"Diesel\",5:\"LPG\",6:\"CNG\",7:\"Propane\",8:\"Electric\",9:\"Bifuel running Gasoline\",10:\"Bifuel running Methanol\",\r\n11:\"Bifuel running Ethanol\",12:\"Bifuel running LPG\",13:\"Bifuel running CNG\",14:\"Bifuel running Propane\",15:\"Bifuel running Electricity\",16:\"Bifuel running electric and combustion engine\",17:\"Hybrid Gasoline\",18:\"Hybrid Ethanol\",19:\"Hybrid Diesel\",20:\"Hybrid Electric\",21:\"Hybrid running electric and combustion engine\",22:\"Hybrid Regenerative\",23:\"Bifuel running diesel\"}[parseInt(a,16).toString(10)]},\"01-78\":function(a){for(var b=hexToBinary(a.slice(0,2)).split(\"\"),c={},d=0;3>=d;d++){var e=a.slice(2+\r\n4*d,6+4*d);if(\"1\"===b[7-d]){var f=Number(parseInt(e.slice(0,2),16).toString(10)),e=Number(parseInt(e.slice(2,4),16).toString(10));c[\"Bank 1 Sensor \"+(d+1)]=\"Temperature: \"+String((256*f+e)/10-40)}else c[\"Bank 1 Sensor \"+(d+1)]=\"sensor is not supported\"}return c},\"01-79\":function(a){for(var b=hexToBinary(a.slice(0,2)).split(\"\"),c={},d=0;3>=d;d++){var e=a.slice(2+4*d,6+4*d);if(\"1\"===b[7-d]){var f=Number(parseInt(e.slice(0,2),16).toString(10)),e=Number(parseInt(e.slice(2,4),16).toString(10));c[\"Bank 2 Sensor \"+\r\n(d+1)]=\"Temperature: \"+String((256*f+e)/10-40)}else c[\"Bank 2 Sensor \"+(d+1)]=\"sensor is not supported\"}return c}},supportedPIDs=function(a,b){for(var c=parseInt(a,16),d=[],e=4*a.length,f=e-1;0<=f;f--)0!==(c&1<<f)&&d.push(numToHex(e-f+b));return d};extraConverts[\"01-00\"]=function(a){return supportedPIDs(a,0)};extraConverts[\"01-20\"]=function(a){return supportedPIDs(a,32)};extraConverts[\"01-40\"]=function(a){return supportedPIDs(a,64)};extraConverts[\"01-60\"]=function(a){return supportedPIDs(a,96)};\r\nextraConverts[\"01-80\"]=function(a){return supportedPIDs(a,128)};extraConverts[\"01-89\"]=function(a){return supportedPIDs(a,160)};extraConverts[\"01-8A\"]=function(a){return supportedPIDs(a,192)};extraConverts[\"01-8B\"]=function(a){return supportedPIDs(a,224)};\r\nvar generatedFunctions={},lookupConvert=function(a,b){var c=extend({},a);delete c.convert;return a.convert?(generatedFunctions[a.key]||(generatedFunctions[a.key]=function(b){for(var c=a.convert,f=c.match(/[A-Z]/g),h=[],k=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\".split(\"\"),g=0;g<b.length/2-.5|0;g++)h.push(parseInt(b.slice(2*g,2*g+2),16).toString(10));for(b=0;b<f.length;b++)c=c.replace(f[b],h[k.indexOf(f[b])]);return eval(c)}),extend({convert:generatedFunctions[a.key]},c)):extraConverts[b]?extend({convert:extraConverts[b]},\r\nc):extend({convert:\"no conversion available\"},c)},obdlib={getInfo:function(a){if(!pids[a])throw Error(\"Unknown parameter: \"+a);if(Array.isArray(pids[a])){var b=[];pids[a].forEach(function(a,d){b.push(lookupConvert(a,d))});return b}return lookupConvert(pids[a],a)},addPID:function(a,b){pids[a]=b}},mainlib={translate:function(a,b){try{var c=obdlib.getInfo(a);Array.isArray(c)||(c=[c]);var d=[];c.forEach(function(c){d.push(mainlib.convert(a,b,c))});return 1===d.length?d[0]:d}catch(e){return extend({error:e},\r\n{parameter:a,rawValue:b})}},convert:function(a,b,c){try{var d=2*parseInt(c.numBytes,10);b.length>d&&(b=b.slice(0,d));var e=extend({parameter:a,rawValue:b},c);if(b.match(/^([A-F0-9]{2})*$/))if(b.length<d)e.error=\"invalid message length\";else{if(\"function\"!==typeof e.convert)return e.error=\"no conversion available\",e;e.value=c.convert(b)}else e.error=\"invalid message character(s)\";delete e.convert;return e}catch(f){return extend({error:f},{parameter:a,rawValue:b})}}};";
  }

  static String lib() {
    return ObdJsLibHolder.LIB;
  }

  private ObdJsLib() {
  }
}
