/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.observables.ConnectableObservable;
import rx.schedulers.Timestamped;
import rx.subscriptions.Subscriptions;

public final class OperatorReplayFix<T>
extends ConnectableObservable<T> {
    final Observable<? extends T> source;
    final AtomicReference<ReplaySubscriber<T>> current;
    final Func0<? extends ReplayBuffer<T>> bufferFactory;
    static final Func0 DEFAULT_UNBOUNDED_FACTORY = new Func0(){

        public Object call() {
            return new UnboundedReplayBuffer(16);
        }
    };

    public static <T, U, R> Observable<R> multicastSelector(final Func0<? extends ConnectableObservable<U>> connectableFactory, final Func1<? super Observable<U>, ? extends Observable<R>> selector) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            public void call(final Subscriber<? super R> child) {
                Observable observable;
                ConnectableObservable co;
                try {
                    co = (ConnectableObservable)connectableFactory.call();
                    observable = (Observable)selector.call((Object)co);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    child.onError(e);
                    return;
                }
                observable.subscribe(child);
                co.connect((Action1)new Action1<Subscription>(){

                    public void call(Subscription t) {
                        child.add(t);
                    }
                });
            }
        });
    }

    public static <T> ConnectableObservable<T> observeOn(final ConnectableObservable<T> co, Scheduler scheduler) {
        final Observable observable = co.observeOn(scheduler);
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> child) {
                observable.unsafeSubscribe(new Subscriber<T>(child){

                    public void onNext(T t) {
                        child.onNext(t);
                    }

                    public void onError(Throwable e) {
                        child.onError(e);
                    }

                    public void onCompleted() {
                        child.onCompleted();
                    }
                });
            }
        };
        return new ConnectableObservable<T>(onSubscribe){

            public void connect(Action1<? super Subscription> connection) {
                co.connect(connection);
            }
        };
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source) {
        return OperatorReplayFix.create(source, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source, final int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return OperatorReplayFix.create(source);
        }
        return OperatorReplayFix.create(source, new Func0<ReplayBuffer<T>>(){

            public ReplayBuffer<T> call() {
                return new SizeBoundReplayBuffer(bufferSize);
            }
        });
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return OperatorReplayFix.create(source, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source, long maxAge, TimeUnit unit, final Scheduler scheduler, final int bufferSize) {
        final long maxAgeInMillis = unit.toMillis(maxAge);
        return OperatorReplayFix.create(source, new Func0<ReplayBuffer<T>>(){

            public ReplayBuffer<T> call() {
                return new SizeAndTimeBoundReplayBuffer(bufferSize, maxAgeInMillis, scheduler);
            }
        });
    }

    static <T> ConnectableObservable<T> create(Observable<? extends T> source, final Func0<? extends ReplayBuffer<T>> bufferFactory) {
        final AtomicReference<ReplaySubscriber<T>> curr = new AtomicReference<ReplaySubscriber<T>>();
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> child) {
                ReplaySubscriber r;
                while ((r = (ReplaySubscriber)((Object)curr.get())) == null) {
                    ReplaySubscriber u = new ReplaySubscriber(curr, (ReplayBuffer)bufferFactory.call());
                    u.init();
                    if (!curr.compareAndSet(r, u)) continue;
                    r = u;
                    break;
                }
                InnerProducer inner = new InnerProducer(r, child);
                r.add(inner);
                child.add(inner);
                child.setProducer(inner);
            }
        };
        return new OperatorReplayFix<T>(onSubscribe, source, curr, bufferFactory);
    }

    private OperatorReplayFix(Observable.OnSubscribe<T> onSubscribe, Observable<? extends T> source, AtomicReference<ReplaySubscriber<T>> current, Func0<? extends ReplayBuffer<T>> bufferFactory) {
        super(onSubscribe);
        this.source = source;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    public void connect(Action1<? super Subscription> connection) {
        ReplaySubscriber<T> ps;
        boolean doConnect = false;
        while ((ps = this.current.get()) == null || ps.isUnsubscribed()) {
            ReplaySubscriber<T> u = new ReplaySubscriber<T>(this.current, (ReplayBuffer)this.bufferFactory.call());
            u.init();
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        connection.call(ps);
        if (doConnect) {
            this.source.unsafeSubscribe(ps);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final Scheduler scheduler;
        final long maxAgeInMillis;
        final int limit;

        public SizeAndTimeBoundReplayBuffer(int limit, long maxAgeInMillis, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.limit = limit;
            this.maxAgeInMillis = maxAgeInMillis;
        }

        @Override
        Object enterTransform(Object value) {
            return new Timestamped(this.scheduler.now(), value);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((Timestamped)value).getValue();
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev = (Node)this.get();
            Node next = (Node)prev.get();
            int e = 0;
            while (next != null) {
                if (this.size > this.limit) {
                    ++e;
                    --this.size;
                    prev = next;
                    next = (Node)next.get();
                    continue;
                }
                Timestamped v = (Timestamped)next.value;
                if (v.getTimestampMillis() > timeLimit) break;
                ++e;
                --this.size;
                prev = next;
                next = (Node)next.get();
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }

        @Override
        void truncateFinal() {
            Timestamped v;
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev = (Node)this.get();
            int e = 0;
            for (Node next = (Node)prev.get(); next != null && this.size > 1 && (v = (Timestamped)next.value).getTimestampMillis() <= timeLimit; next = (Node)next.get()) {
                ++e;
                --this.size;
                prev = next;
            }
            if (e != 0) {
                this.setFirst(prev);
            }
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        public SizeBoundReplayBuffer(int limit) {
            this.limit = limit;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        final NotificationLite<T> nl = NotificationLite.instance();
        Node tail;
        int size;

        public BoundedReplayBuffer() {
            Node n;
            this.tail = n = new Node((Object)null);
            this.set(n);
        }

        final void addLast(Node n) {
            this.tail.set(n);
            this.tail = n;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next = (Node)head.get();
            if (next == null) {
                throw new IllegalStateException("Empty list!");
            }
            --this.size;
            this.setFirst(next);
        }

        final void removeSome(int n) {
            Node head = (Node)this.get();
            while (n > 0) {
                head = (Node)head.get();
                --n;
                --this.size;
            }
            this.setFirst(head);
        }

        final void setFirst(Node n) {
            this.set(n);
        }

        @Override
        public final void next(T value) {
            Object o = this.enterTransform(this.nl.next(value));
            Node n = new Node(o);
            this.addLast(n);
            this.truncate();
        }

        @Override
        public final void error(Throwable e) {
            Object o = this.enterTransform(this.nl.error(e));
            Node n = new Node(o);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o = this.enterTransform(this.nl.completed());
            Node n = new Node(o);
            this.addLast(n);
            this.truncateFinal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void replay(InnerProducer<T> output) {
            InnerProducer<T> innerProducer = output;
            synchronized (innerProducer) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isUnsubscribed()) {
                Node v;
                long r;
                long r0 = r = output.get();
                long e = 0L;
                Node node = (Node)output.index();
                if (node == null) {
                    node = (Node)this.get();
                    output.index = node;
                }
                while (r != 0L && (v = (Node)node.get()) != null) {
                    Object o = this.leaveTransform(v.value);
                    try {
                        if (this.nl.accept(output.child, o)) {
                            output.index = null;
                            return;
                        }
                    }
                    catch (Throwable err) {
                        output.index = null;
                        Exceptions.throwIfFatal((Throwable)err);
                        output.unsubscribe();
                        if (!this.nl.isError(o) && !this.nl.isCompleted(o)) {
                            output.child.onError(OnErrorThrowable.addValueAsLastCause((Throwable)err, (Object)this.nl.getValue(o)));
                        }
                        return;
                    }
                    ++e;
                    node = v;
                    if (!output.isUnsubscribed()) continue;
                    return;
                }
                if (e != 0L) {
                    output.index = node;
                    if (r0 != Long.MAX_VALUE) {
                        output.produced(e);
                    }
                }
                InnerProducer<T> innerProducer2 = output;
                synchronized (innerProducer2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        void truncate() {
        }

        void truncateFinal() {
        }

        final void collect(Collection<? super T> output) {
            Object o;
            Object v;
            Node next;
            Node n = (Node)this.get();
            while ((next = (Node)n.get()) != null && !this.nl.isCompleted(v = this.leaveTransform(o = next.value)) && !this.nl.isError(v)) {
                output.add(this.nl.getValue(v));
                n = next;
            }
        }

        boolean hasError() {
            return this.tail.value != null && this.nl.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && this.nl.isCompleted(this.leaveTransform(this.tail.value));
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;

        public Node(Object value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        final NotificationLite<T> nl = NotificationLite.instance();
        volatile int size;

        public UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(this.nl.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e) {
            this.add(this.nl.error(e));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(this.nl.completed());
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replay(InnerProducer<T> output) {
            InnerProducer<T> innerProducer = output;
            synchronized (innerProducer) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isUnsubscribed()) {
                long r;
                int sourceIndex = this.size;
                Integer destIndexObject = (Integer)output.index();
                int destIndex = destIndexObject != null ? destIndexObject : 0;
                long r0 = r = output.get();
                long e = 0L;
                while (r != 0L && destIndex < sourceIndex) {
                    Object o = this.get(destIndex);
                    try {
                        if (this.nl.accept(output.child, o)) {
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal((Throwable)err);
                        output.unsubscribe();
                        if (!this.nl.isError(o) && !this.nl.isCompleted(o)) {
                            output.child.onError(OnErrorThrowable.addValueAsLastCause((Throwable)err, (Object)this.nl.getValue(o)));
                        }
                        return;
                    }
                    if (output.isUnsubscribed()) {
                        return;
                    }
                    ++destIndex;
                    --r;
                    ++e;
                }
                if (e != 0L) {
                    output.index = destIndex;
                    if (r0 != Long.MAX_VALUE) {
                        output.produced(e);
                    }
                }
                InnerProducer<T> innerProducer2 = output;
                synchronized (innerProducer2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerProducer<T> var1);
    }

    static final class InnerProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -4453897557930727610L;
        final ReplaySubscriber<T> parent;
        final Subscriber<? super T> child;
        Object index;
        final AtomicLong totalRequested;
        boolean emitting;
        boolean missed;
        static final long UNSUBSCRIBED = Long.MIN_VALUE;

        public InnerProducer(ReplaySubscriber<T> parent, Subscriber<? super T> child) {
            this.parent = parent;
            this.child = child;
            this.totalRequested = new AtomicLong();
        }

        public void request(long n) {
            long u;
            long r;
            if (n < 0L) {
                return;
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return;
                }
                if (r >= 0L && n == 0L) {
                    return;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.addTotalRequested(n);
            this.parent.manageRequests();
            this.parent.buffer.replay(this);
        }

        void addTotalRequested(long n) {
            long u;
            long r;
            do {
                if ((u = (r = this.totalRequested.get()) + n) >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.totalRequested.compareAndSet(r, u));
        }

        public long produced(long n) {
            long u;
            long r;
            if (n <= 0L) {
                throw new IllegalArgumentException("Cant produce zero or less");
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                u = r - n;
                if (u >= 0L) continue;
                throw new IllegalStateException("More produced (" + n + ") than requested (" + r + ")");
            } while (!this.compareAndSet(r, u));
            return u;
        }

        public boolean isUnsubscribed() {
            return this.get() == Long.MIN_VALUE;
        }

        public void unsubscribe() {
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.manageRequests();
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplaySubscriber<T>
    extends Subscriber<T>
    implements Subscription {
        final ReplayBuffer<T> buffer;
        final NotificationLite<T> nl;
        boolean done;
        static final InnerProducer[] EMPTY = new InnerProducer[0];
        static final InnerProducer[] TERMINATED = new InnerProducer[0];
        final AtomicReference<InnerProducer[]> producers;
        final AtomicBoolean shouldConnect;
        boolean emitting;
        boolean missed;
        long maxChildRequested;
        long maxUpstreamRequested;
        volatile Producer producer;

        public ReplaySubscriber(AtomicReference<ReplaySubscriber<T>> current, ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.nl = NotificationLite.instance();
            this.producers = new AtomicReference<InnerProducer[]>(EMPTY);
            this.shouldConnect = new AtomicBoolean();
            this.request(0L);
        }

        void init() {
            this.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    ReplaySubscriber.this.producers.getAndSet(TERMINATED);
                }
            }));
        }

        boolean add(InnerProducer<T> producer) {
            InnerProducer[] u;
            InnerProducer[] c;
            if (producer == null) {
                throw new NullPointerException();
            }
            do {
                if ((c = this.producers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerProducer[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.producers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerProducer<T> producer) {
            InnerProducer[] u;
            InnerProducer[] c;
            do {
                if ((c = this.producers.get()) == EMPTY || c == TERMINATED) {
                    return;
                }
                int j = -1;
                int len = c.length;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerProducer[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.producers.compareAndSet(c, u));
        }

        public void setProducer(Producer p) {
            Producer p0 = this.producer;
            if (p0 != null) {
                throw new IllegalStateException("Only a single producer can be set on a Subscriber.");
            }
            this.producer = p;
            this.manageRequests();
            this.replay();
        }

        public void onNext(T t) {
            if (!this.done) {
                this.buffer.next(t);
                this.replay();
            }
        }

        public void onError(Throwable e) {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.error(e);
                    this.replay();
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        public void onCompleted() {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.complete();
                    this.replay();
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void manageRequests() {
            if (this.isUnsubscribed()) {
                return;
            }
            ReplaySubscriber replaySubscriber = this;
            synchronized (replaySubscriber) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            while (!this.isUnsubscribed()) {
                long ri;
                InnerProducer[] a = this.producers.get();
                long maxTotalRequests = ri = this.maxChildRequested;
                for (InnerProducer rp : a) {
                    maxTotalRequests = Math.max(maxTotalRequests, rp.totalRequested.get());
                }
                long ur = this.maxUpstreamRequested;
                Producer p = this.producer;
                long diff = maxTotalRequests - ri;
                if (diff != 0L) {
                    this.maxChildRequested = maxTotalRequests;
                    if (p != null) {
                        if (ur != 0L) {
                            this.maxUpstreamRequested = 0L;
                            p.request(ur + diff);
                        } else {
                            p.request(diff);
                        }
                    } else {
                        long u = ur + diff;
                        if (u < 0L) {
                            u = Long.MAX_VALUE;
                        }
                        this.maxUpstreamRequested = u;
                    }
                } else if (ur != 0L && p != null) {
                    this.maxUpstreamRequested = 0L;
                    p.request(ur);
                }
                ReplaySubscriber replaySubscriber2 = this;
                synchronized (replaySubscriber2) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                }
            }
            return;
        }

        void replay() {
            InnerProducer[] a;
            for (InnerProducer rp : a = this.producers.get()) {
                this.buffer.replay(rp);
            }
        }
    }
}

