/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.deviceservice.utils;

import android.util.Log;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;
import rx.Observer;

public abstract class ObserverAdapter<T>
extends BaseAdapter
implements Observer<T> {
    private final List<T> mItems = new ArrayList<T>();
    private final String mTag = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean mIsCompleted = false;

    public int getCount() {
        return this.mItems.size();
    }

    public T getItem(int position) {
        return this.mItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void onCompleted() {
        this.mIsCompleted = true;
    }

    public void onError(Throwable e) {
        Log.e((String)this.mTag, (String)"error while observing for list", (Throwable)e);
        this.mIsCompleted = true;
    }

    public void onNext(T item) {
        this.mItems.add(item);
        this.notifyDataSetChanged();
    }

    public boolean isCompleted() {
        return this.mIsCompleted;
    }
}

