/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.deviceservice;

import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

final class Cancelations {
    private final Set<Cancelation> cancelations = Collections.newSetFromMap(new ConcurrentHashMap());

    void cancelAll(@NonNull Throwable t) {
        for (Cancelation c : new HashSet<Cancelation>(this.cancelations)) {
            c.cancel(t);
        }
    }

    Cancelation create(final @NonNull Subscriber<?> s) {
        final Cancelation c = new Cancelation(){

            @Override
            public void cancel(@NonNull Throwable t) {
                Cancelations.this.cancelations.remove(this);
                if (!s.isUnsubscribed()) {
                    s.onError(t);
                }
            }
        };
        this.cancelations.add(c);
        s.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                Cancelations.this.cancelations.remove(c);
            }
        }));
        return c;
    }

    public static Cancelations createGroup() {
        return new Cancelations();
    }

    private Cancelations() {
    }

    static abstract class Cancelation {
        public abstract void cancel(@NonNull Throwable var1);

        private Cancelation() {
        }
    }
}

