/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.deviceservice;

import android.bluetooth.BluetoothGattCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import li.vin.my.deviceservice.Cancelations;
import li.vin.my.deviceservice.DeviceConnection;
import li.vin.my.deviceservice.DeviceServiceFunc;
import li.vin.my.deviceservice.DeviceServiceFuncResetDtcs;
import li.vin.my.deviceservice.IDevServ;
import li.vin.my.deviceservice.Param;
import li.vin.my.deviceservice.Params;
import li.vin.my.deviceservice.R;
import li.vin.my.deviceservice.SupportedPids;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.internal.operators.OperatorReplayFix;

class BtLeDeviceConnection
extends BluetoothGattCallback
implements DeviceConnection {
    private static final String TAG = BtLeDeviceConnection.class.getSimpleName();
    private final Map<Object, Observable<?>> paramObservables = new IdentityHashMap();
    private final Set<Object> ops = Collections.newSetFromMap(new IdentityHashMap());
    private volatile IDevServ devServ;
    private volatile boolean isServiceBound;
    private final HashSet<Runnable> runOnServiceConnected = new HashSet();
    private final Cancelations cancelations = Cancelations.createGroup();
    private final Handler handler = new Handler(Looper.getMainLooper());
    private WeakReference<Context> contextRef;
    final String chipId;
    final String deviceName;
    final String deviceIcon;
    final String deviceId;
    private final Func2<Integer, Throwable, Boolean> retryOnDisconnect = new Func2<Integer, Throwable, Boolean>(){

        public Boolean call(Integer integer, Throwable throwable) {
            Log.i((String)TAG, (String)"retryOnDisconnect...");
            if (throwable instanceof ServiceDisconnectedException) {
                BtLeDeviceConnection.this.isServiceBound = false;
                return true;
            }
            return false;
        }
    };
    private final Runnable shutdown = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.e((String)TAG, (String)"shutdown.");
            BtLeDeviceConnection.this.handler.removeCallbacks((Runnable)this);
            try {
                Context context = BtLeDeviceConnection.this.context();
                if (context == null) {
                    throw new Exception("no Context available.");
                }
                context.unbindService(BtLeDeviceConnection.this.servConn);
                Log.d((String)TAG, (String)"Vinli device service successfully unbound.");
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Vinli device service unbind error: " + e));
            }
            BtLeDeviceConnection.this.isServiceBound = false;
            BtLeDeviceConnection.this.devServ = null;
            BtLeDeviceConnection.this.paramObservables.clear();
            BtLeDeviceConnection.dispatchAndClear(BtLeDeviceConnection.this.runOnServiceConnected);
            Set set = BtLeDeviceConnection.this.ops;
            synchronized (set) {
                BtLeDeviceConnection.this.ops.clear();
            }
            BtLeDeviceConnection.this.cancelations.cancelAll(new Exception("Service binding has shut down."));
        }
    };
    private final ServiceConnection servConn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.i((String)TAG, (String)"onServiceConnected");
            BtLeDeviceConnection.this.devServ = IDevServ.Stub.asInterface(service);
            BtLeDeviceConnection.dispatchAndClear(BtLeDeviceConnection.this.runOnServiceConnected);
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.i((String)TAG, (String)"onServiceDisconnected");
            BtLeDeviceConnection.this.devServ = null;
            BtLeDeviceConnection.this.cancelations.cancelAll(new ServiceDisconnectedException());
        }
    };
    final Observable<IDevServ> serviceObservable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<IDevServ>(){

        public void call(final Subscriber<? super IDevServ> subscriber) {
            Log.i((String)TAG, (String)"serviceObservable subscribed.");
            BtLeDeviceConnection.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (subscriber.isUnsubscribed()) {
                        return;
                    }
                    if (BtLeDeviceConnection.this.devServ != null) {
                        subscriber.onNext((Object)BtLeDeviceConnection.this.devServ);
                        subscriber.onCompleted();
                        return;
                    }
                    Runnable runWithService = new Runnable(){

                        @Override
                        public void run() {
                            if (subscriber.isUnsubscribed()) {
                                return;
                            }
                            if (BtLeDeviceConnection.this.devServ != null) {
                                subscriber.onNext((Object)BtLeDeviceConnection.this.devServ);
                                subscriber.onCompleted();
                            } else {
                                subscriber.onError((Throwable)new Exception("service was unbound."));
                            }
                        }
                    };
                    BtLeDeviceConnection.this.runOnServiceConnected.add(runWithService);
                    if (BtLeDeviceConnection.this.isServiceBound) {
                        return;
                    }
                    Throwable t = BtLeDeviceConnection.this.tryBind();
                    if (t != null) {
                        subscriber.onError(t);
                    }
                }
            });
        }
    });

    public BtLeDeviceConnection(@NonNull Context context, @NonNull String chipId, String deviceName, String deviceIcon, @NonNull String deviceId) {
        this.chipId = chipId;
        this.deviceName = deviceName;
        this.deviceIcon = deviceIcon;
        this.deviceId = deviceId;
        this.updateContext(context);
    }

    private Context context() {
        return (Context)this.contextRef.get();
    }

    void updateContext(@NonNull Context context) {
        this.contextRef = new WeakReference<Context>(context.getApplicationContext());
    }

    @Override
    public String chipId() {
        return this.chipId;
    }

    @Override
    public String deviceName() {
        return this.deviceName;
    }

    @Override
    public String deviceIcon() {
        return this.deviceIcon;
    }

    @Override
    @NonNull
    public String deviceId() {
        return this.deviceId;
    }

    @Override
    @NonNull
    public Observable<Void> resetDtcs() {
        return this.doOp("resetDtcs", null, new DeviceServiceFuncResetDtcs(this.chipId));
    }

    @Override
    @NonNull
    public <T> Observable<T> observe(@NonNull Param<T> param) {
        String name = Params.nameFor(param);
        if (name == null) {
            return Observable.error((Throwable)new RuntimeException("unrecognized param"));
        }
        return this.doOp(param, name, param.getServiceFunc(this.chipId, name));
    }

    @Override
    @NonNull
    public Observable<SupportedPids> supportedPids() {
        return this.observe(Params.PIDS).map((Func1)new Func1<String, SupportedPids>(){

            public SupportedPids call(String rawPids) {
                Log.i((String)TAG, (String)("got raw supported pids '" + rawPids + "'"));
                return new SupportedPids(rawPids);
            }
        });
    }

    private <T> Observable<T> doOp(final Object opKey, final String opLabel, final DeviceServiceFunc<T> func) {
        return this.getOrCreateOp(opKey, new ObservableFactory<T>(){

            @Override
            public Observable<T> create() {
                Log.d((String)TAG, (String)("creating param observable for " + (opLabel == null ? opKey : opLabel)));
                return OperatorReplayFix.create(BtLeDeviceConnection.this.serviceObservable.flatMap(func.setCancelations(BtLeDeviceConnection.this.cancelations)).retry(BtLeDeviceConnection.this.retryOnDisconnect).doOnUnsubscribe(func.cancelOpAction).onBackpressureLatest().doOnSubscribe(new Action0(){

                    public void call() {
                        BtLeDeviceConnection.this.putOp(opKey);
                    }
                }).doOnUnsubscribe(new Action0(){

                    public void call() {
                        Log.d((String)TAG, (String)("all unsubscribed from " + (opLabel == null ? opKey : opLabel)));
                        BtLeDeviceConnection.this.removeOp(opKey);
                    }
                }), 1).refCount();
            }
        });
    }

    public void shutdown() {
        this.isServiceBound = false;
        this.handler.removeCallbacks(this.shutdown);
        this.handler.post(this.shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Observable<T> getOrCreateOp(Object opKey, ObservableFactory<T> factory) {
        Object result;
        Map<Object, Observable<?>> map = this.paramObservables;
        synchronized (map) {
            Observable<?> prev = this.paramObservables.get(opKey);
            if (prev == null) {
                result = factory.create();
                this.paramObservables.put(opKey, (Observable<?>)result);
            } else {
                result = prev;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putOp(Object op) {
        Set<Object> set = this.ops;
        synchronized (set) {
            this.ops.add(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOp(Object op) {
        boolean emptied;
        Set<Object> set = this.ops;
        synchronized (set) {
            this.ops.remove(op);
            emptied = this.ops.isEmpty();
        }
        if (emptied) {
            this.shutdown();
        }
    }

    private static void dispatchAndClear(Set<Runnable> runnables) {
        HashSet<Runnable> copy = new HashSet<Runnable>(runnables);
        runnables.clear();
        for (Runnable r : copy) {
            r.run();
        }
    }

    @Nullable
    private Throwable tryBind() {
        try {
            Context context = this.context();
            if (context == null) {
                throw new Exception("no Context available.");
            }
            Intent i = new Intent();
            i.setClassName(context.getString(R.string.my_vinli_package_name), context.getString(R.string.device_service_component_name));
            if (!context.bindService(i, this.servConn, 1)) {
                throw new Exception("bindService call returned false.");
            }
            Log.d((String)TAG, (String)"Vinli device service successfully bound.");
            this.isServiceBound = true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Vinli device service bind error: " + e));
            return e;
        }
        return null;
    }

    private final class ServiceDisconnectedException
    extends Exception {
        private ServiceDisconnectedException() {
        }
    }

    private static interface ObservableFactory<T> {
        public Observable<T> create();
    }
}

