/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.deviceservice;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import li.vin.my.deviceservice.BtLeDeviceConnection;
import li.vin.my.deviceservice.DeviceConnection;
import li.vin.my.deviceservice.R;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.internal.operators.OperatorReplayFix;
import rx.subjects.BehaviorSubject;
import rx.subjects.PublishSubject;

public final class VinliDevices {
    private static final String TAG = VinliDevices.class.getSimpleName();
    private static final String SHARED_PREFS_NAME = TAG + ".sharedprefs";
    private static final String CHIP_ID_KEY = TAG + ".chipid";
    private static final String DEV_NAME_KEY = TAG + ".devicename";
    private static final String DEV_IC_KEY = TAG + ".deviceicon";
    private static final String DEV_ID_KEY = TAG + ".deviceid";
    private static Map<String, BtLeDeviceConnection> deviceConns = new HashMap<String, BtLeDeviceConnection>();
    private static volatile TargetCache _targetCache;
    private static final BehaviorSubject<ConnectAttempt> mainInit;
    private static final PublishSubject<ConnectAttempt> btResult;
    private static final PublishSubject<ConnectAttempt> connectResult;
    private static final Func1<ConnectAttempt, Observable<ConnectAttempt>> mainBt;
    private static final Func1<ConnectAttempt, Observable<DeviceConnection>> mainConnect;
    private static final Observable<DeviceConnection> mainBtAndConnect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TargetCache targetCache() {
        TargetCache result = _targetCache;
        if (result != null) return result;
        Class<VinliDevices> clazz = VinliDevices.class;
        synchronized (VinliDevices.class) {
            result = _targetCache;
            if (result != null) return result;
            _targetCache = result = new SharedPrefsTargetCache();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BtLeDeviceConnection makeOrUpdateConnection(Context context, String chipId, String name, String icon, String id) {
        String key = chipId.length() >= 4 ? chipId.substring(chipId.length() - 4, chipId.length()) : chipId;
        Class<VinliDevices> clazz = VinliDevices.class;
        synchronized (VinliDevices.class) {
            BtLeDeviceConnection result = deviceConns.get(key);
            if (result == null) {
                result = new BtLeDeviceConnection(context, chipId, name, icon, id);
                deviceConns.put(key, result);
            } else if (!VinliDevices.chipIdsMatch(result.chipId, chipId)) {
                result.shutdown();
                result = new BtLeDeviceConnection(context, chipId, name, icon, id);
                deviceConns.put(key, result);
            } else {
                result.updateContext(context);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return result;
        }
    }

    static boolean chipIdsMatch(String chipId1, String chipId2) {
        if (chipId1 == null || chipId2 == null) {
            return false;
        }
        if (chipId1.length() > chipId2.length()) {
            return chipId1.endsWith(chipId2);
        }
        return chipId2.endsWith(chipId1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void useFlatFileCache() {
        TargetCache result = _targetCache;
        if (result != null) return;
        Class<VinliDevices> clazz = VinliDevices.class;
        synchronized (VinliDevices.class) {
            result = _targetCache;
            if (result != null) {
                throw new RuntimeException("useFlatFileCache must be called only once, before any other calls.");
            }
            _targetCache = new FlatFileTargetCache();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean hasCachedValidConnection(@NonNull Context context) {
        TargetCache cache = VinliDevices.targetCache();
        cache.beginBatch(context);
        String chipId = cache.getChipId();
        String devId = cache.getDevId();
        cache.endBatch(context);
        return chipId != null && TextUtils.getTrimmedLength((CharSequence)chipId) != 0 && devId != null && TextUtils.getTrimmedLength((CharSequence)devId) != 0;
    }

    public static boolean intentIsRelevant(@NonNull Context context, Intent intent) {
        TargetCache cache = VinliDevices.targetCache();
        cache.beginBatch(context);
        String chipId = cache.getChipId();
        cache.endBatch(context);
        return intent != null && VinliDevices.chipIdsMatch(intent.getStringExtra("li.vin.my.chip_id"), chipId);
    }

    @NonNull
    public static Observable<DeviceConnection> connect(@NonNull Context context, @NonNull String clientId, @NonNull String redirectUri) {
        return VinliDevices.connect(context, clientId, redirectUri, false, true);
    }

    @NonNull
    public static Observable<DeviceConnection> connect(@NonNull Context context, @NonNull String clientId, @NonNull String redirectUri, boolean forceFreshDevice) {
        return VinliDevices.connect(context, clientId, redirectUri, forceFreshDevice, true);
    }

    @NonNull
    public static Observable<DeviceConnection> connect(@NonNull Context context, @NonNull String clientId, @NonNull String redirectUri, boolean forceFreshDevice, boolean autoEnableBt) {
        if (!VinliDevices.isMyVinliInstalledAndUpdated(context)) {
            return Observable.error((Throwable)new Exception("My Vinli is not installed - use isMyVinliInstalledAndUpdated and launchMarketToMyVinli to handle this error."));
        }
        ConnectAttempt connectAttempt = new ConnectAttempt.Builder().context(context).clientId(clientId).redirectUri(redirectUri).autoEnableBt(autoEnableBt).build();
        if (forceFreshDevice) {
            connectAttempt.clearCache();
        }
        btResult.onNext((Object)connectAttempt);
        connectResult.onNext((Object)connectAttempt);
        mainInit.onNext((Object)connectAttempt);
        return mainBtAndConnect;
    }

    private static boolean checkBtAttempt(ConnectAttempt connAttempt, Subscriber<? super ConnectAttempt> subscriber, boolean errorIfNone) {
        if (subscriber.isUnsubscribed()) {
            return true;
        }
        Context context = connAttempt.context();
        if (context != null && VinliDevices.isBluetoothEnabled(context)) {
            subscriber.onNext((Object)connAttempt);
            subscriber.onCompleted();
            return true;
        }
        if (errorIfNone) {
            subscriber.onError((Throwable)new RuntimeException("enable bt failed."));
        }
        return false;
    }

    private static boolean checkConnectAttempt(ConnectAttempt connAttempt, Subscriber<? super DeviceConnection> subscriber, boolean errorIfNone) {
        if (subscriber.isUnsubscribed()) {
            Log.i((String)TAG, (String)"checkConnectAttempt returning on unsubscriber subscriber.");
            return true;
        }
        Context context = connAttempt.context();
        if (context != null && connAttempt.chipId != null && TextUtils.getTrimmedLength((CharSequence)connAttempt.chipId) != 0 && connAttempt.devId != null && TextUtils.getTrimmedLength((CharSequence)connAttempt.devId) != 0) {
            subscriber.onNext((Object)VinliDevices.makeOrUpdateConnection(context, connAttempt.chipId, connAttempt.devName, connAttempt.devIcon, connAttempt.devId));
            subscriber.onCompleted();
            Log.i((String)TAG, (String)"checkConnectAttempt returning success.");
            return true;
        }
        if (errorIfNone) {
            Log.i((String)TAG, (String)"checkConnectAttempt returning definite error.");
            subscriber.onError((Throwable)new RuntimeException("connection failed."));
        } else {
            Log.i((String)TAG, (String)"checkConnectAttempt returning default error.");
        }
        return false;
    }

    public static boolean isMyVinliInstalledAndUpdated(Context context) {
        int versionCode;
        PackageManager pm = context.getPackageManager();
        String pkgName = context.getResources().getBoolean(R.bool.test_fake_install_flow) ? context.getString(R.string.test_fake_install_flow_package) : context.getString(R.string.my_vinli_package_name);
        try {
            pm.getPackageInfo(pkgName, 1);
            PackageInfo packageInfo = pm.getPackageInfo(pkgName, 0);
            versionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return versionCode >= context.getResources().getInteger(R.integer.min_supported_myvinli_ver);
    }

    public static void launchMarketToMyVinli(@NonNull Context context) {
        String pkgName = context.getResources().getBoolean(R.bool.test_fake_install_flow) ? context.getString(R.string.test_fake_install_flow_package) : context.getString(R.string.my_vinli_package_name);
        try {
            context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + pkgName))));
        }
        catch (Exception e1) {
            try {
                context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + pkgName))));
            }
            catch (Exception e2) {
                Toast.makeText((Context)context, (CharSequence)"Could not launch market to My Vinli app.", (int)0).show();
            }
        }
    }

    @NonNull
    public static AlertDialog createMyVinliInstallRequestDialog(@NonNull Context context) {
        final WeakReference<Context> ctx = new WeakReference<Context>(context);
        return new AlertDialog.Builder(context).setTitle((CharSequence)"Get My Vinli").setMessage((CharSequence)"My Vinli must be installed and fully updated for this app to function properly. Install or update now?").setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Context context = (Context)ctx.get();
                if (context != null) {
                    VinliDevices.launchMarketToMyVinli(context);
                }
            }
        }).setNegativeButton(17039369, null).create();
    }

    private static boolean isBluetoothChangingState(@NonNull Context context) {
        try {
            BluetoothManager mgr = (BluetoothManager)context.getSystemService("bluetooth");
            if (mgr == null) {
                Log.e((String)TAG, (String)"isBluetoothEnabled found null BluetoothManager.");
                return false;
            }
            BluetoothAdapter adapter = mgr.getAdapter();
            if (adapter == null) {
                Log.e((String)TAG, (String)"isBluetoothEnabled found null BluetoothAdapter.");
                return false;
            }
            return adapter.getState() == 13 || adapter.getState() == 11;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"isBluetoothEnabled error", (Throwable)e);
            return false;
        }
    }

    private static boolean isBluetoothEnabled(@NonNull Context context) {
        try {
            BluetoothManager mgr = (BluetoothManager)context.getSystemService("bluetooth");
            if (mgr == null) {
                Log.e((String)TAG, (String)"isBluetoothEnabled found null BluetoothManager.");
                return false;
            }
            BluetoothAdapter adapter = mgr.getAdapter();
            if (adapter == null) {
                Log.e((String)TAG, (String)"isBluetoothEnabled found null BluetoothAdapter.");
                return false;
            }
            return adapter.isEnabled() || adapter.getState() == 12 || adapter.getState() == 11;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"isBluetoothEnabled error", (Throwable)e);
            return false;
        }
    }

    private VinliDevices() {
    }

    static {
        mainInit = BehaviorSubject.create();
        btResult = PublishSubject.create();
        connectResult = PublishSubject.create();
        mainBt = new Func1<ConnectAttempt, Observable<ConnectAttempt>>(){

            public Observable<ConnectAttempt> call(final ConnectAttempt connAttempt) {
                Context context = connAttempt.context();
                if (context == null) {
                    return Observable.error((Throwable)new RuntimeException("no context."));
                }
                if (VinliDevices.isBluetoothEnabled(context)) {
                    return Observable.just((Object)connAttempt);
                }
                final AtomicInteger threshold = new AtomicInteger(30);
                final AtomicInteger attempts = new AtomicInteger();
                final Handler handler = new Handler(Looper.getMainLooper());
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ConnectAttempt>(){

                    public void call(final Subscriber<? super ConnectAttempt> subscriber) {
                        if (subscriber.isUnsubscribed()) {
                            return;
                        }
                        Context ctx = connAttempt.context();
                        if (ctx == null) {
                            subscriber.onError((Throwable)new RuntimeException("no context."));
                            return;
                        }
                        if (VinliDevices.checkBtAttempt(connAttempt, (Subscriber<? super ConnectAttempt>)subscriber, false)) {
                            return;
                        }
                        if (VinliDevices.isBluetoothChangingState(ctx)) {
                            threshold.set(60);
                        }
                        if (attempts.getAndIncrement() < threshold.get()) {
                            final 1 onSub = this;
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    onSub.call((Object)subscriber);
                                }
                            }, 50L);
                            return;
                        }
                        if (!connAttempt.autoEnableBt) {
                            VinliDevices.checkBtAttempt(connAttempt, (Subscriber<? super ConnectAttempt>)subscriber, true);
                            return;
                        }
                        final Context appContext = ctx.getApplicationContext();
                        final BroadcastReceiver recv = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                btResult.onNext((Object)connAttempt);
                            }
                        };
                        btResult.subscribe((Subscriber)new Subscriber<ConnectAttempt>(){

                            public void onCompleted() {
                                if (!this.isUnsubscribed()) {
                                    this.unsubscribe();
                                }
                            }

                            public void onError(Throwable e) {
                                if (!this.isUnsubscribed()) {
                                    this.unsubscribe();
                                }
                            }

                            public void onNext(ConnectAttempt connectAttempt) {
                                if (!this.isUnsubscribed()) {
                                    this.unsubscribe();
                                }
                                try {
                                    appContext.unregisterReceiver(recv);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                VinliDevices.checkBtAttempt(connectAttempt, (Subscriber<? super ConnectAttempt>)subscriber, true);
                            }
                        });
                        try {
                            appContext.registerReceiver(recv, new IntentFilter("li.vin.action.BLUETOOTH_ENABLED"));
                            Intent i = new Intent();
                            i.setClassName("li.vin.my", "li.vin.my.EnableBluetoothActivity");
                            i.setFlags(0x4000000);
                            connAttempt.activity().startActivity(i);
                            Log.i((String)TAG, (String)"startActivity EnableBluetoothActivity success");
                        }
                        catch (Exception e) {
                            Log.i((String)TAG, (String)"startActivity EnableBluetoothActivity failed", (Throwable)e);
                            btResult.onNext((Object)connAttempt);
                        }
                    }
                }).delaySubscription(100L, TimeUnit.MILLISECONDS);
            }
        };
        mainConnect = new Func1<ConnectAttempt, Observable<DeviceConnection>>(){

            public Observable<DeviceConnection> call(ConnectAttempt ca) {
                Context context = ca.context();
                if (context == null) {
                    return Observable.error((Throwable)new RuntimeException("no context."));
                }
                final ConnectAttempt connAttempt = ca.fromCache();
                if (connAttempt.chipId != null && TextUtils.getTrimmedLength((CharSequence)connAttempt.chipId) != 0 && connAttempt.devId != null && TextUtils.getTrimmedLength((CharSequence)connAttempt.devId) != 0) {
                    return Observable.just((Object)VinliDevices.makeOrUpdateConnection(context, connAttempt.chipId, connAttempt.devName, connAttempt.devIcon, connAttempt.devId));
                }
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<DeviceConnection>(){

                    public void call(final Subscriber<? super DeviceConnection> subscriber) {
                        if (VinliDevices.checkConnectAttempt(connAttempt, (Subscriber<? super DeviceConnection>)subscriber, false)) {
                            return;
                        }
                        Context ctx = connAttempt.context();
                        if (ctx == null) {
                            subscriber.onError((Throwable)new RuntimeException("no context."));
                            return;
                        }
                        final Context appContext = ctx.getApplicationContext();
                        final BroadcastReceiver recv = new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                try {
                                    connectResult.onNext((Object)connAttempt.fromIntent(intent).toCache());
                                }
                                catch (Exception e) {
                                    Log.e((String)TAG, (String)"connectResult onReceive error", (Throwable)e);
                                    connectResult.onNext((Object)connAttempt);
                                }
                            }
                        };
                        connectResult.subscribe((Subscriber)new Subscriber<ConnectAttempt>(){

                            public void onCompleted() {
                                if (!this.isUnsubscribed()) {
                                    this.unsubscribe();
                                }
                            }

                            public void onError(Throwable e) {
                                if (!this.isUnsubscribed()) {
                                    this.unsubscribe();
                                }
                            }

                            public void onNext(ConnectAttempt connectAttempt) {
                                if (!this.isUnsubscribed()) {
                                    this.unsubscribe();
                                }
                                try {
                                    appContext.unregisterReceiver(recv);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                VinliDevices.checkConnectAttempt(connectAttempt, (Subscriber<? super DeviceConnection>)subscriber, true);
                            }
                        });
                        try {
                            appContext.registerReceiver(recv, new IntentFilter("li.vin.action.DEVICE_CHOSEN"));
                            Intent i = new Intent();
                            connAttempt.toIntent(i);
                            i.putExtra("li.vin.my.choose_device", true);
                            i.setClassName("li.vin.my", "li.vin.my.OAuthActivity");
                            i.setFlags(0x4000000);
                            connAttempt.activity().startActivity(i);
                            Log.i((String)TAG, (String)"startActivity OAuthActivity success");
                        }
                        catch (Exception e) {
                            Log.i((String)TAG, (String)"startActivity OAuthActivity failed", (Throwable)e);
                            connectResult.onNext((Object)connAttempt);
                        }
                    }
                }).delaySubscription(100L, TimeUnit.MILLISECONDS);
            }
        };
        mainBtAndConnect = OperatorReplayFix.create(mainInit.flatMap(mainBt).flatMap(mainConnect), 1).refCount().take(1);
    }

    private static class FlatFileTargetCache
    implements TargetCache {
        private Context context;

        private FlatFileTargetCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getVal(String key) {
            File f = new File(this.context.getFilesDir(), SHARED_PREFS_NAME + "." + key);
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                String string2 = new BufferedReader(new InputStreamReader(is)).readLine().trim();
                return string2;
            }
            catch (Exception exception) {
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putVal(String key, String val) {
            File f = new File(this.context.getFilesDir(), SHARED_PREFS_NAME + "." + key);
            f.delete();
            if (val == null) {
                return;
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(f);
                ((OutputStream)os).write(val.getBytes(Charset.forName("UTF-8")));
            }
            catch (Exception exception) {
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public void beginBatch(@NonNull Context context) {
            if (this.context != null) {
                throw new IllegalStateException("endBatch never called.");
            }
            this.context = context.getApplicationContext();
        }

        @Override
        public void endBatch(@NonNull Context context) {
            if (this.context == null) {
                throw new IllegalStateException("beginBatch never called.");
            }
            this.context = null;
        }

        @Override
        public String getChipId() {
            return this.getVal("chipId");
        }

        @Override
        public String getDevName() {
            return this.getVal("devName");
        }

        @Override
        public String getDevIcon() {
            return this.getVal("devIcon");
        }

        @Override
        public String getDevId() {
            return this.getVal("devId");
        }

        @Override
        public void putChipId(String chipId) {
            this.putVal("chipId", chipId);
        }

        @Override
        public void putDevName(String devName) {
            this.putVal("devName", devName);
        }

        @Override
        public void putDevIcon(String devIcon) {
            this.putVal("devIcon", devIcon);
        }

        @Override
        public void putDevId(String devId) {
            this.putVal("devId", devId);
        }

        @Override
        public void clear() {
            this.putChipId(null);
            this.putDevName(null);
            this.putDevIcon(null);
            this.putDevId(null);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static class SharedPrefsTargetCache
    implements TargetCache {
        private SharedPreferences prefs;
        private SharedPreferences.Editor edit;

        private SharedPrefsTargetCache() {
        }

        @Override
        public void beginBatch(@NonNull Context context) {
            if (this.prefs != null) {
                throw new IllegalStateException("endBatch never called.");
            }
            this.prefs = context.getApplicationContext().getSharedPreferences(SHARED_PREFS_NAME, 0);
        }

        @Override
        public void endBatch(@NonNull Context context) {
            if (this.prefs == null) {
                throw new IllegalStateException("beginBatch never called.");
            }
            this.prefs = null;
            if (this.edit != null) {
                this.edit.apply();
                this.edit = null;
            }
        }

        @Override
        public String getChipId() {
            return this.prefs.getString(CHIP_ID_KEY, null);
        }

        @Override
        public String getDevName() {
            return this.prefs.getString(DEV_NAME_KEY, null);
        }

        @Override
        public String getDevIcon() {
            return this.prefs.getString(DEV_IC_KEY, null);
        }

        @Override
        public String getDevId() {
            return this.prefs.getString(DEV_ID_KEY, null);
        }

        @Override
        public void putChipId(String chipId) {
            if (this.edit == null) {
                this.edit = this.prefs.edit();
            }
            this.edit.putString(CHIP_ID_KEY, chipId);
        }

        @Override
        public void putDevName(String devName) {
            if (this.edit == null) {
                this.edit = this.prefs.edit();
            }
            this.edit.putString(DEV_NAME_KEY, devName);
        }

        @Override
        public void putDevIcon(String devIcon) {
            if (this.edit == null) {
                this.edit = this.prefs.edit();
            }
            this.edit.putString(DEV_IC_KEY, devIcon);
        }

        @Override
        public void putDevId(String devId) {
            if (this.edit == null) {
                this.edit = this.prefs.edit();
            }
            this.edit.putString(DEV_ID_KEY, devId);
        }

        @Override
        public void clear() {
            if (this.edit == null) {
                this.edit = this.prefs.edit();
            }
            this.edit.clear();
        }
    }

    private static interface TargetCache {
        public void beginBatch(@NonNull Context var1);

        public void endBatch(@NonNull Context var1);

        public String getChipId();

        public String getDevName();

        public String getDevIcon();

        public String getDevId();

        public void putChipId(String var1);

        public void putDevName(String var1);

        public void putDevIcon(String var1);

        public void putDevId(String var1);

        public void clear();
    }

    static class ConnectAttempt {
        private final WeakReference<Context> contextRef;
        @NonNull
        final String clientId;
        @NonNull
        final String redirectUri;
        private final String chipId;
        private final String devName;
        private final String devIcon;
        private final String devId;
        private boolean autoEnableBt;

        @NonNull
        Activity activity() {
            Context context = (Context)this.contextRef.get();
            if (!(context instanceof Activity)) {
                throw new ClassCastException("not an activity.");
            }
            return (Activity)context;
        }

        private ConnectAttempt(@NonNull Context context, @NonNull String clientId, @NonNull String redirectUri, String chipId, String devName, String devIcon, String devId, boolean autoEnableBt) {
            this.contextRef = new WeakReference<Context>(context);
            this.clientId = clientId;
            this.redirectUri = redirectUri;
            this.chipId = chipId;
            this.devName = devName;
            this.devIcon = devIcon;
            this.devId = devId;
            this.autoEnableBt = autoEnableBt;
        }

        Builder builder() {
            return new Builder().context((Context)this.contextRef.get()).clientId(this.clientId).redirectUri(this.redirectUri).chipId(this.chipId).devName(this.devName).devIcon(this.devIcon).devId(this.devId);
        }

        @Nullable
        private Context context() {
            return (Context)this.contextRef.get();
        }

        private ConnectAttempt toIntent(@NonNull Intent i) {
            i.putExtra("li.vin.my.client_id", this.clientId);
            i.putExtra("li.vin.my.redirect_uri", this.redirectUri);
            return this;
        }

        private ConnectAttempt fromIntent(Intent i) {
            Context context = this.context();
            if (context == null) {
                throw new NullPointerException("no context.");
            }
            String chipId = i == null ? null : i.getStringExtra("li.vin.my.chip_id");
            String devName = i == null ? null : i.getStringExtra("li.vin.my.device_name");
            String devIcon = i == null ? null : i.getStringExtra("li.vin.my.device_icon");
            String devId = i == null ? null : i.getStringExtra("li.vin.my.device_id");
            return this.builder().chipId(chipId).devName(devName).devIcon(devIcon).devId(devId).build();
        }

        private ConnectAttempt fromCache() {
            Context context = this.context();
            if (context == null) {
                throw new NullPointerException("no context.");
            }
            TargetCache cache = VinliDevices.targetCache();
            cache.beginBatch(context);
            String chipId = cache.getChipId();
            String devName = cache.getDevName();
            String devIcon = cache.getDevIcon();
            String devId = cache.getDevId();
            cache.endBatch(context);
            return this.builder().chipId(chipId).devName(devName).devIcon(devIcon).devId(devId).build();
        }

        private ConnectAttempt toCache() {
            Context context = this.context();
            if (context == null) {
                throw new NullPointerException("no context.");
            }
            if (this.chipId != null && TextUtils.getTrimmedLength((CharSequence)this.chipId) != 0 && this.devId != null && TextUtils.getTrimmedLength((CharSequence)this.devId) != 0) {
                TargetCache cache = VinliDevices.targetCache();
                cache.beginBatch(context);
                cache.putChipId(this.chipId);
                cache.putDevName(this.devName);
                cache.putDevIcon(this.devIcon);
                cache.putDevId(this.devId);
                cache.endBatch(context);
            }
            return this;
        }

        private ConnectAttempt clearCache() {
            Context context = this.context();
            if (context == null) {
                throw new NullPointerException("no context.");
            }
            TargetCache cache = VinliDevices.targetCache();
            cache.beginBatch(context);
            cache.clear();
            cache.endBatch(context);
            return this;
        }

        static class Builder {
            private WeakReference<Context> contextRef;
            private String clientId;
            private String redirectUri;
            private String chipId;
            private String devName;
            private String devIcon;
            private String devId;
            private boolean autoEnableBt;

            Builder() {
            }

            private Builder context(Context context) {
                this.contextRef = new WeakReference<Context>(context);
                return this;
            }

            private Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            private Builder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            Builder chipId(String chipId) {
                this.chipId = chipId;
                return this;
            }

            Builder devName(String devName) {
                this.devName = devName;
                return this;
            }

            Builder devIcon(String devIcon) {
                this.devIcon = devIcon;
                return this;
            }

            Builder devId(String devId) {
                this.devId = devId;
                return this;
            }

            Builder autoEnableBt(boolean autoEnableBt) {
                this.autoEnableBt = autoEnableBt;
                return this;
            }

            ConnectAttempt build() {
                Context context;
                if (this.contextRef == null || (context = (Context)this.contextRef.get()) == null) {
                    throw new NullPointerException("need context.");
                }
                if (this.clientId == null) {
                    throw new NullPointerException("need client id.");
                }
                if (this.redirectUri == null) {
                    throw new NullPointerException("need redirect uri.");
                }
                return new ConnectAttempt(context, this.clientId, this.redirectUri, this.chipId, this.devName, this.devIcon, this.devId, this.autoEnableBt);
            }
        }
    }
}

