/*
 * Decompiled with CFR 0.152.
 */
package li.vin.my.deviceservice;

import android.bluetooth.BluetoothGattCharacteristic;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.UUID;
import li.vin.my.deviceservice.ParamImpl;
import li.vin.my.deviceservice.Uuids;

abstract class ParamStream<T>
extends ParamImpl<T, String> {
    protected static final int HEX = 16;
    private final String mCode;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public ParamStream(String code) {
        this(code, Uuids.STREAM);
    }

    public ParamStream(String code, UUID uuid) {
        this(code, uuid, false);
    }

    public ParamStream(String code, UUID uuid, boolean shouldRead) {
        super(uuid, true, shouldRead);
        this.mCode = code;
    }

    @Override
    public String parseCharacteristic(BluetoothGattCharacteristic characteristic) {
        int len;
        int end;
        int stt;
        byte[] val = characteristic.getValue();
        if (val == null) {
            throw new RuntimeException("val == null");
        }
        if (val.length == 0) {
            throw new RuntimeException("val empty.");
        }
        Log.d((String)("parseCharacteristic (" + characteristic.getUuid() + ")"), (String)(ParamStream.bytesToHex(val) + " : " + new String(val, 0, val.length, ASCII)));
        for (stt = 0; stt < val.length && (Character.isWhitespace(val[stt]) || val[stt] == 0); ++stt) {
        }
        for (end = val.length - 1; end >= 0 && (Character.isWhitespace(val[end]) || val[end] == 0); --end) {
        }
        if ((len = ++end - stt) < 2) {
            throw new RuntimeException("trimmed len < 2.");
        }
        if (val[stt] == 52 && val[stt + 1] == 49) {
            if (end > stt + 2) {
                return new String(val, stt + 2, end - (stt + 2), ASCII);
            }
            throw new RuntimeException("empty streaming characteristic " + characteristic.getUuid());
        }
        if (len >= 5 && val[stt] == 83 && val[stt + 1] == 86 && val[stt + 2] == 69 && val[stt + 3] == 82 && val[stt + 4] == 58) {
            if (end > stt + 5) {
                return "SVER:" + new String(val, stt + 5, end - (stt + 5), ASCII);
            }
            throw new RuntimeException("empty streaming characteristic " + characteristic.getUuid());
        }
        if (val[stt] == 66 && val[stt + 1] == 58) {
            if (end > stt + 2) {
                return "B:" + new String(val, stt + 2, end - (stt + 2), ASCII);
            }
            throw new RuntimeException("empty streaming characteristic " + characteristic.getUuid());
        }
        if (val[stt] == 83 && val[stt + 1] == 58) {
            if (end > stt + 2) {
                return "S:" + new String(val, stt + 2, end - (stt + 2), ASCII);
            }
            throw new RuntimeException("empty streaming characteristic " + characteristic.getUuid());
        }
        if (val[stt] == 80 && val[stt + 1] == 48) {
            return "P0";
        }
        if (val[stt] == 80 && val[stt + 1] == 49) {
            return "P1";
        }
        if (val[stt] == 67 && val[stt + 1] == 48) {
            return "C0";
        }
        if (val[stt] == 67 && val[stt + 1] == 49) {
            return "C1";
        }
        if (val[stt] == 71 && val[stt + 1] == 48) {
            return "G0";
        }
        if (val[stt] == 71 && val[stt + 1] == 49) {
            return "G1";
        }
        throw new RuntimeException("unknown streaming characteristic(" + new String(val, stt, end - stt, ASCII) + ") " + characteristic.getUuid());
    }

    @Override
    public Boolean matches(String val) {
        return val.startsWith(this.mCode) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    @Nullable
    public String getCode() {
        return this.mCode;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

