/*
 * Decompiled with CFR 0.152.
 */
package frameblock.vision.camera;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import frameblock.vision.camera.GraphicOverlay;
import frameblock.vision.camera.R;

public class FinderGraphicOverlay<T extends GraphicOverlay.Graphic>
extends GraphicOverlay<T> {
    public static final int GRAVITY_TOP = 1;
    public static final int GRAVITY_LEFT = 2;
    public static final int GRAVITY_BOTTOM = 4;
    public static final int GRAVITY_RIGHT = 8;
    public static final int FINDER_SHAPE_RECTANGLE = 0;
    public static final int FINDER_SHAPE_CIRCLE = 1;
    private static final float DEFAULT_ASPECT_RATIO = 1.0f;
    private static final int DEFAULT_MARGIN_DP = 20;
    private static final int DEFAULT_GRAVITY = 15;
    private static final int DEFAULT_CORNER_RADIUS = 35;
    private float mAspectRatio = 1.0f;
    private int mMargin;
    private int mGravity;
    private int mFinderColor;
    private int mFinderMaskColor;
    private int mFinderCornerRadius;
    private Paint mDrawFinderPaint;
    private Paint mDrawMaskPaint;
    private Paint mDrawHolePaint;
    private int mFinderShape;
    private Rect mFinderRoi = new Rect();
    private Rect mScreenSize = new Rect();

    public FinderGraphicOverlay(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FinderGraphicOverlay);
        this.mMargin = a.getDimensionPixelSize(R.styleable.FinderGraphicOverlay_finder_margin, (int)((float)(20 * context.getResources().getDisplayMetrics().densityDpi) / 160.0f));
        this.mGravity = a.getInt(R.styleable.FinderGraphicOverlay_finder_gravity, 15);
        this.mFinderColor = a.getColor(R.styleable.FinderGraphicOverlay_finder_color, this.getResources().getColor(R.color.finder_color));
        this.mFinderMaskColor = a.getColor(R.styleable.FinderGraphicOverlay_finder_maskColor, -1);
        this.mFinderCornerRadius = a.getDimensionPixelSize(R.styleable.FinderGraphicOverlay_finder_cornerRadius, 35);
        this.mFinderShape = a.getInt(R.styleable.FinderGraphicOverlay_finder_shape, 0);
        String ratio = a.getString(R.styleable.FinderGraphicOverlay_finder_aspectRatio);
        if (ratio != null) {
            int colonIndex = ratio.indexOf(58);
            if (colonIndex >= 0 && colonIndex < ratio.length() - 1) {
                String nominator = ratio.substring(0, colonIndex);
                String denominator = ratio.substring(colonIndex + 1);
                try {
                    float nominatorValue = Float.parseFloat(nominator);
                    float denominatorValue = Float.parseFloat(denominator);
                    if (nominatorValue > 0.0f && denominatorValue > 0.0f) {
                        this.mAspectRatio = Math.abs(nominatorValue / denominatorValue);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (ratio.length() > 0) {
                try {
                    this.mAspectRatio = Float.parseFloat(ratio);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        a.recycle();
        this.mDrawFinderPaint = new Paint();
        this.mDrawFinderPaint.setColor(this.mFinderColor);
        this.mDrawFinderPaint.setStyle(Paint.Style.STROKE);
        this.mDrawFinderPaint.setStrokeWidth(5.0f);
        this.mDrawHolePaint = new Paint();
        this.mDrawHolePaint.setColor(this.getResources().getColor(17170445));
        this.mDrawHolePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        if (this.mFinderMaskColor != -1) {
            this.mDrawMaskPaint = new Paint(1);
            this.mDrawMaskPaint.setStyle(Paint.Style.FILL);
            this.mDrawMaskPaint.setColor(this.mFinderMaskColor);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.getLocalVisibleRect(this.mScreenSize);
        if (this.mScreenSize.width() < this.mScreenSize.height()) {
            this.mFinderRoi.left = this.mScreenSize.left + this.mMargin;
            this.mFinderRoi.right = this.mScreenSize.right - this.mMargin;
            this.mFinderRoi.top = this.mScreenSize.top + this.mMargin;
            this.mFinderRoi.bottom = this.mAspectRatio > 0.0f ? (int)((float)this.mFinderRoi.width() / this.mAspectRatio) + this.mFinderRoi.top : this.mScreenSize.bottom - this.mMargin;
            if (this.mGravity == 1) {
                this.mFinderRoi.offsetTo(this.mFinderRoi.left, this.mScreenSize.top + this.mMargin);
            } else if (this.mGravity == 4) {
                this.mFinderRoi.offsetTo(this.mFinderRoi.left, this.mScreenSize.bottom - this.mFinderRoi.height() - this.mMargin);
            } else {
                this.mFinderRoi.offsetTo(this.mFinderRoi.left, this.mScreenSize.centerY() - this.mFinderRoi.height() / 2);
            }
        } else {
            this.mFinderRoi.top = this.mScreenSize.top + this.mMargin;
            this.mFinderRoi.bottom = this.mScreenSize.bottom - this.mMargin;
            this.mFinderRoi.left = this.mScreenSize.left + this.mMargin;
            this.mFinderRoi.right = this.mAspectRatio > 0.0f ? (int)((float)this.mFinderRoi.height() * this.mAspectRatio) + this.mFinderRoi.left : this.mScreenSize.right - this.mMargin;
            if (this.mGravity == 2) {
                this.mFinderRoi.offsetTo(this.mScreenSize.left + this.mMargin, this.mFinderRoi.top);
            } else if (this.mGravity == 8) {
                this.mFinderRoi.offsetTo(this.mScreenSize.right - this.mFinderRoi.width() - this.mMargin, this.mFinderRoi.top);
            } else {
                this.mFinderRoi.offsetTo(this.mScreenSize.centerX() - this.mFinderRoi.width() / 2, this.mFinderRoi.top);
            }
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        RectF finder = new RectF(this.mFinderRoi);
        if (this.mDrawMaskPaint != null) {
            int width = canvas.getWidth();
            int height = canvas.getHeight();
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mDrawMaskPaint);
        }
        if (this.mFinderShape == 0) {
            canvas.drawRoundRect(finder, (float)this.mFinderCornerRadius, (float)this.mFinderCornerRadius, this.mDrawHolePaint);
            canvas.drawRoundRect(finder, (float)this.mFinderCornerRadius, (float)this.mFinderCornerRadius, this.mDrawFinderPaint);
        } else {
            float radius = finder.width() < finder.height() ? finder.width() / 2.0f : finder.height() / 2.0f;
            canvas.drawCircle(finder.centerX(), finder.centerY(), radius, this.mDrawHolePaint);
            canvas.drawCircle(finder.centerX(), finder.centerY(), radius, this.mDrawFinderPaint);
        }
        super.onDraw(canvas);
    }

    public Rect getScaledFinder() {
        float sw = this.getWidthScaleFactor();
        float sh = this.getHeightScaleFactor();
        return new Rect((int)((float)this.mFinderRoi.left / sw), (int)((float)this.mFinderRoi.top / sh), (int)((float)this.mFinderRoi.right / sw), (int)((float)this.mFinderRoi.bottom / sh));
    }

    public Rect getFinder() {
        return this.mFinderRoi;
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
    }

    public int getMargin() {
        return this.mMargin;
    }

    public void setMargin(int margin) {
        this.mMargin = margin;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public int getFinderColor() {
        return this.mFinderColor;
    }

    public void setFinderColor(int finderColor) {
        this.mFinderColor = finderColor;
        this.mDrawFinderPaint.setColor(this.mFinderColor);
    }

    public int getFinderMaskColor() {
        return this.mFinderMaskColor;
    }

    public void setFinderMaskColor(int finderMaskColor) {
        this.mFinderMaskColor = finderMaskColor;
        this.mDrawMaskPaint.setColor(this.mFinderMaskColor);
    }

    public int getFinderCornerRadius() {
        return this.mFinderCornerRadius;
    }

    public void setFinderCornerRadius(int finderCornerRadius) {
        this.mFinderCornerRadius = finderCornerRadius;
    }

    public int getFinderShape() {
        return this.mFinderShape;
    }

    public void setFinderShape(int finderShape) {
        this.mFinderShape = finderShape;
    }

    public void setDrawFinderPaint(Paint drawFinderPaint) {
        this.mDrawFinderPaint = drawFinderPaint;
    }

    public void setDrawMaskPaint(Paint drawMaskPaint) {
        this.mDrawMaskPaint = drawMaskPaint;
    }
}

