/*
 * Decompiled with CFR 0.152.
 */
package frameblock.vision.camera;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CameraResult
implements Parcelable {
    private Uri mJpegUri;
    private Uri mJpegUriCropped;
    private transient byte[] mJpegImage;
    private transient byte[] mJpegImageCropped;
    private Rect roi;
    public static final Parcelable.Creator<CameraResult> CREATOR = new Parcelable.Creator<CameraResult>(){

        public CameraResult createFromParcel(Parcel in) {
            return new CameraResult(in);
        }

        public CameraResult[] newArray(int size) {
            return new CameraResult[size];
        }
    };

    public CameraResult(Bitmap fullImage, Bitmap croppedImage) throws IOException {
        this.mJpegUri = this.createUriFromBitmap(fullImage);
        this.mJpegUriCropped = this.createUriFromBitmap(croppedImage);
    }

    protected CameraResult(Parcel in) {
        this.mJpegUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.mJpegUriCropped = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.roi = (Rect)in.readParcelable(Rect.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mJpegUri, flags);
        dest.writeParcelable((Parcelable)this.mJpegUriCropped, flags);
        dest.writeParcelable((Parcelable)this.roi, flags);
    }

    public int describeContents() {
        return 0;
    }

    private Uri createUriFromBitmap(Bitmap image) throws IOException {
        File outputFile = File.createTempFile("image", "jpeg");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
        out.flush();
        out.close();
        return Uri.fromFile((File)outputFile);
    }

    public byte[] getJpegImage() {
        if (this.mJpegImage == null) {
            this.mJpegImage = this.readBinaryFile(this.mJpegUri.getPath());
        }
        return this.mJpegImage;
    }

    public byte[] getJpegImageCropped() {
        if (this.mJpegImageCropped == null) {
            this.mJpegImageCropped = this.readBinaryFile(this.mJpegUriCropped.getPath());
        }
        return this.mJpegImageCropped;
    }

    private byte[] readBinaryFile(String path) {
        File file = new File(path);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        try {
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
            buf.read(bytes, 0, bytes.length);
            buf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }
}

