/*
 * Decompiled with CFR 0.152.
 */
package frameblock.vision.camera;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import frameblock.vision.camera.CameraResult;
import frameblock.vision.camera.CameraSource;
import frameblock.vision.camera.CameraSourcePreview;
import frameblock.vision.camera.FinderGraphicOverlay;
import frameblock.vision.camera.PreviewUtil;
import frameblock.vision.camera.R;
import java.io.IOException;

public class CameraActivity
extends AppCompatActivity {
    public static final String CAMERA_RESULT = "CAMERA_RESULT";
    public static final String CAMERA_FACING_FRONT = "user";
    public static final String CAMERA_FACING_BACK = "environment";
    public static final int FINDER_SHAPE_RECTANGLE = 0;
    public static final int FINDER_SHAPE_CIRCLE = 1;
    public static final String SETTING = "Setting";
    private Setting setting;
    private CameraSourcePreview mPreview;
    private FinderGraphicOverlay mGraphicOverlay;
    private CameraSource mCameraSource = null;
    private int mCameraFacing = 1;
    private ProgressBar mPbCapture;
    private TextView mTvWaiting;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera);
        this.initialize();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initialize() {
        ImageView btnSnapshot;
        ImageButton btnToggle;
        Bundle bundle = this.getIntent().getExtras();
        this.setting = (Setting)bundle.getParcelable(SETTING);
        if (this.setting == null) {
            this.setting = new Setting();
        }
        this.mCameraFacing = this.setting.cameraFacing.equals(CAMERA_FACING_FRONT) ? 1 : 0;
        this.mPreview = (CameraSourcePreview)this.findViewById(R.id.preview);
        this.mGraphicOverlay = (FinderGraphicOverlay)this.findViewById(R.id.graphicOverlay);
        this.mGraphicOverlay.setVisibility(this.setting.finderVisible ? 0 : 8);
        this.mGraphicOverlay.setFinderShape(this.setting.finderShape);
        this.mGraphicOverlay.setAspectRatio(this.setting.finderAspectRatio);
        this.mPbCapture = (ProgressBar)this.findViewById(R.id.pbCapture);
        this.mTvWaiting = (TextView)this.findViewById(R.id.tvWaiting);
        this.mTvWaiting.setText((CharSequence)this.setting.waitingMessage);
        TextView tvMessage = (TextView)this.findViewById(R.id.tvMessage);
        if (tvMessage != null) {
            tvMessage.setText((CharSequence)this.setting.message);
        }
        if ((btnToggle = (ImageButton)this.findViewById(R.id.btnToggle)) != null) {
            if (!this.setting.toggleButtonVisible) {
                btnToggle.setVisibility(8);
            }
            btnToggle.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CameraActivity.this.toggleCamera();
                }
            });
        }
        if ((btnSnapshot = (ImageView)this.findViewById(R.id.btnSnapshot)) != null) {
            if (!this.setting.snapshotButtonVisible) {
                btnSnapshot.setVisibility(8);
            }
            btnSnapshot.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            Animation pushDown = AnimationUtils.loadAnimation((Context)CameraActivity.this.getBaseContext(), (int)R.anim.push_down_rotate);
                            v.startAnimation(pushDown);
                            break;
                        }
                        case 1: {
                            Animation pushDown = AnimationUtils.loadAnimation((Context)CameraActivity.this.getBaseContext(), (int)R.anim.push_up_rotate);
                            v.startAnimation(pushDown);
                            break;
                        }
                    }
                    return false;
                }
            });
            btnSnapshot.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CameraActivity.this.takeSnapshot(CameraActivity.this.setting.forceAutoFocus);
                }
            });
        }
        this.startPreview();
    }

    public void takeSnapshot(boolean autofocus) {
        if (this.setting.showProgress) {
            if (this.mPbCapture != null) {
                this.mPbCapture.setVisibility(0);
            }
            if (this.mTvWaiting != null) {
                this.mTvWaiting.setVisibility(0);
            }
        }
        if (autofocus) {
            this.mCameraSource.autoFocus(new CameraSource.AutoFocusCallback(){

                @Override
                public void onAutoFocus(boolean success) {
                    System.out.println("onAutoFocus success: " + success);
                    CameraActivity.this.takeSnapshot();
                    CameraActivity.this.mCameraSource.cancelAutoFocus();
                }
            });
        } else {
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() {
        this.mCameraSource.takePicture(null, new CameraSource.PictureCallback(){

            @Override
            public void onPictureTaken(byte[] data) {
                Bitmap fullImage = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                float szFactor = (float)fullImage.getWidth() / (float)CameraActivity.this.mCameraSource.getPreviewSize().getWidth();
                Matrix m = new Matrix();
                Log.d((String)"ROTATION", (String)("" + CameraActivity.this.mCameraSource.getDisplayOrientation()));
                if (CameraActivity.this.mCameraSource.getCameraFacing() == 1) {
                    m.setRotate((float)(-CameraActivity.this.mCameraSource.getDisplayOrientation()));
                    m.postScale(-1.0f, 1.0f);
                } else {
                    m.setRotate((float)CameraActivity.this.mCameraSource.getDisplayOrientation());
                }
                fullImage = Bitmap.createBitmap((Bitmap)fullImage, (int)0, (int)0, (int)fullImage.getWidth(), (int)fullImage.getHeight(), (Matrix)m, (boolean)true);
                Rect roi = CameraActivity.this.mGraphicOverlay.getScaledFinder();
                Bitmap croppedImage = Bitmap.createBitmap((Bitmap)fullImage, (int)((int)((float)roi.left * szFactor)), (int)((int)((float)roi.top * szFactor)), (int)((int)((float)roi.width() * szFactor)), (int)((int)((float)roi.height() * szFactor)));
                try {
                    final Intent resultData = new Intent();
                    resultData.putExtra(CameraActivity.CAMERA_RESULT, (Parcelable)new CameraResult(fullImage, croppedImage));
                    CameraActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CameraActivity.this.success(-1, resultData);
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.startCameraSource();
    }

    protected void onStop() {
        super.onStop();
        this.mPreview.stop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.stopCameraSource();
    }

    private void stopCameraSource() {
        if (this.mPreview != null) {
            this.mPreview.stop();
        }
        if (this.mCameraSource != null) {
            this.mCameraSource.release();
            this.mCameraSource = null;
        }
    }

    private void startCameraSource() {
        if (this.mCameraSource != null) {
            try {
                PreviewUtil.checkPlayServices((Activity)this);
                this.mPreview.start(this.mCameraSource, this.mGraphicOverlay);
            }
            catch (IOException e) {
                Log.e((String)"startCameraSource", (String)"Unable to start camera source.", (Throwable)e);
                this.mCameraSource.release();
                this.mCameraSource = null;
            }
        }
    }

    private void startPreview() {
        this.mCameraSource = this.createCameraSource(this.mCameraFacing);
        this.startCameraSource();
    }

    public void toggleCamera() {
        this.stopCameraSource();
        this.mCameraFacing = this.mCameraFacing == 1 ? 0 : 1;
        this.startPreview();
    }

    protected CameraSource createCameraSource(int cameraFacing) {
        Context context = this.getApplicationContext();
        Detector<?> detector = this.createDetector();
        CameraSource cameraSource = new CameraSource.Builder(context, detector).setRequestedPreviewSize(1600, 1024).setRequestedFps(15.0f).setFacing(cameraFacing).build();
        return cameraSource;
    }

    protected Detector<?> createDetector() {
        CustomDetector detector = new CustomDetector();
        CustomProcessor mProcessor = new CustomProcessor();
        detector.setProcessor(mProcessor);
        return detector;
    }

    protected void success(int result, Intent resultData) {
        this.setResult(result, resultData);
        this.finish();
    }

    public static final class Setting
    implements Parcelable {
        private String message = null;
        private String waitingMessage = "No mueva la c\u00e1mara";
        private boolean showProgress = true;
        private boolean toggleButtonVisible = true;
        private boolean snapshotButtonVisible = true;
        private String cameraFacing = "user";
        private boolean forceAutoFocus = true;
        private boolean finderVisible = true;
        private int finderShape = 1;
        private float finderAspectRatio = 1.0f;
        public static final Parcelable.Creator<Setting> CREATOR = new Parcelable.Creator<Setting>(){

            public Setting createFromParcel(Parcel in) {
                return new Setting(in);
            }

            public Setting[] newArray(int size) {
                return new Setting[size];
            }
        };

        public Setting() {
        }

        protected Setting(Parcel in) {
            this.message = in.readString();
            this.waitingMessage = in.readString();
            this.showProgress = in.readByte() != 0;
            this.toggleButtonVisible = in.readByte() != 0;
            this.snapshotButtonVisible = in.readByte() != 0;
            this.cameraFacing = in.readString();
            this.forceAutoFocus = in.readByte() != 0;
            this.finderVisible = in.readByte() != 0;
            this.finderShape = in.readInt();
            this.finderAspectRatio = in.readFloat();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.message);
            dest.writeString(this.waitingMessage);
            dest.writeByte((byte)(this.showProgress ? 1 : 0));
            dest.writeByte((byte)(this.toggleButtonVisible ? 1 : 0));
            dest.writeByte((byte)(this.snapshotButtonVisible ? 1 : 0));
            dest.writeString(this.cameraFacing);
            dest.writeByte((byte)(this.forceAutoFocus ? 1 : 0));
            dest.writeByte((byte)(this.finderVisible ? 1 : 0));
            dest.writeInt(this.finderShape);
            dest.writeFloat(this.finderAspectRatio);
        }

        public int describeContents() {
            return 0;
        }

        public Setting message(String message) {
            this.message = message;
            return this;
        }

        public Setting waitingMessage(String waitingMessage) {
            this.waitingMessage = waitingMessage;
            return this;
        }

        public Setting showProgress(boolean showProgress) {
            this.showProgress = showProgress;
            return this;
        }

        public Setting toggleButtonVisible(boolean toggleButtonVisible) {
            this.toggleButtonVisible = toggleButtonVisible;
            return this;
        }

        public Setting snapshotButtonVisible(boolean snapshotButtonVisible) {
            this.snapshotButtonVisible = snapshotButtonVisible;
            return this;
        }

        public Setting cameraFacing(String cameraFacing) {
            this.cameraFacing = cameraFacing;
            return this;
        }

        public Setting forceAutoFocus(boolean forceAutoFocus) {
            this.forceAutoFocus = forceAutoFocus;
            return this;
        }

        public Setting finderVisible(boolean finderVisible) {
            this.finderVisible = finderVisible;
            return this;
        }

        public Setting finderShape(int finderShape) {
            this.finderShape = finderShape;
            return this;
        }

        public Setting finderAspectRatio(float finderAspectRatio) {
            this.finderAspectRatio = finderAspectRatio;
            return this;
        }
    }

    public static class CustomProcessor
    implements Detector.Processor {
        public void release() {
        }

        public void receiveDetections(Detector.Detections detections) {
        }
    }

    public static class CustomDetector
    extends Detector {
        public SparseArray detect(Frame frame) {
            return null;
        }
    }
}

