/*
 * Decompiled with CFR 0.152.
 */
package frameblock.vision.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class GraphicOverlay<T extends Graphic>
extends View {
    private final Object mLock = new Object();
    private int mPreviewWidth;
    private float mWidthScaleFactor = 1.0f;
    private int mPreviewHeight;
    private float mHeightScaleFactor = 1.0f;
    private int mFacing = 0;
    private Set<T> mGraphics = new HashSet<T>();

    public GraphicOverlay(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mGraphics.clear();
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T graphic) {
        Object object = this.mLock;
        synchronized (object) {
            this.mGraphics.add(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T graphic) {
        Object object = this.mLock;
        synchronized (object) {
            this.mGraphics.remove(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getGraphics() {
        Object object = this.mLock;
        synchronized (object) {
            return new Vector<T>(this.mGraphics);
        }
    }

    public float getWidthScaleFactor() {
        return this.mWidthScaleFactor;
    }

    public float getHeightScaleFactor() {
        return this.mHeightScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraInfo(int previewWidth, int previewHeight, int facing) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPreviewWidth = previewWidth;
            this.mPreviewHeight = previewHeight;
            this.mFacing = facing;
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPreviewWidth != 0 && this.mPreviewHeight != 0) {
                this.mWidthScaleFactor = (float)canvas.getWidth() / (float)this.mPreviewWidth;
                this.mHeightScaleFactor = (float)canvas.getHeight() / (float)this.mPreviewHeight;
            }
            for (Graphic graphic : this.mGraphics) {
                graphic.draw(canvas);
            }
        }
    }

    public static abstract class Graphic {
        private GraphicOverlay mOverlay;

        public Graphic(GraphicOverlay overlay) {
            this.mOverlay = overlay;
        }

        public abstract void draw(Canvas var1);

        public float scaleX(float horizontal) {
            return horizontal * this.mOverlay.mWidthScaleFactor;
        }

        public float scaleY(float vertical) {
            return vertical * this.mOverlay.mHeightScaleFactor;
        }

        public float translateX(float x) {
            if (this.mOverlay.mFacing == 1) {
                return (float)this.mOverlay.getWidth() - this.scaleX(x);
            }
            return this.scaleX(x);
        }

        public float translateY(float y) {
            return this.scaleY(y);
        }

        public float scaleUpX(float horizontal) {
            return horizontal / this.mOverlay.mWidthScaleFactor;
        }

        public float scaleUpY(float vertical) {
            return vertical / this.mOverlay.mHeightScaleFactor;
        }

        public float translateUpX(float x) {
            if (this.mOverlay.mFacing == 1) {
                return (float)this.mOverlay.getWidth() + this.scaleUpX(x);
            }
            return this.scaleUpX(x);
        }

        public float translateUpY(float y) {
            return this.scaleUpY(y);
        }

        public void postInvalidate() {
            this.mOverlay.postInvalidate();
        }
    }
}

