/*
 * Decompiled with CFR 0.152.
 */
package frameblock.vision.camera;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import com.google.android.gms.vision.Detector;
import frameblock.vision.camera.CameraSource;
import frameblock.vision.image.YuvUtil;

public class FocusedCameraSource
extends CameraSource {
    private static final float MIN_FOCUS_SCORE = 6.0f;
    private long mAutoFocusStartedAt;
    private long mAutoFocusCompletedAt;

    private FocusedCameraSource() {
    }

    @Override
    protected Camera.PreviewCallback getCameraPreviewCallback() {
        return new CameraPreviewCallback();
    }

    boolean isAutoFocusing() {
        return this.mAutoFocusCompletedAt < this.mAutoFocusStartedAt;
    }

    public static class Builder {
        private final Detector<?> mDetector;
        private FocusedCameraSource mCameraSource = new FocusedCameraSource();

        public Builder(Context context, Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.mDetector = detector;
            this.mCameraSource.mContext = context;
        }

        public Builder setRequestedFps(float fps) {
            if (fps <= 0.0f) {
                throw new IllegalArgumentException("Invalid fps: " + fps);
            }
            this.mCameraSource.mRequestedFps = fps;
            return this;
        }

        public Builder setRequestedPreviewSize(int width, int height) {
            int MAX = 1000000;
            if (width <= 0 || width > 1000000 || height <= 0 || height > 1000000) {
                throw new IllegalArgumentException("Invalid preview size: " + width + "x" + height);
            }
            this.mCameraSource.mRequestedPreviewWidth = width;
            this.mCameraSource.mRequestedPreviewHeight = height;
            return this;
        }

        public FocusedCameraSource build() {
            this.mCameraSource.mFocusMode = "auto";
            FocusedCameraSource focusedCameraSource = this.mCameraSource;
            focusedCameraSource.getClass();
            this.mCameraSource.mFrameProcessor = focusedCameraSource.new CameraSource.FrameProcessingRunnable(this.mDetector);
            return this.mCameraSource;
        }
    }

    private class CameraPreviewCallback
    implements Camera.PreviewCallback {
        private CameraPreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            int centerX = FocusedCameraSource.this.getPreviewSize().getWidth() / 3;
            int centerY = FocusedCameraSource.this.getPreviewSize().getHeight() / 3;
            Rect roi = new Rect(centerX, centerY, centerX * 2, centerY * 2);
            float score = YuvUtil.nativeFocusScore((byte[])data, (int)FocusedCameraSource.this.getPreviewSize().getWidth(), (int)FocusedCameraSource.this.getPreviewSize().getHeight(), (Rect)roi);
            if (score < 6.0f) {
                if (!FocusedCameraSource.this.isAutoFocusing()) {
                    FocusedCameraSource.this.mAutoFocusStartedAt = System.currentTimeMillis();
                    camera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            FocusedCameraSource.this.mAutoFocusCompletedAt = System.currentTimeMillis();
                        }
                    });
                }
                camera.addCallbackBuffer(data);
            } else {
                FocusedCameraSource.this.mFrameProcessor.setNextFrame(data, camera);
            }
        }
    }
}

