/*
 * Decompiled with CFR 0.152.
 */
package frameblock.vision.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.images.Size;
import frameblock.vision.camera.CameraSource;
import frameblock.vision.camera.GraphicOverlay;
import frameblock.vision.camera.PreviewUtil;
import java.io.IOException;

public class CameraSourcePreview
extends ViewGroup {
    private static final String TAG = "CameraSourcePreview";
    private Context mContext;
    private SurfaceView mSurfaceView;
    private boolean mStartRequested;
    private boolean mSurfaceAvailable;
    private CameraSource mCameraSource;
    private GraphicOverlay mOverlay;

    public CameraSourcePreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mStartRequested = false;
        this.mSurfaceAvailable = false;
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.addView((View)this.mSurfaceView);
    }

    public void start(CameraSource cameraSource) throws IOException {
        if (cameraSource == null) {
            this.stop();
        }
        this.mCameraSource = cameraSource;
        if (this.mCameraSource != null) {
            this.mStartRequested = true;
            this.startIfReady();
        }
    }

    public void start(CameraSource cameraSource, GraphicOverlay overlay) throws IOException {
        this.mOverlay = overlay;
        this.start(cameraSource);
    }

    public void stop() {
        if (this.mCameraSource != null) {
            this.mCameraSource.stop();
        }
    }

    public void release() {
        if (this.mCameraSource != null) {
            this.mCameraSource.release();
            this.mCameraSource = null;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void startIfReady() throws IOException {
        if (this.mStartRequested && this.mSurfaceAvailable) {
            this.mCameraSource.start(this.mSurfaceView.getHolder());
            if (this.mOverlay != null) {
                Size size = this.mCameraSource.getPreviewSize();
                Log.d((String)"startIfReady", (String)("PreviewSize: " + size));
                int min = Math.min(size.getWidth(), size.getHeight());
                int max = Math.max(size.getWidth(), size.getHeight());
                if (PreviewUtil.isPortraitMode(this.mContext)) {
                    this.mOverlay.setCameraInfo(min, max, this.mCameraSource.getCameraFacing());
                } else {
                    this.mOverlay.setCameraInfo(max, min, this.mCameraSource.getCameraFacing());
                }
                this.mOverlay.clear();
            }
            this.mStartRequested = false;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childHeight;
        int childWidth;
        Size size;
        int previewWidth = 320;
        int previewHeight = 240;
        if (this.mCameraSource != null && (size = this.mCameraSource.getPreviewSize()) != null) {
            previewWidth = size.getWidth();
            previewHeight = size.getHeight();
        }
        if (PreviewUtil.isPortraitMode(this.mContext)) {
            int tmp = previewWidth;
            previewWidth = previewHeight;
            previewHeight = tmp;
        }
        int viewWidth = right - left;
        int viewHeight = bottom - top;
        int childXOffset = 0;
        int childYOffset = 0;
        float widthRatio = (float)viewWidth / (float)previewWidth;
        float heightRatio = (float)viewHeight / (float)previewHeight;
        if (widthRatio > heightRatio) {
            childWidth = viewWidth;
            childHeight = (int)((float)previewHeight * widthRatio);
            childYOffset = (childHeight - viewHeight) / 2;
        } else {
            childWidth = (int)((float)previewWidth * heightRatio);
            childHeight = viewHeight;
            childXOffset = (childWidth - viewWidth) / 2;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(-1 * childXOffset, -1 * childYOffset, childWidth - childXOffset, childHeight - childYOffset);
        }
        try {
            this.startIfReady();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Could not start camera source.", (Throwable)e);
        }
        Log.d((String)"onLayout", (String)("PreviewSize: " + previewWidth + "," + previewHeight));
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = true;
            try {
                CameraSourcePreview.this.startIfReady();
                CameraSourcePreview.this.requestLayout();
            }
            catch (IOException e) {
                Log.e((String)CameraSourcePreview.TAG, (String)"Could not start camera source.", (Throwable)e);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surface) {
            CameraSourcePreview.this.mSurfaceAvailable = false;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }
    }
}

