/*
 * Decompiled with CFR 0.152.
 */
package kv.vension.radarview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kv.vension.radarview.R;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001;B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0013H\u0002J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J(\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J \u0010-\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010.\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0002J\b\u0010/\u001a\u00020$H\u0002J\u0018\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002J\u0018\u00103\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0002J\u0012\u00104\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\u0018\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007H\u0014J\b\u00108\u001a\u00020$H\u0002J\u0006\u00109\u001a\u00020$J\u0006\u0010:\u001a\u00020$R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lkv/vension/radarview/RadarView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_COLOR", "isScanning", "", "isShowCrossLine", "isShowRaindrop", "mCircleColor", "mCircleNum", "mCirclePaint", "Landroid/graphics/Paint;", "mDegrees", "", "mFlicker", "mRaindropColor", "mRaindropNum", "mRaindropPaint", "mRaindrops", "Ljava/util/ArrayList;", "Lkv/vension/radarview/RadarView$Raindrop;", "mSpeed", "mSweepColor", "mSweepPaint", "changeAlpha", "color", "alpha", "dp2px", "dpVal", "drawCircle", "", "canvas", "Landroid/graphics/Canvas;", "cx", "cy", "radius", "drawCrossLine", "drawRaindrop", "drawSweep", "generateRaindrop", "initAttrs", "initPaints", "measureHeight", "measureSpec", "defaultSize", "measureWidth", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "removeRaindrop", "start", "stop", "Raindrop", "radarview_release"})
public final class RadarView
extends View {
    private final int DEFAULT_COLOR;
    private int mCircleColor;
    private int mCircleNum;
    private int mSweepColor;
    private int mRaindropColor;
    private int mRaindropNum;
    private boolean isShowCrossLine;
    private boolean isShowRaindrop;
    private float mSpeed;
    private float mFlicker;
    private Paint mCirclePaint;
    private Paint mSweepPaint;
    private Paint mRaindropPaint;
    private float mDegrees;
    private boolean isScanning;
    private final ArrayList<Raindrop> mRaindrops;
    private HashMap _$_findViewCache;

    private final void initAttrs(Context context, int attrs) {
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.RadarView);
        this.mCircleColor = mTypedArray.getColor(R.styleable.RadarView_circleColor, this.DEFAULT_COLOR);
        this.mCircleNum = mTypedArray.getInt(R.styleable.RadarView_circleNum, this.mCircleNum);
        if (this.mCircleNum < 1) {
            this.mCircleNum = 3;
        }
        this.mSweepColor = mTypedArray.getColor(R.styleable.RadarView_sweepColor, this.DEFAULT_COLOR);
        this.mRaindropColor = mTypedArray.getColor(R.styleable.RadarView_raindropColor, this.DEFAULT_COLOR);
        this.mRaindropNum = mTypedArray.getInt(R.styleable.RadarView_raindropNum, this.mRaindropNum);
        this.isShowCrossLine = mTypedArray.getBoolean(R.styleable.RadarView_showCrossLine, true);
        this.isShowRaindrop = mTypedArray.getBoolean(R.styleable.RadarView_showRaindrop, true);
        this.mSpeed = mTypedArray.getFloat(R.styleable.RadarView_speed, this.mSpeed);
        if (this.mSpeed <= 0.0f) {
            this.mSpeed = 3.0f;
        }
        this.mFlicker = mTypedArray.getFloat(R.styleable.RadarView_flicker, this.mFlicker);
        if (this.mFlicker <= 0.0f) {
            this.mFlicker = 3.0f;
        }
        mTypedArray.recycle();
    }

    private final void initPaints() {
        Paint paint;
        Paint paint2 = new Paint();
        RadarView radarView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setColor(this.mCircleColor);
        $this$apply.setStrokeWidth(1.0f);
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setAntiAlias(true);
        radarView.mCirclePaint = paint = paint2;
        paint2 = new Paint();
        radarView = this;
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl4 = false;
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setAntiAlias(true);
        radarView.mRaindropPaint = paint = paint2;
        paint2 = new Paint();
        radarView = this;
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl5 = false;
        $this$apply.setAntiAlias(true);
        radarView.mSweepPaint = paint = paint2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        int defauleSize = this.dp2px(context, 200.0f);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec, defauleSize), this.measureHeight(heightMeasureSpec, defauleSize));
    }

    private final int measureWidth(int measureSpec, int defaultSize) {
        int n;
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = defaultSize + this.getPaddingLeft() + this.getPaddingRight();
            if (specMode == Integer.MIN_VALUE) {
                n = 0;
                result = Math.min(result, specSize);
            }
        }
        n = this.getSuggestedMinimumWidth();
        boolean bl = false;
        result = Math.max(result, n);
        return result;
    }

    private final int measureHeight(int measureSpec, int defaultSize) {
        int n;
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = defaultSize + this.getPaddingTop() + this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                n = 0;
                result = Math.min(result, specSize);
            }
        }
        n = this.getSuggestedMinimumHeight();
        boolean bl = false;
        result = Math.max(result, n);
        return result;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        int mWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int mHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        boolean bl = false;
        int radius = Math.min(mWidth, mHeight) / 2;
        int cx = this.getPaddingLeft() + (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / 2;
        int cy = this.getPaddingTop() + (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom()) / 2;
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        this.drawCircle(canvas2, cx, cy, radius);
        if (this.isShowCrossLine) {
            this.drawCrossLine(canvas, cx, cy, radius);
        }
        if (this.isScanning) {
            if (this.isShowRaindrop) {
                this.drawRaindrop(canvas, cx, cy, radius);
            }
            this.drawSweep(canvas, cx, cy, radius);
            this.mDegrees = (this.mDegrees + 360.0f / this.mSpeed / 60.0f) % (float)360;
            this.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCircle(Canvas canvas, int cx, int cy, int radius) {
        int n = 0;
        int n2 = this.mCircleNum;
        while (n < n2) {
            void i;
            float f = cx;
            float f2 = cy;
            float f3 = radius - radius / this.mCircleNum * i;
            Paint paint = this.mCirclePaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCirclePaint");
            }
            canvas.drawCircle(f, f2, f3, paint);
            ++i;
        }
    }

    private final void drawCrossLine(Canvas canvas, int cx, int cy, int radius) {
        float f = cx - radius;
        float f2 = cy;
        float f3 = cx + radius;
        float f4 = cy;
        Paint paint = this.mCirclePaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCirclePaint");
        }
        canvas.drawLine(f, f2, f3, f4, paint);
        float f5 = cx;
        float f6 = cy - radius;
        float f7 = cx;
        float f8 = cy + radius;
        Paint paint2 = this.mCirclePaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCirclePaint");
        }
        canvas.drawLine(f5, f6, f7, f8, paint2);
    }

    private final void drawRaindrop(Canvas canvas, int cx, int cy, int radius) {
        this.generateRaindrop(cx, cy, radius);
        for (Raindrop raindrop : this.mRaindrops) {
            Paint paint = this.mRaindropPaint;
            if (paint == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mRaindropPaint");
            }
            paint.setColor(raindrop.changeAlpha$radarview_release());
            float f = raindrop.getX$radarview_release();
            float f2 = raindrop.getY$radarview_release();
            float f3 = raindrop.getRadius$radarview_release();
            Paint paint2 = this.mRaindropPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mRaindropPaint");
            }
            canvas.drawCircle(f, f2, f3, paint2);
            Raindrop raindrop2 = raindrop;
            raindrop2.setRadius$radarview_release(raindrop2.getRadius$radarview_release() + 0.33333334f / this.mFlicker);
            Raindrop raindrop3 = raindrop;
            raindrop3.setAlpha$radarview_release(raindrop3.getAlpha$radarview_release() - 4.25f / this.mFlicker);
        }
        this.removeRaindrop();
    }

    private final void drawSweep(Canvas canvas, int cx, int cy, int radius) {
        SweepGradient sweepGradient = new SweepGradient((float)cx, (float)cy, new int[]{0, this.changeAlpha(this.mSweepColor, 0), this.changeAlpha(this.mSweepColor, 168), this.changeAlpha(this.mSweepColor, 255), this.changeAlpha(this.mSweepColor, 255)}, new float[]{0.0f, 0.6f, 0.99f, 0.998f, 1.0f});
        Paint paint = this.mSweepPaint;
        if (paint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mSweepPaint");
        }
        paint.setShader((Shader)sweepGradient);
        canvas.rotate((float)-90 + this.mDegrees, (float)cx, (float)cy);
        float f = cx;
        float f2 = cy;
        float f3 = radius;
        Paint paint2 = this.mSweepPaint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mSweepPaint");
        }
        canvas.drawCircle(f, f2, f3, paint2);
    }

    private final void generateRaindrop(int cx, int cy, int radius) {
        if (this.mRaindrops.size() < this.mRaindropNum) {
            boolean probability;
            boolean bl = probability = (int)(Math.random() * (double)20) == 0;
            if (probability) {
                int x = 0;
                int y = 0;
                int xOffset = (int)(Math.random() * (double)(radius - 20));
                double d = 1.0 * (double)(radius - 20) * (double)(radius - 20) - (double)(xOffset * xOffset);
                double d2 = Math.random();
                boolean bl2 = false;
                double d3 = Math.sqrt(d);
                int yOffset = (int)(d2 * (double)((int)d3));
                x = (int)(Math.random() * (double)2) == 0 ? cx - xOffset : cx + xOffset;
                y = (int)(Math.random() * (double)2) == 0 ? cy - yOffset : cy + yOffset;
                this.mRaindrops.add(new Raindrop(x, y, 0.0f, this.mRaindropColor));
            }
        }
    }

    private final void removeRaindrop() {
        Iterator<Raindrop> iterator = this.mRaindrops.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"mRaindrops.iterator()");
        Iterator<Raindrop> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Raindrop raindrop;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator2.next(), (String)"iterator.next()");
            if (!(raindrop.getRadius$radarview_release() > (float)20) && !(raindrop.getAlpha$radarview_release() < 0.0f)) continue;
            iterator2.remove();
        }
    }

    public final void start() {
        if (!this.isScanning) {
            this.isScanning = true;
            this.invalidate();
        }
    }

    public final void stop() {
        if (this.isScanning) {
            this.isScanning = false;
            this.mRaindrops.clear();
            this.mDegrees = 0.0f;
        }
    }

    private final int changeAlpha(int color, int alpha) {
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private final int dp2px(Context context, float dpVal) {
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)resources.getDisplayMetrics());
    }

    @JvmOverloads
    public RadarView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mCircleColor = this.DEFAULT_COLOR = Color.parseColor((String)"#FF9800");
        this.mCircleNum = 3;
        this.mSweepColor = this.DEFAULT_COLOR;
        this.mRaindropColor = this.DEFAULT_COLOR;
        this.mRaindropNum = 5;
        this.isShowCrossLine = true;
        this.isShowRaindrop = true;
        this.mSpeed = 3.0f;
        this.mFlicker = 3.0f;
        this.mRaindrops = new ArrayList();
        this.initAttrs(context, defStyleAttr);
        this.initPaints();
    }

    public /* synthetic */ RadarView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public RadarView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RadarView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0014\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0018\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0019R\u001a\u0010\t\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lkv/vension/radarview/RadarView$Raindrop;", "", "x", "", "y", "radius", "", "color", "(Lkv/vension/radarview/RadarView;IIFI)V", "alpha", "getAlpha$radarview_release", "()F", "setAlpha$radarview_release", "(F)V", "getColor$radarview_release", "()I", "setColor$radarview_release", "(I)V", "getRadius$radarview_release", "setRadius$radarview_release", "getX$radarview_release", "setX$radarview_release", "getY$radarview_release", "setY$radarview_release", "changeAlpha", "changeAlpha$radarview_release", "radarview_release"})
    private final class Raindrop {
        private float alpha;
        private int x;
        private int y;
        private float radius;
        private int color;

        public final float getAlpha$radarview_release() {
            return this.alpha;
        }

        public final void setAlpha$radarview_release(float f) {
            this.alpha = f;
        }

        public final int changeAlpha$radarview_release() {
            int red = Color.red((int)this.color);
            int green = Color.green((int)this.color);
            int blue = Color.blue((int)this.color);
            return Color.argb((int)((int)this.alpha), (int)red, (int)green, (int)blue);
        }

        public final int getX$radarview_release() {
            return this.x;
        }

        public final void setX$radarview_release(int n) {
            this.x = n;
        }

        public final int getY$radarview_release() {
            return this.y;
        }

        public final void setY$radarview_release(int n) {
            this.y = n;
        }

        public final float getRadius$radarview_release() {
            return this.radius;
        }

        public final void setRadius$radarview_release(float f) {
            this.radius = f;
        }

        public final int getColor$radarview_release() {
            return this.color;
        }

        public final void setColor$radarview_release(int n) {
            this.color = n;
        }

        public Raindrop(int x, int y, float radius, int color) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.color = color;
            this.alpha = 255.0f;
        }
    }
}

