/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.sphinx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public final class SphinxUtil {
    public static void convertLineSeparators(File dir) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                SphinxUtil.convertLineSeparators(f);
                continue;
            }
            if (!SphinxUtil.isTextFile(f)) continue;
            SphinxUtil.convertLineSeparators(f, System.lineSeparator());
        }
    }

    private static void convertLineSeparators(File f, String lineSeparatorStr) throws IOException {
        byte[] newContent;
        assert (f.length() <= Integer.MAX_VALUE) : "text file larger than 2 GiB";
        byte[] content = new byte[(int)f.length()];
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            int readBytes;
            for (int i = 0; i < content.length; i += readBytes) {
                readBytes = raf.read(content, i, content.length - i);
                if (readBytes >= 0) continue;
                throw new IOException("file size has been changed during processing: " + f);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(content.length);
        byte[] lineSeparator = lineSeparatorStr.getBytes("US-ASCII");
        int lastByte = 0;
        for (int n : content) {
            if (n == 0) {
                return;
            }
            if (n == 10) {
                out.write(lineSeparator);
            } else {
                if (lastByte == 13) {
                    out.write(lineSeparator);
                }
                if (n != 13) {
                    out.write(n);
                }
            }
            lastByte = n;
        }
        if (lastByte == 13) {
            out.write(lineSeparator);
        }
        if (Arrays.equals(content, newContent = out.toByteArray())) {
            return;
        }
        try (FileOutputStream fout = new FileOutputStream(f);){
            fout.write(newContent);
        }
    }

    private static boolean isTextFile(File f) {
        String extension;
        if (!f.isFile()) {
            return false;
        }
        String name = f.getName();
        int lastDotIdx = name.lastIndexOf(46);
        if (lastDotIdx < 0) {
            return false;
        }
        switch (extension = name.substring(lastDotIdx + 1)) {
            case "buildinfo": 
            case "html": 
            case "css": 
            case "js": 
            case "svg": 
            case "txt": 
            case "xml": {
                return true;
            }
            case "map": {
                return name.endsWith(".css.map") || name.endsWith(".js.map");
            }
        }
        return false;
    }

    private SphinxUtil() {
    }
}

